/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jcache.simple;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerBuilder;
import javax.management.MBeanServerDelegate;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public class ConfigurableMBeanServerIdBuilder
extends MBeanServerBuilder {
    private static ConcurrentMap<Key, MBeanServer> JVM_SINGLETONS = new ConcurrentHashMap<Key, MBeanServer>();

    @Override
    public MBeanServer newMBeanServer(String defaultDomain, MBeanServer outer, MBeanServerDelegate delegate) {
        MBeanServer existing;
        Key key = new Key(defaultDomain, outer);
        MBeanServer server = (MBeanServer)JVM_SINGLETONS.get(key);
        if (server == null && (existing = JVM_SINGLETONS.putIfAbsent(key, server = super.newMBeanServer(defaultDomain, outer, new ForceIdMBeanServerDelegate(delegate)))) != null) {
            server = existing;
        }
        return server;
    }

    private class ForceIdMBeanServerDelegate
    extends MBeanServerDelegate {
        private final MBeanServerDelegate delegate;

        public ForceIdMBeanServerDelegate(MBeanServerDelegate delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getMBeanServerId() {
            return System.getProperty("org.jsr107.tck.management.agentId", this.delegate.getMBeanServerId());
        }

        @Override
        public String getSpecificationName() {
            return this.delegate.getSpecificationName();
        }

        @Override
        public String getSpecificationVersion() {
            return this.delegate.getSpecificationVersion();
        }

        @Override
        public String getSpecificationVendor() {
            return this.delegate.getSpecificationVendor();
        }

        @Override
        public String getImplementationName() {
            return this.delegate.getImplementationName();
        }

        @Override
        public String getImplementationVersion() {
            return this.delegate.getImplementationVersion();
        }

        @Override
        public String getImplementationVendor() {
            return this.delegate.getImplementationVendor();
        }

        @Override
        public MBeanNotificationInfo[] getNotificationInfo() {
            return this.delegate.getNotificationInfo();
        }

        @Override
        public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
            this.delegate.addNotificationListener(listener, filter, handback);
        }

        @Override
        public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
            this.delegate.removeNotificationListener(listener, filter, handback);
        }

        @Override
        public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
            this.delegate.removeNotificationListener(listener);
        }

        @Override
        public void sendNotification(Notification notification) {
            this.delegate.sendNotification(notification);
        }
    }

    private static class Key {
        private final String domain;
        private final MBeanServer outer;

        private Key(String domain, MBeanServer outer) {
            this.domain = domain;
            this.outer = outer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)Key.class.cast(o);
            return !(this.domain == null ? key.domain != null : !this.domain.equals(key.domain)) && !(this.outer == null ? key.outer != null : !this.outer.equals(key.outer));
        }

        public int hashCode() {
            int result = this.domain != null ? this.domain.hashCode() : 0;
            result = 31 * result + (this.outer != null ? this.outer.hashCode() : 0);
            return result;
        }
    }
}

