/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.service;

import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.talend.sdk.component.server.configuration.ComponentServerConfiguration;

@ApplicationScoped
public class LocaleMapper {
    @Inject
    private ComponentServerConfiguration configuration;
    private Map<Predicate<String>, String> mapping;

    @PostConstruct
    private void init() {
        Properties properties = new Properties();
        try (StringReader reader = new StringReader(this.configuration.getLocaleMapping());){
            properties.load(reader);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        this.mapping = properties.stringPropertyNames().stream().collect(Collectors.toMap(it -> {
            if (it.endsWith("*")) {
                String prefix = it.substring(0, it.length() - 1);
                return s -> s.startsWith(prefix);
            }
            return s -> s.equals(it);
        }, properties::getProperty));
    }

    public Locale mapLocale(String requested) {
        return new Locale(this.getLanguage(requested).toLowerCase(Locale.ENGLISH));
    }

    private String getLanguage(String requested) {
        if (requested == null) {
            return "en";
        }
        return this.mapping.entrySet().stream().filter(it -> ((Predicate)it.getKey()).test(requested)).findFirst().map(Map.Entry::getValue).orElse("en");
    }
}

