/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.container;

import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.classloader.ConfigurableClassLoader;
import org.talend.sdk.component.container.AutoClassFileTransformer;
import org.talend.sdk.component.container.ContainerManager;
import org.talend.sdk.component.dependencies.maven.Artifact;
import org.talend.sdk.component.lang.UnsafeSupplier;
import org.talend.sdk.component.lifecycle.Lifecycle;
import org.talend.sdk.component.lifecycle.LifecycleSupport;
import org.talend.sdk.component.path.PathFactory;
import org.talend.sdk.component.proxy.ApiHandler;

public class Container
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(Container.class);
    private final AtomicReference<ConfigurableClassLoader> loaderRef = new AtomicReference();
    private final String id;
    private final String rootModule;
    private final Artifact[] dependencies;
    private final AtomicReference<Date> created = new AtomicReference();
    private final AtomicReference<Date> lastModifiedTimestamp = new AtomicReference();
    private final Supplier<ConfigurableClassLoader> classloaderProvider;
    private final Function<String, Path> localDependencyRelativeResolver;
    private final LifecycleSupport lifecycle = new LifecycleSupport();
    private final ConcurrentMap<Class<?>, Object> data = new ConcurrentHashMap();
    private final AtomicReference<State> state = new AtomicReference<State>(State.CREATED);
    private final Collection<ClassFileTransformer> transformers = new ArrayList<ClassFileTransformer>();
    private final boolean hasNestedRepository;

    public Container(String id, String rootModule, Artifact[] dependencies, ContainerManager.ClassLoaderConfiguration configuration, Function<String, Path> localDependencyRelativeResolver, Consumer<Container> initializer, String[] jvmMarkers, boolean hasNestedRepository) {
        this.id = id;
        this.rootModule = rootModule;
        this.dependencies = dependencies;
        this.localDependencyRelativeResolver = localDependencyRelativeResolver;
        this.lastModifiedTimestamp.set(new Date(0L));
        this.hasNestedRepository = hasNestedRepository;
        Optional.ofNullable(initializer).ifPresent(i -> i.accept(this));
        this.classloaderProvider = () -> {
            List existingClasspathFiles = this.findExistingClasspathFiles().collect(Collectors.toList());
            URL[] urls = (URL[])existingClasspathFiles.stream().peek(this::visitLastModified).map(f -> {
                try {
                    return f.toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException(e);
                }
            }).toArray(URL[]::new);
            ContainerManager.ClassLoaderConfiguration overrideClassLoaderConfig = Optional.ofNullable(this.get(ContainerManager.ClassLoaderConfiguration.class)).orElse(configuration);
            Path rootFile = Optional.of(rootModule).map(PathFactory::get).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).orElseGet(() -> (Path)localDependencyRelativeResolver.apply(rootModule));
            Predicate resourceExists = Optional.of(rootFile).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(it -> it.getFileName().toString().endsWith(".jar")).map(this::jarIndex).orElseGet(() -> s -> Optional.of(rootFile.resolve("MAVEN-INF/repository/" + s)).map(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(it -> it).orElseGet(() -> this.findNestedDependency(overrideClassLoaderConfig, (String)s)));
            String[] rawNestedDependencies = this.hasNestedRepository ? (String[])Stream.concat(Stream.of(rootModule), Stream.of(dependencies).map(Artifact::toPath)).filter(it -> resourceExists.test(it) || this.findNestedDependency(overrideClassLoaderConfig, (String)it)).distinct().toArray(String[]::new) : null;
            ConfigurableClassLoader loader = new ConfigurableClassLoader(id, urls, overrideClassLoaderConfig.getParent(), overrideClassLoaderConfig.getParentClassesFilter(), overrideClassLoaderConfig.getClassesFilter(), rawNestedDependencies, jvmMarkers);
            this.transformers.forEach(loader::registerTransformer);
            this.activeSpecificTransformers(loader);
            return loader;
        };
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activeSpecificTransformers(ConfigurableClassLoader loader) {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(loader);
        try {
            ServiceLoader.load(AutoClassFileTransformer.class, loader).forEach(this::registerTransformer);
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    private boolean findNestedDependency(ContainerManager.ClassLoaderConfiguration overrideClassLoaderConfig, String depPath) {
        if (!this.hasNestedRepository) {
            return false;
        }
        URL url = overrideClassLoaderConfig.getParent().getResource("MAVEN-INF/repository/" + depPath);
        return url != null;
    }

    private void visitLastModified(Path f) {
        long lastModified;
        try {
            FileTime lastModifiedTime = Files.getLastModifiedTime(f, new LinkOption[0]);
            lastModified = lastModifiedTime.toMillis();
        }
        catch (IOException e) {
            lastModified = f.toFile().lastModified();
        }
        if (lastModified > 0L && new Date(lastModified).compareTo(this.lastModifiedTimestamp.get()) > 0) {
            this.lastModifiedTimestamp.set(new Date(lastModified));
        }
    }

    private Predicate<String> jarIndex(Path rootFile) {
        Predicate<String> predicate;
        if (!this.hasNestedRepository) {
            return n -> false;
        }
        JarFile jarFile = new JarFile(rootFile.toFile());
        try {
            Set entries = Collections.list(jarFile.entries()).stream().map(ZipEntry::getName).filter(n -> n.startsWith("MAVEN-INF/repository/")).map(n -> n.substring("MAVEN-INF/repository/".length())).collect(Collectors.toSet());
            predicate = entries::contains;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        jarFile.close();
        return predicate;
    }

    public <T> T set(Class<T> key, T instance) {
        return this.data.put(key, instance);
    }

    public <T> T get(Class<T> key) {
        return (T)this.data.get(key);
    }

    public <T> T remove(Class<T> key) {
        return (T)this.data.remove(key);
    }

    public Stream<Path> findExistingClasspathFiles() {
        return Stream.concat(this.getContainerFile().map(Stream::of).orElseGet(Stream::empty), Stream.of(this.dependencies).map(Artifact::toPath).map(this.localDependencyRelativeResolver)).filter(x$0 -> Files.exists(x$0, new LinkOption[0]));
    }

    public Optional<Path> getContainerFile() {
        return Optional.of(this.rootModule).map(m -> Optional.of(PathFactory.get(m)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).orElseGet(() -> this.localDependencyRelativeResolver.apply((String)m)));
    }

    public Stream<Artifact> findDependencies() {
        return Stream.of(this.dependencies);
    }

    public <S, T> T executeAndContextualize(Supplier<S> supplier, Class<T> api) {
        this.checkState();
        if (!api.isInterface()) {
            throw new IllegalArgumentException("Only interfaces are supported for now: " + api);
        }
        try {
            this.loaderRef.get().getParent().loadClass(api.getName());
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new IllegalArgumentException("executeAndContextualize only usable with parent API");
        }
        S result = this.execute(supplier);
        return api.isInstance(result) ? api.cast(result) : api.cast(Proxy.newProxyInstance(this.loaderRef.get(), new Class[]{api}, (InvocationHandler)new ApiHandler(result, api, this::withTccl)));
    }

    public <T> T execute(Supplier<T> supplier) {
        try {
            return (T)this.withTccl(supplier::get);
        }
        catch (Error | RuntimeException re) {
            throw re;
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(throwable);
        }
    }

    public ConfigurableClassLoader getLoader() {
        return this.loaderRef.get();
    }

    public State getState() {
        return this.state.get();
    }

    public void setState(State newState) {
        this.state.set(newState);
    }

    @Override
    public synchronized void close() {
        this.lifecycle.closeIfNeeded(() -> {
            this.doClose();
            this.loaderRef.set(null);
        });
    }

    @Override
    public boolean isClosed() {
        return this.lifecycle.isClosed();
    }

    public synchronized void reload() {
        this.checkState();
        this.doClose();
        this.loaderRef.set(this.classloaderProvider.get());
        this.created.set(new Date());
    }

    public Date getLastModifiedTimestamp() {
        return this.lastModifiedTimestamp.get();
    }

    public Date getCreated() {
        return this.created.get();
    }

    public void registerTransformer(ClassFileTransformer transformer) {
        this.transformers.add(transformer);
    }

    private void checkState() {
        if (this.lifecycle.isClosed()) {
            throw new IllegalStateException("Container '" + this.id + "' is already closed");
        }
    }

    private void doClose() {
        Optional.ofNullable(this.loaderRef.get()).ifPresent(c -> {
            try {
                c.close();
            }
            catch (IOException e) {
                log.debug(e.getMessage(), (Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withTccl(UnsafeSupplier<T> supplier) throws Throwable {
        this.checkState();
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        ClassLoader contextualLoader = this.loaderRef.get();
        thread.setContextClassLoader(contextualLoader);
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getRootModule() {
        return this.rootModule;
    }

    public Artifact[] getDependencies() {
        return this.dependencies;
    }

    public Function<String, Path> getLocalDependencyRelativeResolver() {
        return this.localDependencyRelativeResolver;
    }

    public static enum State {
        CREATED,
        DEPLOYED,
        ON_ERROR,
        UNDEPLOYING,
        UNDEPLOYED;

    }
}

