/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.cxf;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.AbstractEndpointFactory;
import org.apache.meecrowave.configuration.Configuration;
import org.apache.meecrowave.cxf.JAXWSAddressMapper;
import org.apache.meecrowave.cxf.WsMapping;
import org.apache.meecrowave.logging.tomcat.LogFacade;
import org.apache.webbeans.component.OwbBean;

public class JAXWSCdiExtension
implements Extension {
    private final Impl impl = new Impl();

    public <T> void collect(@Observes ProcessBean<T> processBean) {
        this.impl.collect(processBean);
    }

    public void load(@Observes AfterDeploymentValidation afterDeploymentValidation, BeanManager beanManager) {
        this.impl.load(afterDeploymentValidation, beanManager);
    }

    public void release(@Observes BeforeShutdown beforeShutdown) {
        this.impl.release(beforeShutdown);
    }

    private static class Impl
    implements Extension {
        private boolean active;
        private Class<? extends Annotation> marker;
        private final List<Bean<?>> serviceBeans = new ArrayList();
        private final Collection<Runnable> preShutdownTasks = new ArrayList<Runnable>();

        private Impl() {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                loader.loadClass("org.apache.cxf.jaxws.JaxWsServerFactoryBean");
                loader.loadClass("org.apache.cxf.service.model.SchemaInfo");
                this.marker = loader.loadClass("javax.jws.WebService");
                this.active = true;
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                this.active = false;
            }
        }

        public <T> void collect(@Observes ProcessBean<T> processBean) {
            if (this.active && processBean.getAnnotated().isAnnotationPresent(this.marker)) {
                this.serviceBeans.add(processBean.getBean());
            }
        }

        public void load(@Observes AfterDeploymentValidation afterDeploymentValidation, BeanManager beanManager) {
            if (!this.active || this.serviceBeans.isEmpty() || !((Configuration)Configuration.class.cast(beanManager.getReference(beanManager.resolve(beanManager.getBeans(Configuration.class, new Annotation[0])), Configuration.class, null))).isJaxwsSupportIfAvailable()) {
                return;
            }
            Bean busBean = beanManager.resolve(beanManager.getBeans("cxf"));
            Bus bus = (Bus)Bus.class.cast(beanManager.getReference(busBean, Bus.class, beanManager.createCreationalContext((Contextual)busBean)));
            Bean mapperBean = beanManager.resolve(beanManager.getBeans(JAXWSAddressMapper.class, new Annotation[0]));
            JAXWSAddressMapper mapper = mapperBean == null ? type -> {
                WsMapping wsMapping = type.getAnnotation(WsMapping.class);
                return wsMapping != null ? wsMapping.value() : "/webservices/" + type.getSimpleName();
            } : (JAXWSAddressMapper)JAXWSAddressMapper.class.cast(beanManager.getReference(mapperBean, JAXWSAddressMapper.class, beanManager.createCreationalContext((Contextual)mapperBean)));
            this.serviceBeans.forEach(bean -> {
                Class beanClass = OwbBean.class.isInstance(bean) ? ((OwbBean)OwbBean.class.cast(bean)).getReturnType() : bean.getBeanClass();
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    AbstractEndpointFactory aef = (AbstractEndpointFactory)AbstractEndpointFactory.class.cast(loader.loadClass("org.apache.cxf.jaxws.JaxWsServerFactoryBean").getConstructor(new Class[0]).newInstance(new Object[0]));
                    aef.setBus(bus);
                    aef.setAddress(mapper.map(beanClass));
                    Class<?> factoryClass = aef.getClass();
                    factoryClass.getMethod("setStart", Boolean.TYPE).invoke((Object)aef, true);
                    factoryClass.getMethod("setServiceClass", Class.class).invoke((Object)aef, beanClass);
                    CreationalContext creationalContext = beanManager.createCreationalContext(null);
                    if (!beanManager.isNormalScope(bean.getScope())) {
                        this.preShutdownTasks.add(() -> ((CreationalContext)creationalContext).release());
                    }
                    factoryClass.getMethod("setServiceBean", Object.class).invoke((Object)aef, beanManager.getReference(bean, Object.class, creationalContext));
                    Object server = factoryClass.getMethod("create", new Class[0]).invoke((Object)aef, new Object[0]);
                    Class<?> serverClass = server.getClass();
                    serverClass.getMethod("start", new Class[0]).invoke(server, new Object[0]);
                    this.preShutdownTasks.add(() -> {
                        try {
                            serverClass.getMethod("destroy", new Class[0]).invoke(server, new Object[0]);
                        }
                        catch (IllegalAccessException | NoClassDefFoundError | NoSuchMethodException e) {
                            throw new IllegalStateException(e);
                        }
                        catch (InvocationTargetException e) {
                            throw new IllegalStateException(e.getCause());
                        }
                    });
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoClassDefFoundError | NoSuchMethodException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException(e.getCause());
                }
            });
            this.serviceBeans.clear();
        }

        public void release(@Observes BeforeShutdown beforeShutdown) {
            this.preShutdownTasks.stream().map(r -> () -> {
                try {
                    r.run();
                }
                catch (RuntimeException re) {
                    new LogFacade(JAXWSCdiExtension.class.getName()).warn(re.getMessage(), re);
                }
            }).forEach(Runnable::run);
            this.preShutdownTasks.clear();
        }
    }
}

