/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.json.stream.JsonParsingException;
import org.apache.johnzon.core.JsonChars;
import org.apache.johnzon.core.JsonLocationImpl;

class Strings
implements JsonChars {
    private static final String UNICODE_PREFIX = "\\u";
    private static final String UNICODE_PREFIX_HELPER = "000";
    private static final ConcurrentMap<Character, String> UNICODE_CACHE = new ConcurrentHashMap<Character, String>();

    static char asEscapedChar(char current) {
        switch (current) {
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case 'n': {
                return '\n';
            }
            case '\"': {
                return '\"';
            }
            case '\\': {
                return '\\';
            }
            case '/': {
                return '/';
            }
            case '[': {
                return '[';
            }
            case ']': {
                return ']';
            }
        }
        if (Character.isHighSurrogate(current) || Character.isLowSurrogate(current)) {
            return current;
        }
        throw new JsonParsingException("Invalid escape sequence '" + current + "' (Codepoint: " + String.valueOf(current).codePointAt(0), JsonLocationImpl.UNKNOWN_LOCATION);
    }

    static void appendEscaped(String value, StringBuilder builder) {
        int length = value.length();
        int nextStart = 0;
        block8: for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c != '\"' && c != '\\') continue;
            if (nextStart < i) {
                builder.append(value, nextStart, i);
            }
            nextStart = i + 1;
            switch (c) {
                case '\"': 
                case '\\': {
                    builder.append('\\').append(c);
                    continue block8;
                }
                case '\n': {
                    builder.append("\\n");
                    continue block8;
                }
                case '\r': {
                    builder.append("\\r");
                    continue block8;
                }
                case '\t': {
                    builder.append("\\t");
                    continue block8;
                }
                case '\b': {
                    builder.append("\\b");
                    continue block8;
                }
                case '\f': {
                    builder.append("\\f");
                    continue block8;
                }
                default: {
                    builder.append(Strings.toUnicode(c));
                }
            }
        }
        if (nextStart < length) {
            builder.append(value, nextStart, length);
        }
    }

    private static String toUnicode(char c) {
        String found = (String)UNICODE_CACHE.get(Character.valueOf(c));
        if (found != null) {
            return found;
        }
        String hex = UNICODE_PREFIX_HELPER + Integer.toHexString(c);
        String s = UNICODE_PREFIX + hex.substring(hex.length() - 4);
        UNICODE_CACHE.putIfAbsent(Character.valueOf(c), s);
        return s;
    }

    private Strings() {
    }
}

