/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.container;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.classloader.ConfigurableClassLoader;
import org.talend.sdk.component.container.Container;
import org.talend.sdk.component.container.ContainerListener;
import org.talend.sdk.component.dependencies.Resolver;
import org.talend.sdk.component.dependencies.maven.Artifact;
import org.talend.sdk.component.jar.Jars;
import org.talend.sdk.component.lifecycle.Lifecycle;
import org.talend.sdk.component.lifecycle.LifecycleSupport;
import org.talend.sdk.component.path.PathFactory;

public class ContainerManager
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(ContainerManager.class);
    private static final Consumer<Container> NOOP_CUSTOMIZER = c -> {};
    private final ConcurrentMap<String, Container> containers = new ConcurrentHashMap<String, Container>();
    private final ClassLoaderConfiguration classLoaderConfiguration;
    private final Resolver resolver;
    private final Path rootRepositoryLocation;
    private final Consumer<Container> containerInitializer;
    private final LifecycleSupport lifecycle = new LifecycleSupport();
    private final Collection<ContainerListener> listeners = new CopyOnWriteArrayList<ContainerListener>();
    private final Map<String, String> nestedContainerMapping = new HashMap<String, String>();
    private final String containerId = UUID.randomUUID().toString();
    private final Level logInfoLevelMapping;
    private final String[] jvmMarkers;
    private final boolean hasNestedRepository;

    public ContainerManager(DependenciesResolutionConfiguration dependenciesResolutionConfiguration, ClassLoaderConfiguration classLoaderConfiguration, Consumer<Container> containerInitializer, Level logInfoLevelMapping) {
        this.logInfoLevelMapping = logInfoLevelMapping;
        this.containerInitializer = containerInitializer;
        this.resolver = dependenciesResolutionConfiguration.getResolver();
        this.rootRepositoryLocation = Optional.ofNullable(dependenciesResolutionConfiguration.getRootRepositoryLocation()).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).orElseGet(() -> PathFactory.get(System.getProperty("user.home", "")).resolve(".m2/repository"));
        if (log.isDebugEnabled()) {
            log.debug("Using root repository: " + this.rootRepositoryLocation.toAbsolutePath());
        }
        final String nestedPluginMappingResource = Optional.ofNullable(classLoaderConfiguration.getNestedPluginMappingResource()).orElse("TALEND-INF/plugins.properties");
        this.classLoaderConfiguration = new ClassLoaderConfiguration(Optional.ofNullable(classLoaderConfiguration.getParent()).orElseGet(ContainerManager.class::getClassLoader), Optional.ofNullable(classLoaderConfiguration.getClassesFilter()).orElseGet(() -> name -> true), Optional.ofNullable(classLoaderConfiguration.getParentClassesFilter()).orElseGet(() -> name -> true), classLoaderConfiguration.isSupportsResourceDependencies(), nestedPluginMappingResource);
        if (classLoaderConfiguration.isSupportsResourceDependencies()) {
            try (final InputStream mappingStream = classLoaderConfiguration.getParent().getResourceAsStream(nestedPluginMappingResource);){
                if (mappingStream != null) {
                    Properties properties = new Properties(){
                        {
                            ContainerManager.this.info("Loading " + nestedPluginMappingResource);
                            this.load(mappingStream);
                        }
                    };
                    this.nestedContainerMapping.putAll(properties.stringPropertyNames().stream().collect(Collectors.toMap(Function.identity(), properties::getProperty)));
                    this.info("Mapped " + this.getDefinedNestedPlugin() + " plugins");
                }
                this.info("No " + nestedPluginMappingResource + " found, will use file resolution");
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        } else {
            this.info("Container " + this.containerId + " not supporting nested plugin loading, skipping");
        }
        this.jvmMarkers = (String[])Stream.concat(Stream.concat(Stream.of(this.getJre()), this.getComponentModules()), this.getCustomJvmMarkers()).toArray(String[]::new);
        this.hasNestedRepository = this.classLoaderConfiguration.isSupportsResourceDependencies() && this.classLoaderConfiguration.getParent().getResource("MAVEN-INF/repository/") != null;
    }

    public File getRootRepositoryLocation() {
        return this.rootRepositoryLocation.toFile();
    }

    public Path getRootRepositoryLocationPath() {
        return this.rootRepositoryLocation;
    }

    private void info(String msg) {
        switch (this.logInfoLevelMapping.intValue()) {
            case 500: {
                log.debug(msg);
                break;
            }
            default: {
                log.info(msg);
            }
        }
    }

    private static RuntimeException safeInvoke(Runnable task) {
        try {
            task.run();
        }
        catch (RuntimeException re) {
            log.error(re.getMessage(), (Throwable)re);
            return re;
        }
        return null;
    }

    public Set<String> getDefinedNestedPlugin() {
        return this.nestedContainerMapping.keySet();
    }

    public ContainerManager registerListener(ContainerListener instance) {
        this.listeners.add(instance);
        return this;
    }

    public ContainerManager unregisterListener(ContainerListener instance) {
        this.listeners.remove(instance);
        return this;
    }

    public ContainerBuilder builder(String id, String module) {
        return new ContainerBuilder(id, module, null, Collections.emptySet());
    }

    public Path resolve(String path) {
        String relativePath;
        Path file;
        Path direct = PathFactory.get(path);
        if (Files.exists(direct, new LinkOption[0])) {
            return direct;
        }
        String[] coords = path.split(":");
        if (coords.length > 2 && Files.exists(file = this.rootRepositoryLocation.resolve(relativePath = String.format("%s/%s/%s/%s-%s%s.%s", coords[0].replace('.', '/'), coords[1], coords[2], coords[1], coords[2], coords.length == 5 ? coords[4] : "", coords.length >= 4 ? coords[3] : "jar")), new LinkOption[0])) {
            return file;
        }
        Path file2 = this.rootRepositoryLocation.resolve(path);
        if (Files.exists(file2, new LinkOption[0])) {
            return file2;
        }
        Path libFile = this.rootRepositoryLocation.resolve(path.substring(path.lastIndexOf(47) + 1));
        if (Files.exists(libFile, new LinkOption[0])) {
            return libFile;
        }
        return file2;
    }

    public ContainerBuilder builder(String module) {
        return this.builder(this.buildAutoIdFromName(module), module);
    }

    public String buildAutoIdFromName(String module) {
        String autoId;
        String[] segments = module.split(":");
        if (segments.length > 2) {
            return segments[1];
        }
        int lastSep = module.replace(File.separatorChar, '/').lastIndexOf(47);
        String string = autoId = lastSep > 0 ? module.substring(lastSep + 1) : module;
        if (autoId.endsWith(".jar")) {
            autoId = autoId.substring(0, autoId.length() - ".jar".length());
        }
        if (autoId.endsWith("-SNAPSHOT")) {
            autoId = autoId.substring(0, autoId.length() - "-SNAPSHOT".length());
        }
        if (autoId.isEmpty()) {
            throw new IllegalArgumentException("Invalid name for plugin: " + module);
        }
        int end = autoId.length() - 1;
        for (int i = 0; i < 3; ++i) {
            boolean valid;
            while (end > 0 && Character.isDigit(autoId.charAt(end))) {
                --end;
            }
            if (end <= 0) {
                end = autoId.length() - 1;
                break;
            }
            switch (i) {
                case 2: {
                    valid = autoId.charAt(end) == '-';
                    break;
                }
                default: {
                    boolean bl = valid = autoId.charAt(end) == '.';
                }
            }
            if (!valid) {
                if (i < 1) {
                    end = autoId.length() - 1;
                    break;
                }
                --end;
                break;
            }
            --end;
        }
        autoId = autoId.substring(0, end + 1);
        return autoId;
    }

    public Optional<Container> find(String id) {
        return Optional.ofNullable(Optional.ofNullable((Container)this.containers.get(id)).orElseGet(() -> id == null ? null : (Container)this.containers.get(this.buildAutoIdFromName(id))));
    }

    public Collection<Container> findAll() {
        return this.containers.values();
    }

    public List<String> getPluginsList() {
        return this.findAll().stream().map(container -> container.getId()).sorted().collect(Collectors.toList());
    }

    public String getPluginsHash() {
        String plugins = this.getPluginsList().stream().collect(Collectors.joining());
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(plugins.getBytes(StandardCharsets.UTF_8));
            char[] hexChars = "0123456789abcdef".toCharArray();
            StringBuilder out = new StringBuilder(hash.length * 2);
            for (byte b : hash) {
                out.append(hexChars[b >> 4 & 0xF]).append(hexChars[b & 0xF]);
            }
            return out.toString();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[getPluginsHash] {}", (Object)e.getMessage());
            throw new IllegalStateException(e);
        }
    }

    private Stream<String> getComponentModules() {
        try {
            return Collections.list(this.classLoaderConfiguration.getParent().getResources("META-INF/maven/org.talend.sdk.component/")).stream().map(Jars::toPath).filter(Objects::nonNull).map(it -> it.toAbsolutePath().toString());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private Stream<String> getCustomJvmMarkers() {
        try {
            return Collections.list(this.classLoaderConfiguration.getParent().getResources("TALEND-INF/org.talend.sdk.component.container.ContainerManager.jvmMarkers.txt")).stream().flatMap(it -> {
                Stream stream;
                BufferedReader reader = new BufferedReader(new InputStreamReader(it.openStream()));
                try {
                    stream = reader.lines().collect(Collectors.toList()).stream();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
                reader.close();
                return stream;
            }).map(String::trim).filter(it -> !it.isEmpty()).filter(it -> !it.startsWith("#"));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private String getJre() {
        return Optional.of(PathFactory.get(System.getProperty("java.home", ""))).map(it -> it.getFileName().toString().equals("jre") && it.getParent() != null && Files.exists(it.getParent().resolve("lib/tools.jar"), new LinkOption[0]) ? it.getParent() : it).map(it -> it.toAbsolutePath().toString()).orElseThrow(IllegalArgumentException::new);
    }

    @Override
    public void close() {
        this.lifecycle.closeIfNeeded(() -> {
            this.containers.values().forEach(Container::close);
            this.containers.clear();
        });
    }

    @Override
    public boolean isClosed() {
        return this.lifecycle.isClosed();
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public static class ClassLoaderConfiguration {
        private final ClassLoader parent;
        private final Predicate<String> classesFilter;
        private final Predicate<String> parentClassesFilter;
        private final boolean supportsResourceDependencies;
        private final String nestedPluginMappingResource;

        ClassLoaderConfiguration(ClassLoader parent, Predicate<String> classesFilter, Predicate<String> parentClassesFilter, boolean supportsResourceDependencies, String nestedPluginMappingResource) {
            this.parent = parent;
            this.classesFilter = classesFilter;
            this.parentClassesFilter = parentClassesFilter;
            this.supportsResourceDependencies = supportsResourceDependencies;
            this.nestedPluginMappingResource = nestedPluginMappingResource;
        }

        public static ClassLoaderConfigurationBuilder builder() {
            return new ClassLoaderConfigurationBuilder();
        }

        public ClassLoader getParent() {
            return this.parent;
        }

        public Predicate<String> getClassesFilter() {
            return this.classesFilter;
        }

        public Predicate<String> getParentClassesFilter() {
            return this.parentClassesFilter;
        }

        public boolean isSupportsResourceDependencies() {
            return this.supportsResourceDependencies;
        }

        public String getNestedPluginMappingResource() {
            return this.nestedPluginMappingResource;
        }

        public static class ClassLoaderConfigurationBuilder {
            private ClassLoader parent;
            private Predicate<String> classesFilter;
            private Predicate<String> parentClassesFilter;
            private boolean supportsResourceDependencies;
            private String nestedPluginMappingResource;

            ClassLoaderConfigurationBuilder() {
            }

            public ClassLoaderConfigurationBuilder parent(ClassLoader parent) {
                this.parent = parent;
                return this;
            }

            public ClassLoaderConfigurationBuilder classesFilter(Predicate<String> classesFilter) {
                this.classesFilter = classesFilter;
                return this;
            }

            public ClassLoaderConfigurationBuilder parentClassesFilter(Predicate<String> parentClassesFilter) {
                this.parentClassesFilter = parentClassesFilter;
                return this;
            }

            public ClassLoaderConfigurationBuilder supportsResourceDependencies(boolean supportsResourceDependencies) {
                this.supportsResourceDependencies = supportsResourceDependencies;
                return this;
            }

            public ClassLoaderConfigurationBuilder nestedPluginMappingResource(String nestedPluginMappingResource) {
                this.nestedPluginMappingResource = nestedPluginMappingResource;
                return this;
            }

            public ClassLoaderConfiguration create() {
                return new ClassLoaderConfiguration(this.parent, this.classesFilter, this.parentClassesFilter, this.supportsResourceDependencies, this.nestedPluginMappingResource);
            }

            public String toString() {
                return "ContainerManager.ClassLoaderConfiguration.ClassLoaderConfigurationBuilder(parent=" + this.parent + ", classesFilter=" + this.classesFilter + ", parentClassesFilter=" + this.parentClassesFilter + ", supportsResourceDependencies=" + this.supportsResourceDependencies + ", nestedPluginMappingResource=" + this.nestedPluginMappingResource + ")";
            }
        }
    }

    public static class DependenciesResolutionConfiguration {
        private final Resolver resolver;
        private final Path rootRepositoryLocation;

        DependenciesResolutionConfiguration(Resolver resolver, Path rootRepositoryLocation) {
            this.resolver = resolver;
            this.rootRepositoryLocation = rootRepositoryLocation;
        }

        public static DependenciesResolutionConfigurationBuilder builder() {
            return new DependenciesResolutionConfigurationBuilder();
        }

        public Resolver getResolver() {
            return this.resolver;
        }

        public Path getRootRepositoryLocation() {
            return this.rootRepositoryLocation;
        }

        public static class DependenciesResolutionConfigurationBuilder {
            private Resolver resolver;
            private Path rootRepositoryLocation;

            DependenciesResolutionConfigurationBuilder() {
            }

            public DependenciesResolutionConfigurationBuilder resolver(Resolver resolver) {
                this.resolver = resolver;
                return this;
            }

            public DependenciesResolutionConfigurationBuilder rootRepositoryLocation(Path rootRepositoryLocation) {
                this.rootRepositoryLocation = rootRepositoryLocation;
                return this;
            }

            public DependenciesResolutionConfiguration create() {
                return new DependenciesResolutionConfiguration(this.resolver, this.rootRepositoryLocation);
            }

            public String toString() {
                return "ContainerManager.DependenciesResolutionConfiguration.DependenciesResolutionConfigurationBuilder(resolver=" + this.resolver + ", rootRepositoryLocation=" + this.rootRepositoryLocation + ")";
            }
        }
    }

    public class ContainerBuilder {
        private final String id;
        private final String module;
        private Consumer<Container> customizer;
        private Collection<Artifact> additionalClasspath;

        public ContainerBuilder withAdditionalClasspath(Collection<Artifact> additionalClasspath) {
            this.additionalClasspath = Optional.ofNullable(additionalClasspath).orElseGet(Collections::emptySet);
            return this;
        }

        public ContainerBuilder withCustomizer(Consumer<Container> customizer) {
            this.customizer = customizer;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Container create() {
            Container container;
            block6: {
                if (ContainerManager.this.lifecycle.isClosed()) {
                    throw new IllegalStateException("ContainerManager already closed");
                }
                String moduleLocation = ContainerManager.this.classLoaderConfiguration.isSupportsResourceDependencies() ? ContainerManager.this.nestedContainerMapping.getOrDefault(this.module, this.module) : this.module;
                Path resolved = ContainerManager.this.resolve(moduleLocation);
                ContainerManager.this.info("Creating module " + moduleLocation + " (from " + this.module + (Files.exists(resolved, new LinkOption[0]) ? ", location=" + resolved.toAbsolutePath().toString() : "") + ")");
                Stream<Artifact> classpath = Stream.concat(this.getBuiltInClasspath(moduleLocation), this.additionalClasspath == null ? Stream.empty() : this.additionalClasspath.stream());
                container = new Container(this.id, moduleLocation, (Artifact[])classpath.toArray(Artifact[]::new), ContainerManager.this.classLoaderConfiguration, ContainerManager.this::resolve, Optional.ofNullable(ContainerManager.this.containerInitializer).orElse(NOOP_CUSTOMIZER).andThen(Optional.ofNullable(this.customizer).orElse(NOOP_CUSTOMIZER)), ContainerManager.this.jvmMarkers, ContainerManager.this.hasNestedRepository){

                    @Override
                    public void close() {
                        this.setState(Container.State.UNDEPLOYING);
                        try {
                            ContainerManager.this.listeners.forEach(l -> ContainerManager.safeInvoke(() -> l.onClose(this)));
                        }
                        finally {
                            try {
                                super.close();
                            }
                            finally {
                                ContainerManager.this.containers.remove(ContainerBuilder.this.id);
                                this.setState(Container.State.UNDEPLOYED);
                            }
                        }
                        ContainerManager.this.info("Closed container " + ContainerBuilder.this.id);
                    }
                };
                container.setState(Container.State.CREATED);
                container.set(ContainerBuilder.class, this);
                container.set(Actions.class, new Actions(container));
                ArrayList re = new ArrayList();
                ConfigurableClassLoader loader = container.getLoader();
                Thread thread = Thread.currentThread();
                ClassLoader oldLoader = thread.getContextClassLoader();
                thread.setContextClassLoader(loader);
                try {
                    Collection calledListeners = ContainerManager.this.listeners.stream().filter(l -> Optional.ofNullable(ContainerManager.safeInvoke(() -> l.onCreate(container))).map(re::add).orElse(false) == false).collect(Collectors.toList());
                    if (calledListeners.size() == ContainerManager.this.listeners.size()) {
                        if (ContainerManager.this.containers.putIfAbsent(this.id, container) != null) {
                            container.setState(Container.State.ON_ERROR);
                            calledListeners.forEach(l -> ContainerManager.safeInvoke(() -> l.onClose(container)));
                            throw new IllegalArgumentException("Container '" + this.id + "' already exists");
                        }
                        break block6;
                    }
                    ContainerManager.this.info("Failed creating container " + this.id);
                    calledListeners.forEach(l -> ContainerManager.safeInvoke(() -> l.onClose(container)));
                    IllegalArgumentException exception = new IllegalArgumentException(this.id + " can't be deployed");
                    re.forEach(exception::addSuppressed);
                    throw exception;
                }
                finally {
                    thread.setContextClassLoader(oldLoader);
                }
            }
            container.setState(Container.State.DEPLOYED);
            ContainerManager.this.info("Created container " + this.id);
            return container;
        }

        private Stream<Artifact> getBuiltInClasspath(String moduleLocation) {
            return ContainerManager.this.resolver.resolve(ContainerManager.this.classLoaderConfiguration.getParent(), moduleLocation);
        }

        private ContainerBuilder(String id, String module, Consumer<Container> customizer, Collection<Artifact> additionalClasspath) {
            this.id = id;
            this.module = module;
            this.customizer = customizer;
            this.additionalClasspath = additionalClasspath;
        }
    }

    public static class Actions {
        private final Container self;

        public void reload() {
            ContainerBuilder builder = this.self.get(ContainerBuilder.class);
            this.self.close();
            builder.create();
        }

        private Actions(Container self) {
            this.self = self;
        }
    }
}

