/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.opentracing.common.microprofile.client;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class SyncExecutor
extends AbstractExecutorService {
    private volatile boolean shutdown;
    private final CountDownLatch latch = new CountDownLatch(1);

    @Override
    public void shutdown() {
        this.shutdown = true;
        this.latch.countDown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.shutdown;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        try {
            return this.latch.await(timeout, unit);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public void execute(Runnable command) {
        command.run();
    }
}

