/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.opentracing.common.impl;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.tag.Tags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.geronimo.microprofile.opentracing.common.impl.ReferenceImpl;
import org.apache.geronimo.microprofile.opentracing.common.impl.SpanContextImpl;

public class SpanImpl
implements Span {
    private final Collection<ReferenceImpl> references;
    private final Map<String, Object> tags;
    private final Consumer<SpanImpl> onFinish;
    private final SpanContextImpl context;
    private final long startTimestamp;
    private String operationName;
    private long finishTimestamp;
    private final Collection<Log> logs = new ArrayList<Log>();

    public SpanImpl(String operationName, long startTimestamp, Collection<ReferenceImpl> references, Map<String, Object> tags, Consumer<SpanImpl> onFinish, SpanContextImpl context) {
        this.operationName = operationName;
        this.startTimestamp = startTimestamp;
        this.references = references;
        this.tags = tags;
        this.context = context;
        this.onFinish = onFinish;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Span log(long timestampMicroseconds, Map<String, ?> fields) {
        Log log = new Log(timestampMicroseconds, fields);
        Collection<Log> collection = this.logs;
        synchronized (collection) {
            this.logs.add(log);
        }
        return this;
    }

    public SpanContext context() {
        return this.context;
    }

    public Span log(long timestampMicroseconds, String event) {
        return this.log(Collections.singletonMap("event", event));
    }

    public void finish() {
        this.finish(TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis()));
    }

    public void finish(long finishMicros) {
        if (this.finishTimestamp != 0L) {
            return;
        }
        this.finishTimestamp = finishMicros;
        this.onFinish.accept(this);
    }

    public Span setTag(String key, String value) {
        this.tags.put(key, value);
        return this;
    }

    public Span setTag(String key, boolean value) {
        this.tags.put(key, value);
        return this;
    }

    public Span setTag(String key, Number value) {
        this.tags.put(key, value);
        return this;
    }

    public Span log(Map<String, ?> fields) {
        return this.log(this.startTimestamp, fields);
    }

    public Span log(String event) {
        return this.log(this.startTimestamp, event);
    }

    public Span setBaggageItem(String key, String value) {
        this.context.getBaggageItems().put(key, value);
        return this;
    }

    public String getBaggageItem(String key) {
        return this.context.getBaggageItems().get(key);
    }

    public Span setOperationName(String operationName) {
        this.operationName = operationName;
        return this;
    }

    public String toString() {
        return "SpanImpl{ id=" + this.context.getSpanId() + ", operationName='" + this.operationName + '\'' + ", references=" + this.references + ", tags=" + this.tags + ", startTimestamp=" + this.startTimestamp + ", finishTimestamp=" + this.finishTimestamp + ", logs=" + this.logs + '}';
    }

    public Object getId() {
        return this.context.getSpanId();
    }

    public Object getTraceId() {
        return this.context.getTraceId();
    }

    public Object getParentId() {
        return this.context.getParentSpanId();
    }

    public String getName() {
        return this.operationName;
    }

    public long getTimestamp() {
        return this.startTimestamp;
    }

    public long getDuration() {
        return this.finishTimestamp - this.startTimestamp;
    }

    public String getKind() {
        return this.tags.entrySet().stream().filter(it -> Tags.SPAN_KIND.getKey().equals(it.getKey())).findFirst().map(Map.Entry::getValue).map(String::valueOf).orElse(null);
    }

    public Map<String, Object> getTags() {
        return this.tags;
    }

    public Collection<Log> getLogs() {
        return this.logs;
    }

    public Collection<ReferenceImpl> getReferences() {
        return this.references;
    }

    public static class Log {
        private final long timestampMicros;
        private final Map<String, ?> fields;

        public Log(long timestampMicros, Map<String, ?> fields) {
            this.timestampMicros = timestampMicros;
            this.fields = fields;
        }

        public long getTimestampMicros() {
            return this.timestampMicros;
        }

        public Map<String, ?> getFields() {
            return this.fields;
        }
    }
}

