/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.container.Container;
import org.talend.sdk.component.design.extension.repository.Config;
import org.talend.sdk.component.runtime.base.Lifecycle;
import org.talend.sdk.component.runtime.internationalization.FamilyBundle;
import org.talend.sdk.component.runtime.manager.ComponentFamilyMeta;
import org.talend.sdk.component.runtime.manager.ContainerComponentRegistry;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.server.front.model.ActionReference;
import org.talend.sdk.component.server.service.PropertiesService;

@ApplicationScoped
public class ActionsService {
    private static final Logger log = LoggerFactory.getLogger(ActionsService.class);
    @Inject
    private PropertiesService propertiesService;

    public Collection<ActionReference> findActions(String family, Container container, Locale locale, ComponentFamilyMeta.BaseMeta<Lifecycle> meta, FamilyBundle familyBundle) {
        Set<ActionReference> actions = this.getActionReference(meta, familyBundle);
        return this.findActions(family, actions, container, locale, familyBundle);
    }

    public Collection<ActionReference> findActions(String family, Container container, Locale locale, Config config, FamilyBundle familyBundle) {
        Set<ActionReference> actions = this.getActionReference(this.toStream(Collections.singleton(config.getMeta())), family, familyBundle);
        return this.findActions(family, actions, container, locale, familyBundle);
    }

    public Set<ActionReference> getActionReference(ComponentFamilyMeta.BaseMeta<Lifecycle> meta, FamilyBundle familyBundle) {
        return this.getActionReference(this.toStream((Collection)meta.getParameterMetas().get()), meta.getParent().getName(), familyBundle);
    }

    public Set<ActionReference> getActionReference(Stream<ParameterMeta> parameters, String familyName, FamilyBundle familyBundle) {
        return parameters.flatMap(p -> p.getMetadata().entrySet().stream()).filter(e -> ((String)e.getKey()).startsWith("tcomp::action::")).map(e -> {
            String type = ((String)e.getKey()).substring("tcomp::action::".length());
            return new ActionReference(familyName, (String)e.getValue(), type, familyBundle.actionDisplayName(type, (String)e.getValue()).orElse((String)e.getValue()), null);
        }).collect(Collectors.toSet());
    }

    private Collection<ActionReference> findActions(String family, Set<ActionReference> actions, Container container, Locale locale, FamilyBundle familyBundle) {
        ContainerComponentRegistry registry = (ContainerComponentRegistry)container.get(ContainerComponentRegistry.class);
        return registry.getServices().stream().flatMap(s -> s.getActions().stream()).filter(s -> s.getFamily().equals(family)).filter(s -> actions.stream().anyMatch(e -> s.getFamily().equals(e.getFamily()) && s.getType().equals(e.getType()) && s.getAction().equals(e.getName()))).map(s -> new ActionReference(s.getFamily(), s.getAction(), s.getType(), familyBundle.actionDisplayName(s.getType(), s.getAction()).orElse(s.getAction()), (Collection)this.propertiesService.buildProperties((List)s.getParameters().get(), (ClassLoader)container.getLoader(), locale, null).collect(Collectors.toList()))).collect(Collectors.toList());
    }

    private Stream<ParameterMeta> toStream(Collection<ParameterMeta> parameterMetas) {
        return Stream.concat(parameterMetas.stream(), parameterMetas.stream().map(ParameterMeta::getNestedParameters).filter(Objects::nonNull).flatMap(this::toStream));
    }
}

