/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.front;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.cache.annotation.CacheDefaults;
import javax.cache.annotation.CacheResult;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.component.MigrationHandler;
import org.talend.sdk.component.classloader.ConfigurableClassLoader;
import org.talend.sdk.component.container.Container;
import org.talend.sdk.component.dependencies.maven.Artifact;
import org.talend.sdk.component.design.extension.DesignModel;
import org.talend.sdk.component.runtime.base.Lifecycle;
import org.talend.sdk.component.runtime.manager.ComponentFamilyMeta;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.runtime.manager.ContainerComponentRegistry;
import org.talend.sdk.component.runtime.manager.extension.ComponentContexts;
import org.talend.sdk.component.server.api.ComponentResource;
import org.talend.sdk.component.server.configuration.ComponentServerConfiguration;
import org.talend.sdk.component.server.dao.ComponentDao;
import org.talend.sdk.component.server.dao.ComponentFamilyDao;
import org.talend.sdk.component.server.front.base.internal.RequestKey;
import org.talend.sdk.component.server.front.model.ComponentDetail;
import org.talend.sdk.component.server.front.model.ComponentDetailList;
import org.talend.sdk.component.server.front.model.ComponentId;
import org.talend.sdk.component.server.front.model.ComponentIndex;
import org.talend.sdk.component.server.front.model.ComponentIndices;
import org.talend.sdk.component.server.front.model.Dependencies;
import org.talend.sdk.component.server.front.model.DependencyDefinition;
import org.talend.sdk.component.server.front.model.ErrorDictionary;
import org.talend.sdk.component.server.front.model.Icon;
import org.talend.sdk.component.server.front.model.Link;
import org.talend.sdk.component.server.front.model.SimplePropertyDefinition;
import org.talend.sdk.component.server.front.model.error.ErrorPayload;
import org.talend.sdk.component.server.lang.MapCache;
import org.talend.sdk.component.server.service.ActionsService;
import org.talend.sdk.component.server.service.ComponentManagerService;
import org.talend.sdk.component.server.service.ExtensionComponentMetadataManager;
import org.talend.sdk.component.server.service.IconResolver;
import org.talend.sdk.component.server.service.LocaleMapper;
import org.talend.sdk.component.server.service.PropertiesService;
import org.talend.sdk.component.server.service.SimpleQueryLanguageCompiler;
import org.talend.sdk.component.server.service.VirtualDependenciesService;
import org.talend.sdk.component.server.service.event.DeployedComponent;
import org.talend.sdk.component.server.service.jcache.FrontCacheKeyGenerator;
import org.talend.sdk.component.server.service.jcache.FrontCacheResolver;
import org.talend.sdk.component.spi.component.ComponentExtension;
import org.talend.sdk.components.vault.client.VaultClient;

@ApplicationScoped
@CacheDefaults(cacheResolverFactory=FrontCacheResolver.class, cacheKeyGenerator=FrontCacheKeyGenerator.class)
public class ComponentResourceImpl
implements ComponentResource {
    private static final Logger log = LoggerFactory.getLogger(ComponentResourceImpl.class);
    public static final String BASE64_PREFIX = "base64://";
    private final ConcurrentMap<RequestKey, ComponentIndices> indicesPerRequest = new ConcurrentHashMap<RequestKey, ComponentIndices>();
    @Inject
    private ComponentManager manager;
    @Inject
    private ComponentManagerService componentManagerService;
    @Inject
    private ComponentDao componentDao;
    @Inject
    private ComponentFamilyDao componentFamilyDao;
    @Inject
    private LocaleMapper localeMapper;
    @Inject
    private ActionsService actionsService;
    @Inject
    private PropertiesService propertiesService;
    @Inject
    private IconResolver iconResolver;
    @Inject
    private ComponentServerConfiguration configuration;
    @Inject
    private VirtualDependenciesService virtualDependenciesService;
    @Inject
    private ExtensionComponentMetadataManager virtualComponents;
    @Inject
    private MapCache caches;
    @Inject
    private SimpleQueryLanguageCompiler queryLanguageCompiler;
    @Inject
    @Context
    private HttpHeaders headers;
    @Inject
    private VaultClient vault;
    private final Map<String, Function<ComponentIndex, Object>> componentEvaluators = new HashMap<String, Function<ComponentIndex, Object>>();

    @PostConstruct
    private void setupRuntime() {
        log.info("Initializing " + this.getClass());
        this.getIndex("en", false, null);
        this.componentEvaluators.put("plugin", c -> c.getId().getPlugin());
        this.componentEvaluators.put("id", c -> c.getId().getId());
        this.componentEvaluators.put("familyId", c -> c.getId().getFamilyId());
        this.componentEvaluators.put("name", c -> c.getId().getName());
        this.componentEvaluators.put("metadata", component -> {
            Iterator iterator = ((ComponentDetail)this.getDetail("en", new String[]{component.getId().getId()}).getDetails().iterator().next()).getProperties().iterator();
            if (iterator.hasNext()) {
                return ((SimplePropertyDefinition)iterator.next()).getMetadata();
            }
            return Collections.emptyMap();
        });
    }

    public void clearCache(@Observes DeployedComponent deployedComponent) {
        this.indicesPerRequest.clear();
    }

    @CacheResult
    public Dependencies getDependencies(String[] ids) {
        if (ids.length == 0) {
            return new Dependencies(Collections.emptyMap());
        }
        HashMap<String, DependencyDefinition> dependencies = new HashMap<String, DependencyDefinition>();
        for (String id : ids) {
            if (this.virtualComponents.isExtensionEntity(id)) {
                DependencyDefinition deps = Optional.ofNullable(this.virtualComponents.getDependenciesFor(id)).orElseGet(() -> new DependencyDefinition(Collections.emptyList()));
                dependencies.put(id, deps);
                continue;
            }
            ComponentFamilyMeta.BaseMeta meta = this.componentDao.findById(id);
            dependencies.put(meta.getId(), this.getDependenciesFor(meta));
        }
        return new Dependencies(dependencies);
    }

    @CacheResult
    public StreamingOutput getDependency(String id) {
        Supplier<InputStream> streamProvider;
        ComponentFamilyMeta.BaseMeta component = this.componentDao.findById(id);
        if (component != null) {
            Path file = (Path)((Container)this.componentManagerService.manager().findPlugin(component.getParent().getPlugin()).orElseThrow(() -> new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorPayload(ErrorDictionary.PLUGIN_MISSING, "No plugin matching the id: " + id)).build()))).getContainerFile().orElseThrow(() -> new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorPayload(ErrorDictionary.PLUGIN_MISSING, "No dependency matching the id: " + id)).build()));
            if (!Files.exists(file, new LinkOption[0])) {
                return this.onMissingJar(id);
            }
            streamProvider = () -> {
                try {
                    return Files.newInputStream(file, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            };
        } else {
            Artifact artifact = Artifact.from((String)id);
            if (this.virtualDependenciesService.isVirtual(id)) {
                streamProvider = this.virtualDependenciesService.retrieveArtifact(artifact);
                if (streamProvider == null) {
                    return this.onMissingJar(id);
                }
            } else {
                Path file = this.componentManagerService.manager().getContainer().resolve(artifact.toPath());
                if (!Files.exists(file, new LinkOption[0])) {
                    return this.onMissingJar(id);
                }
                streamProvider = () -> {
                    try {
                        return Files.newInputStream(file, new OpenOption[0]);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                };
            }
        }
        return output -> {
            byte[] buffer = new byte[40960];
            try (BufferedInputStream stream = new BufferedInputStream((InputStream)streamProvider.get(), buffer.length);){
                int count;
                while ((count = ((InputStream)stream).read(buffer)) >= 0) {
                    if (count == 0) continue;
                    output.write(buffer, 0, count);
                }
            }
        };
    }

    @CacheResult
    public ComponentIndices getIndex(String language, boolean includeIconContent, String query) {
        Locale locale = this.localeMapper.mapLocale(language);
        this.caches.evictIfNeeded(this.indicesPerRequest, this.configuration.getMaxCacheSize() - 1);
        return this.indicesPerRequest.computeIfAbsent(new RequestKey(locale, includeIconContent, query), k -> {
            Predicate filter = this.queryLanguageCompiler.compile(query, this.componentEvaluators);
            return new ComponentIndices(Stream.concat(this.findDeployedComponents(includeIconContent, locale), this.virtualComponents.getDetails().stream().map(detail -> new ComponentIndex(detail.getId(), detail.getDisplayName(), detail.getId().getFamily(), new Icon(detail.getIcon(), null, null), new Icon(this.virtualComponents.getFamilyIconFor(detail.getId().getFamilyId()), null, null), detail.getVersion(), Collections.singletonList(detail.getId().getFamily()), detail.getLinks(), detail.getMetadata()))).filter(filter).collect(Collectors.toList()));
        });
    }

    @CacheResult
    public Response familyIcon(String id) {
        if (this.virtualComponents.isExtensionEntity(id)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.ICON_MISSING, "No icon for family: " + id)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        ComponentFamilyMeta meta = this.componentFamilyDao.findById(id);
        if (meta == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.FAMILY_MISSING, "No family for identifier: " + id)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        Optional plugin = this.manager.findPlugin(meta.getPlugin());
        if (!plugin.isPresent()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.PLUGIN_MISSING, "No plugin '" + meta.getPlugin() + "' for identifier: " + id)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        IconResolver.Icon iconContent = this.iconResolver.resolve((Container)plugin.get(), meta.getIcon());
        if (iconContent == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.ICON_MISSING, "No icon for family identifier: " + id)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        return Response.ok((Object)iconContent.getBytes()).type(iconContent.getType()).build();
    }

    @CacheResult
    public Response icon(String id) {
        if (this.virtualComponents.isExtensionEntity(id)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.ICON_MISSING, "No icon for family: " + id)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        ComponentFamilyMeta.BaseMeta meta = this.componentDao.findById(id);
        if (meta == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.COMPONENT_MISSING, "No component for identifier: " + id)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        Optional plugin = this.manager.findPlugin(meta.getParent().getPlugin());
        if (!plugin.isPresent()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.PLUGIN_MISSING, "No plugin '" + meta.getParent().getPlugin() + "' for identifier: " + id)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        IconResolver.Icon iconContent = this.iconResolver.resolve((Container)plugin.get(), meta.getIcon());
        if (iconContent == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.ICON_MISSING, "No icon for identifier: " + id)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        return Response.ok((Object)iconContent.getBytes()).type(iconContent.getType()).build();
    }

    public Map<String, String> migrate(String id, int version, Map<String, String> config) {
        String tenant;
        Map<String, String> configuration = config.entrySet().stream().map(e -> {
            if (((String)e.getValue()).startsWith(BASE64_PREFIX)) {
                String value = new String(Base64.getUrlDecoder().decode(((String)e.getValue()).substring(BASE64_PREFIX.length()).getBytes(StandardCharsets.UTF_8)));
                e.setValue(value);
            }
            return e;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        try {
            tenant = this.headers.getHeaderString("x-talend-tenant-id");
        }
        catch (Exception e2) {
            log.debug("[migrate] context not applicable: {}", (Object)e2.getMessage());
            tenant = null;
        }
        Map decrypted = this.vault.decrypt(configuration, tenant);
        if (this.virtualComponents.isExtensionEntity(id)) {
            return decrypted;
        }
        return ((MigrationHandler)Optional.ofNullable(this.componentDao.findById(id)).orElseThrow(() -> new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.COMPONENT_MISSING, "Didn't find component " + id)).build())).getMigrationHandler().get()).migrate(version, decrypted);
    }

    @CacheResult
    public ComponentDetailList getDetail(String language, String[] ids) {
        if (ids == null || ids.length == 0) {
            return new ComponentDetailList(Collections.emptyList());
        }
        HashMap errors = new HashMap();
        List details = Stream.of(ids).map(id -> {
            if (this.virtualComponents.isExtensionEntity((String)id)) {
                return this.virtualComponents.findComponentById((String)id).orElseGet(() -> {
                    errors.put(id, new ErrorPayload(ErrorDictionary.COMPONENT_MISSING, "No virtual component '" + id + "'"));
                    return null;
                });
            }
            return Optional.ofNullable(this.componentDao.findById((String)id)).map(meta -> {
                Optional plugin = this.manager.findPlugin(meta.getParent().getPlugin());
                if (!plugin.isPresent()) {
                    errors.put(meta.getId(), new ErrorPayload(ErrorDictionary.PLUGIN_MISSING, "No plugin '" + meta.getParent().getPlugin() + "'"));
                    return null;
                }
                Container container = (Container)plugin.get();
                Optional<DesignModel> model = Optional.ofNullable((DesignModel)meta.get(DesignModel.class));
                if (!model.isPresent()) {
                    errors.put(meta.getId(), new ErrorPayload(ErrorDictionary.DESIGN_MODEL_MISSING, "No design model '" + meta.getId() + "'"));
                    return null;
                }
                Locale locale = this.localeMapper.mapLocale(language);
                String type = ComponentFamilyMeta.ProcessorMeta.class.isInstance(meta) ? "processor" : (ComponentFamilyMeta.PartitionMapperMeta.class.isInstance(meta) ? "input" : "standalone");
                ComponentDetail componentDetail = new ComponentDetail();
                componentDetail.setLinks(Collections.emptyList());
                componentDetail.setId(this.createMetaId(container, (ComponentFamilyMeta.BaseMeta<Lifecycle>)meta));
                componentDetail.setVersion(meta.getVersion());
                componentDetail.setIcon(meta.getIcon());
                componentDetail.setInputFlows(model.get().getInputFlows());
                componentDetail.setOutputFlows(model.get().getOutputFlows());
                componentDetail.setType(type);
                componentDetail.setDisplayName(meta.findBundle((ClassLoader)container.getLoader(), locale).displayName().orElse(meta.getName()));
                componentDetail.setProperties((Collection)this.propertiesService.buildProperties((List)meta.getParameterMetas().get(), (ClassLoader)container.getLoader(), locale, null).collect(Collectors.toList()));
                componentDetail.setActions(this.actionsService.findActions(meta.getParent().getName(), container, locale, (ComponentFamilyMeta.BaseMeta<Lifecycle>)meta, meta.getParent().findBundle((ClassLoader)container.getLoader(), locale)));
                componentDetail.setMetadata(meta.getMetadata());
                return componentDetail;
            }).orElseGet(() -> {
                errors.put(id, new ErrorPayload(ErrorDictionary.COMPONENT_MISSING, "No component '" + id + "'"));
                return null;
            });
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (!errors.isEmpty()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(errors).build());
        }
        return new ComponentDetailList(details);
    }

    private Stream<ComponentIndex> findDeployedComponents(boolean includeIconContent, Locale locale) {
        return this.manager.find(c -> ((Stream)c.execute(() -> ((ContainerComponentRegistry)c.get(ContainerComponentRegistry.class)).getComponents().values().stream())).flatMap(component -> Stream.of(component.getPartitionMappers().values().stream().map(mapper -> this.toComponentIndex((Container)c, locale, c.getId(), (ComponentFamilyMeta.BaseMeta)mapper, (ComponentManager.OriginalId)c.get(ComponentManager.OriginalId.class), includeIconContent)), component.getProcessors().values().stream().map(proc -> this.toComponentIndex((Container)c, locale, c.getId(), (ComponentFamilyMeta.BaseMeta)proc, (ComponentManager.OriginalId)c.get(ComponentManager.OriginalId.class), includeIconContent)), component.getDriverRunners().values().stream().map(runner -> this.toComponentIndex((Container)c, locale, c.getId(), (ComponentFamilyMeta.BaseMeta)runner, (ComponentManager.OriginalId)c.get(ComponentManager.OriginalId.class), includeIconContent))).flatMap(Function.identity())));
    }

    private DependencyDefinition getDependenciesFor(ComponentFamilyMeta.BaseMeta<?> meta) {
        ComponentFamilyMeta familyMeta = meta.getParent();
        Optional container = this.componentManagerService.manager().findPlugin(familyMeta.getPlugin());
        return new DependencyDefinition((Collection)container.map(c -> {
            Stream<Artifact> artifacts;
            ComponentExtension.ComponentContext context = (ComponentExtension.ComponentContext)((ComponentContexts)c.get(ComponentContexts.class)).getContexts().get(meta.getType());
            ComponentExtension extension = context.owningExtension();
            Stream<Artifact> deps = c.findDependencies();
            if (this.configuration.getAddExtensionDependencies().booleanValue() && extension != null) {
                List<Artifact> dependencies = deps.collect(Collectors.toList());
                Stream<Artifact> addDeps = this.getExtensionDependencies(extension, dependencies);
                artifacts = Stream.concat(dependencies.stream(), addDeps);
            } else {
                artifacts = deps;
            }
            return artifacts.map(Artifact::toCoordinate).collect(Collectors.toList());
        }).orElseThrow(() -> new IllegalArgumentException("Can't find container '" + meta.getId() + "'")));
    }

    private Stream<Artifact> getExtensionDependencies(ComponentExtension extension, List<Artifact> filtered) {
        return extension.getAdditionalDependencies().stream().map(Artifact::from).filter(extArtifact -> filtered.stream().map(d -> d.getGroup() + ":" + d.getArtifact()).noneMatch(ga -> ga.equals(extArtifact.getGroup() + ":" + extArtifact.getArtifact())));
    }

    private ComponentId createMetaId(Container container, ComponentFamilyMeta.BaseMeta<Lifecycle> meta) {
        return new ComponentId(meta.getId(), meta.getParent().getId(), meta.getParent().getPlugin(), Optional.ofNullable((ComponentManager.OriginalId)container.get(ComponentManager.OriginalId.class)).map(ComponentManager.OriginalId::getValue).orElse(container.getId()), meta.getParent().getName(), meta.getName());
    }

    private ComponentIndex toComponentIndex(Container container, Locale locale, String plugin, ComponentFamilyMeta.BaseMeta meta, ComponentManager.OriginalId originalId, boolean includeIcon) {
        ConfigurableClassLoader loader = container.getLoader();
        String icon = meta.getIcon();
        String familyIcon = meta.getParent().getIcon();
        IconResolver.Icon iconContent = this.iconResolver.resolve(container, icon);
        IconResolver.Icon iconFamilyContent = this.iconResolver.resolve(container, familyIcon);
        String familyDisplayName = meta.getParent().findBundle((ClassLoader)loader, locale).displayName().orElse(meta.getParent().getName());
        List categories = Optional.ofNullable(meta.getParent().getCategories()).map(arg_0 -> this.lambda$toComponentIndex$33(meta, (ClassLoader)loader, locale, familyDisplayName, arg_0)).orElseGet(Collections::emptyList);
        return new ComponentIndex(new ComponentId(meta.getId(), meta.getParent().getId(), plugin, Optional.ofNullable(originalId).map(ComponentManager.OriginalId::getValue).orElse(plugin), meta.getParent().getName(), meta.getName()), meta.findBundle((ClassLoader)loader, locale).displayName().orElse(meta.getName()), familyDisplayName, new Icon(icon, iconContent == null ? null : iconContent.getType(), !includeIcon ? null : (iconContent == null ? null : iconContent.getBytes())), new Icon(familyIcon, iconFamilyContent == null ? null : iconFamilyContent.getType(), !includeIcon ? null : (iconFamilyContent == null ? null : iconFamilyContent.getBytes())), meta.getVersion(), (Collection)categories, Collections.singletonList(new Link("Detail", "/component/details?identifiers=" + meta.getId(), "application/json")), meta.getMetadata());
    }

    private String normalizeCategory(String category) {
        if (!category.contains("${family}")) {
            return category + "/${family}";
        }
        return category;
    }

    private StreamingOutput onMissingJar(String id) {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorPayload(ErrorDictionary.PLUGIN_MISSING, "No file found for: " + id)).build());
    }

    private /* synthetic */ List lambda$toComponentIndex$33(ComponentFamilyMeta.BaseMeta meta, ClassLoader loader, Locale locale, String familyDisplayName, Collection vals) {
        return vals.stream().map(this::normalizeCategory).map(category -> category.replace("${family}", meta.getParent().getName())).map(category -> meta.getParent().findBundle(loader, locale).category(category).orElseGet(() -> category.replace("/" + meta.getParent().getName() + "/", "/" + familyDisplayName + "/"))).collect(Collectors.toList());
    }
}

