/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class DelegateHandler
implements InvocationHandler {
    protected final Object delegate;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class == method.getDeclaringClass()) {
            return this.doHandleObjectMethods(method, args);
        }
        try {
            return this.doInvoke(method, args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    protected Object doInvoke(Method method, Object[] args) throws Throwable {
        return method.invoke(this.delegate, args);
    }

    protected Object doHandleObjectMethods(Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
        switch (method.getName()) {
            case "equals": {
                return args[0] != null && Proxy.isProxyClass(args[0].getClass()) && this == Proxy.getInvocationHandler(args[0]);
            }
        }
        return method.invoke((Object)this, args);
    }

    public DelegateHandler(Object delegate) {
        this.delegate = delegate;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DelegateHandler)) {
            return false;
        }
        DelegateHandler other = (DelegateHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$delegate = this.getDelegate();
        Object other$delegate = other.getDelegate();
        return !(this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DelegateHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $delegate = this.getDelegate();
        result = result * 59 + ($delegate == null ? 43 : $delegate.hashCode());
        return result;
    }

    public String toString() {
        return "DelegateHandler(delegate=" + this.getDelegate() + ")";
    }
}

