/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.classloader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.jar.Jars;

public class ConfigurableClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(ConfigurableClassLoader.class);
    private static final Certificate[] NO_CERTIFICATES = new Certificate[0];
    public static final String NESTED_MAVEN_REPOSITORY = "MAVEN-INF/repository/";
    private static final ClassLoader SYSTEM_CLASS_LOADER;
    private final String id;
    private final URL[] creationUrls;
    private final Predicate<String> parentFilter;
    private final Predicate<String> childFirstFilter;
    private final Map<String, Collection<Resource>> resources = new HashMap<String, Collection<Resource>>();
    private final Collection<ClassFileTransformer> transformers = new ArrayList<ClassFileTransformer>();
    private final WeakHashMap<Closeable, Void> closeables = new WeakHashMap();
    private final String[] fullPathJvmPrefixes;
    private final String[] nameJvmPrefixes;
    private final ConcurrentMap<String, Class<?>> proxies = new ConcurrentHashMap();
    private volatile URLClassLoader temporaryCopy;
    private final URLClassLoader classLoaderFromClasspath;

    public ConfigurableClassLoader(String id, URL[] urls, ClassLoader parent, Predicate<String> parentFilter, Predicate<String> childFirstFilter, String[] nestedDependencies, String[] jvmPrefixes) {
        this(id, urls, parent, parentFilter, childFirstFilter, Collections.emptyMap(), jvmPrefixes);
        if (nestedDependencies != null) {
            this.loadNestedDependencies(parent, nestedDependencies);
        }
    }

    private ConfigurableClassLoader(String id, URL[] urls, ClassLoader parent, Predicate<String> parentFilter, Predicate<String> childFirstFilter, Map<String, Collection<Resource>> resources, String[] jvmPrefixes) {
        super(urls, parent);
        this.id = id;
        this.creationUrls = urls;
        this.parentFilter = parentFilter;
        this.childFirstFilter = childFirstFilter;
        this.resources.putAll(resources);
        this.fullPathJvmPrefixes = (String[])Stream.of(jvmPrefixes).filter(it -> it.contains(File.separator)).toArray(String[]::new);
        this.nameJvmPrefixes = (String[])Stream.of(jvmPrefixes).filter(it -> Stream.of(this.fullPathJvmPrefixes).noneMatch(it::equals)).toArray(String[]::new);
        this.classLoaderFromClasspath = this.createClassLoaderFromClasspath();
    }

    private void loadNestedDependencies(ClassLoader parent, String[] nestedDependencies) {
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream out = new ByteArrayOutputStream(buffer.length);
        Stream.of(nestedDependencies).map(d -> NESTED_MAVEN_REPOSITORY + d).forEach(resource -> {
            CodeSource codeSource;
            Manifest manifest;
            URLConnection urlConnection;
            URL url = Optional.ofNullable(super.findResource((String)resource)).orElseGet(() -> parent.getResource((String)resource));
            if (url == null) {
                throw new IllegalArgumentException("Didn't find " + resource + " in " + Arrays.asList(nestedDependencies));
            }
            HashMap<String, Resource> resources = new HashMap<String, Resource>();
            try {
                urlConnection = url.openConnection();
                if (JarURLConnection.class.isInstance(urlConnection)) {
                    JarURLConnection juc = (JarURLConnection)JarURLConnection.class.cast(urlConnection);
                    manifest = juc.getManifest();
                    Certificate[] certificates = juc.getCertificates();
                    codeSource = new CodeSource(url, certificates);
                } else {
                    manifest = null;
                    codeSource = null;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            try (JarInputStream jarInputStream = new JarInputStream(urlConnection.getInputStream());){
                ZipEntry entry;
                while ((entry = jarInputStream.getNextEntry()) != null) {
                    int read;
                    if (entry.isDirectory()) continue;
                    if (this.isBlacklisted(entry.getName())) {
                        this.logUnexpectedDependency(url, entry.getName());
                        continue;
                    }
                    out.reset();
                    while ((read = jarInputStream.read(buffer, 0, buffer.length)) >= 0) {
                        out.write(buffer, 0, read);
                    }
                    resources.put(entry.getName(), new Resource((String)resource, out.toByteArray(), manifest, codeSource));
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            resources.forEach((k, v) -> this.resources.computeIfAbsent((String)k, i -> new ArrayList()).add(v));
        });
    }

    public Class<?> registerBytecode(String name, byte[] bytes) {
        Class<?> value = super.defineClass(name, bytes, 0, bytes.length);
        this.resolveClass(value);
        this.proxies.put(name, value);
        return value;
    }

    private void logUnexpectedDependency(URL url, String entry) {
        log.error("{} shouldn't be provided outside the JVM itself, origin={}", (Object)entry, (Object)url);
    }

    private boolean isBlacklisted(String name) {
        return "META-INF/services/org.xml.sax.driver".equals(name);
    }

    private boolean isBlacklistedFromParent(String name) {
        return name != null && name.startsWith("TALEND-INF/");
    }

    public String[] getJvmMarkers() {
        return (String[])Stream.of(this.nameJvmPrefixes, this.fullPathJvmPrefixes).flatMap(Stream::of).toArray(String[]::new);
    }

    public void registerTransformer(ClassFileTransformer transformer) {
        this.transformers.add(transformer);
    }

    public synchronized URLClassLoader createTemporaryCopy() {
        final ConfigurableClassLoader self = this;
        return this.temporaryCopy == null ? (this.temporaryCopy = new ConfigurableClassLoader(this.id, this.creationUrls, this.getParent(), this.parentFilter, this.childFirstFilter, this.resources, this.fullPathJvmPrefixes){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void close() throws IOException {
                super.close();
                ConfigurableClassLoader configurableClassLoader = self;
                synchronized (configurableClassLoader) {
                    self.temporaryCopy = null;
                }
            }
        }) : this.temporaryCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        this.resources.clear();
        if (this.temporaryCopy != null) {
            try {
                this.temporaryCopy.close();
            }
            catch (RuntimeException re) {
                log.warn(re.getMessage(), (Throwable)re);
            }
        }
        WeakHashMap<Closeable, Void> weakHashMap = this.closeables;
        synchronized (weakHashMap) {
            this.closeables.keySet().forEach(c -> {
                try {
                    c.close();
                }
                catch (IOException ex) {
                    log.warn(ex.getMessage(), (Throwable)ex);
                }
            });
            this.closeables.clear();
        }
        super.close();
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name == null) {
            throw new ClassNotFoundException();
        }
        Class aClass = (Class)this.proxies.get(name);
        if (aClass != null) {
            return aClass;
        }
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> clazz;
            if (this.isDirectJvmClass(name) && (clazz = this.loadFromJvm(name, resolve)) != null) {
                return clazz;
            }
            clazz = this.findLoadedClass(name);
            if (this.postLoad(resolve, clazz)) {
                return clazz;
            }
            boolean childFirst = this.childFirstFilter.test(name);
            if (childFirst && (clazz = this.loadInternal(name, resolve)) != null) {
                return clazz;
            }
            if (this.parentFilter.test(name) && (clazz = this.loadFromParent(name, resolve)) != null) {
                return clazz;
            }
            if (!childFirst && (clazz = this.loadInternal(name, resolve)) != null) {
                return clazz;
            }
            if (this.shouldFallbackOnJvmLoading(name) && (clazz = this.loadFromJvm(name, resolve)) != null) {
                return clazz;
            }
            clazz = this.classLoaderFromClasspath.loadClass(name);
            if (clazz != null) {
                return clazz;
            }
            throw new ClassNotFoundException(name);
        }
    }

    @Override
    public URL findResource(String name) {
        return this.resources.isEmpty() ? super.findResource(name) : Optional.ofNullable(super.findResource(name)).orElseGet(() -> Optional.ofNullable(this.resources.get(name)).filter(s -> !s.isEmpty()).map(s -> (Resource)s.iterator().next()).map(r -> this.nestedResourceToURL(name, (Resource)r)).orElse(null));
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> selfResources = this.findResources(name);
        Enumeration<URL> parentResources = this.getParent().getResources(name);
        if (!parentResources.hasMoreElements()) {
            return selfResources;
        }
        if (!selfResources.hasMoreElements()) {
            return new FilteringUrlEnum(parentResources, this::isInJvm);
        }
        return new ChainedEnumerations(Arrays.asList(selfResources, new FilteringUrlEnum(parentResources, this::isInJvm)).iterator());
    }

    @Override
    public URL getResource(String name) {
        URL resource = this.findResource(name);
        if (resource != null) {
            return resource;
        }
        if (!this.isBlacklistedFromParent(name) && (resource = this.getParent().getResource(name)) != null && (this.isNestedDependencyResource(name) || this.isInJvm(resource))) {
            return resource;
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return Optional.ofNullable(this.doGetResourceAsStream(name)).orElseGet(() -> Optional.ofNullable(this.resources.get(name)).filter(s -> s.size() > 0).map(s -> ((Resource)s.iterator().next()).resource).map(ByteArrayInputStream::new).orElse(null));
    }

    private InputStream doGetResourceAsStream(String name) {
        URL resource = super.findResource(name);
        if (this.isBlacklisted(name)) {
            this.logUnexpectedDependency(resource, name);
            return null;
        }
        try {
            if (resource == null && !this.isBlacklistedFromParent(name)) {
                URL url = this.getParent().getResource(name);
                return url != null ? this.getInputStream(url) : null;
            }
            if (resource == null) {
                return null;
            }
            return this.getInputStream(resource);
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getInputStream(URL resource) throws IOException {
        URLConnection urlc = resource.openConnection();
        InputStream is = urlc.getInputStream();
        if (JarURLConnection.class.isInstance(urlc)) {
            JarURLConnection juc = (JarURLConnection)JarURLConnection.class.cast(urlc);
            JarFile jar = juc.getJarFile();
            WeakHashMap<Closeable, Void> weakHashMap = this.closeables;
            synchronized (weakHashMap) {
                if (!this.closeables.containsKey(jar)) {
                    this.closeables.put(jar, null);
                }
            }
        }
        if (urlc.getClass().getName().equals("sun.net.www.protocol.file.FileURLConnection")) {
            WeakHashMap<Closeable, Void> weakHashMap = this.closeables;
            synchronized (weakHashMap) {
                this.closeables.put(is, null);
            }
        }
        return is;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Enumeration<URL> delegates = super.findResources(name);
        if (this.resources.isEmpty()) {
            return delegates;
        }
        Collection nested = Optional.ofNullable(this.resources.get(name)).orElseGet(Collections::emptyList);
        if (nested.isEmpty()) {
            return delegates;
        }
        ArrayList<URL> aggregated = new ArrayList<URL>(Collections.list(delegates));
        aggregated.addAll(nested.stream().map(r -> this.nestedResourceToURL(name, (Resource)r)).collect(Collectors.toList()));
        return Collections.enumeration(aggregated);
    }

    private boolean isNestedDependencyResource(String name) {
        return name != null && name.startsWith(NESTED_MAVEN_REPOSITORY);
    }

    private boolean isInJvm(URL resource) {
        Path path = Jars.toPath(resource);
        if (path == null) {
            return false;
        }
        if (this.nameJvmPrefixes.length > 0) {
            String name = path.getFileName().toString();
            if (Stream.of(this.nameJvmPrefixes).anyMatch(it -> it.startsWith(name))) {
                return true;
            }
        }
        if (this.fullPathJvmPrefixes.length > 0) {
            String fullPath = path.toAbsolutePath().toString();
            return Stream.of(this.fullPathJvmPrefixes).anyMatch(fullPath::startsWith);
        }
        return false;
    }

    public List<InputStream> findContainedResources(String name) {
        try {
            return Stream.concat(Optional.ofNullable(super.findResources(name)).map(urls -> Collections.list(urls).stream().map(url -> {
                try {
                    return url.openStream();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            })).orElseGet(Stream::empty), Optional.ofNullable(this.resources.get(name)).map(s -> s.stream().map(it -> ((Resource)it).resource).map(ByteArrayInputStream::new).map(InputStream.class::cast)).orElseGet(Stream::empty)).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private URL nestedResourceToURL(String name, Resource nestedResource) {
        try {
            return new URL("nested", null, -1, nestedResource.entry + "!/" + name, new Handler(nestedResource));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private boolean isDirectJvmClass(String name) {
        String sub;
        if (name.startsWith("java.")) {
            return true;
        }
        if (name.startsWith("sun.")) {
            return true;
        }
        if (name.startsWith("jdk.")) {
            return true;
        }
        if (name.startsWith("oracle.")) {
            return true;
        }
        if (name.startsWith("javafx.")) {
            return true;
        }
        if (name.startsWith("netscape.")) {
            return true;
        }
        if (name.startsWith("org.")) {
            sub = name.substring("org.".length());
            if (sub.startsWith("w3c.dom.")) {
                return true;
            }
            if (sub.startsWith("omg.")) {
                return true;
            }
            if (sub.startsWith("xml.sax.")) {
                return true;
            }
            if (sub.startsWith("ietf.jgss.")) {
                return true;
            }
            if (sub.startsWith("jcp.xml.dsig.internal.")) {
                return true;
            }
        }
        if (name.startsWith("com.")) {
            sub = name.substring("com.".length());
            if (sub.startsWith("oracle.")) {
                return true;
            }
            if (sub.startsWith("sun.")) {
                String subSun = sub.substring("sun.".length());
                if (subSun.startsWith("accessibility.")) {
                    return true;
                }
                if (subSun.startsWith("activation.")) {
                    return true;
                }
                if (subSun.startsWith("awt.")) {
                    return true;
                }
                if (subSun.startsWith("beans.")) {
                    return true;
                }
                if (subSun.startsWith("corba.se.")) {
                    return true;
                }
                if (subSun.startsWith("demo.jvmti.")) {
                    return true;
                }
                if (subSun.startsWith("image.codec.jpeg.")) {
                    return true;
                }
                if (subSun.startsWith("imageio.")) {
                    return true;
                }
                if (subSun.startsWith("istack.internal.")) {
                    return true;
                }
                if (subSun.startsWith("java.")) {
                    return true;
                }
                if (subSun.startsWith("java_cup.")) {
                    return true;
                }
                if (subSun.startsWith("jmx.")) {
                    return true;
                }
                if (subSun.startsWith("jndi.")) {
                    return true;
                }
                if (subSun.startsWith("management.")) {
                    return true;
                }
                if (subSun.startsWith("media.sound.")) {
                    return true;
                }
                if (subSun.startsWith("naming.internal.")) {
                    return true;
                }
                if (subSun.startsWith("net.")) {
                    return true;
                }
                if (subSun.startsWith("nio.")) {
                    return true;
                }
                if (subSun.startsWith("org.")) {
                    return true;
                }
                if (subSun.startsWith("rmi.rmid.")) {
                    return true;
                }
                if (subSun.startsWith("rowset.")) {
                    return true;
                }
                if (subSun.startsWith("security.")) {
                    return true;
                }
                if (subSun.startsWith("swing.")) {
                    return true;
                }
                if (subSun.startsWith("tracing.")) {
                    return true;
                }
                return subSun.startsWith("xml.internal.");
            }
        }
        return false;
    }

    private boolean shouldFallbackOnJvmLoading(String name) {
        if (name.startsWith("javax.")) {
            String sub = name.substring("javax.".length());
            if (sub.startsWith("accessibility.")) {
                return true;
            }
            if (sub.startsWith("activation.")) {
                return true;
            }
            if (sub.startsWith("activity.")) {
                return true;
            }
            if (sub.startsWith("annotation.")) {
                return true;
            }
            if (sub.startsWith("imageio.")) {
                return true;
            }
            if (sub.startsWith("jws.")) {
                return true;
            }
            if (sub.startsWith("lang.")) {
                return true;
            }
            if (sub.startsWith("management.")) {
                return true;
            }
            if (sub.startsWith("naming.")) {
                return true;
            }
            if (sub.startsWith("net.")) {
                return true;
            }
            if (sub.startsWith("print.")) {
                return true;
            }
            if (sub.startsWith("rmi.")) {
                return true;
            }
            if (sub.startsWith("script.")) {
                return true;
            }
            if (sub.startsWith("security.")) {
                return true;
            }
            if (sub.startsWith("smartcardio.")) {
                return true;
            }
            if (sub.startsWith("sound.")) {
                return true;
            }
            if (sub.startsWith("sql.")) {
                return true;
            }
            if (sub.startsWith("swing.")) {
                return true;
            }
            if (sub.startsWith("tools.")) {
                return true;
            }
            if (sub.startsWith("transaction.")) {
                return true;
            }
            if (sub.startsWith("xml.")) {
                return true;
            }
            if (sub.startsWith("jnlp.")) {
                return true;
            }
            if (sub.startsWith("crypto.")) {
                return true;
            }
        }
        return name.startsWith("scala.");
    }

    private boolean postLoad(boolean resolve, Class<?> clazz) {
        if (clazz != null) {
            if (resolve) {
                this.resolveClass(clazz);
            }
            return true;
        }
        return false;
    }

    private Class<?> loadFromJvm(String name, boolean resolve) {
        try {
            Class<?> clazz = SYSTEM_CLASS_LOADER.loadClass(name);
            if (this.postLoad(resolve, clazz)) {
                return clazz;
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            // empty catch block
        }
        return null;
    }

    private Class<?> loadFromParent(String name, boolean resolve) {
        ClassLoader parent = this.getParent();
        if (parent == null) {
            parent = SYSTEM_CLASS_LOADER;
        }
        try {
            Class<?> clazz = Class.forName(name, false, parent);
            if (this.postLoad(resolve, clazz)) {
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private Class<?> loadInternal(String name, boolean resolve) {
        Collection<Resource> resources;
        Class<?> clazz = null;
        String resourceName = name.replace('.', '/');
        String path = resourceName.concat(".class");
        URL url = super.findResource(path);
        if (url != null) {
            try {
                byte[] bytes;
                String pckName;
                Package pck;
                URLConnection connection = url.openConnection();
                connection.setUseCaches(false);
                int i = name.lastIndexOf(46);
                if (i != -1 && (pck = super.getPackage(pckName = name.substring(0, i))) == null) {
                    if (!JarURLConnection.class.isInstance(connection)) {
                        this.doDefinePackage(null, null, pckName);
                    } else {
                        JarURLConnection urlConnection = (JarURLConnection)JarURLConnection.class.cast(connection);
                        this.doDefinePackage(urlConnection.getManifest(), urlConnection.getJarFileURL(), pckName);
                    }
                }
                try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                    byte[] buffer = new byte[1024];
                    try (InputStream stream = connection.getInputStream();){
                        int read;
                        while ((read = stream.read(buffer)) >= 0) {
                            if (read == 0) continue;
                            outputStream.write(buffer, 0, read);
                        }
                    }
                    bytes = outputStream.toByteArray();
                }
                Certificate[] certificates = JarURLConnection.class.isInstance(connection) ? ((JarURLConnection)JarURLConnection.class.cast(connection)).getCertificates() : NO_CERTIFICATES;
                bytes = this.doTransform(resourceName, bytes);
                clazz = super.defineClass(name, bytes, 0, bytes.length, new CodeSource(url, certificates));
            }
            catch (IOException e) {
                log.warn(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        if (!this.resources.isEmpty() && (resources = this.resources.get(name.replace(".", "/") + ".class")) != null && !resources.isEmpty()) {
            Resource resource = resources.iterator().next();
            int i = name.lastIndexOf(46);
            if (i != -1) {
                this.doDefinePackage(resource.manifest, null, name.substring(0, i));
            }
            byte[] bytes = this.doTransform(resourceName, resource.resource);
            clazz = this.defineClass(name, bytes, 0, bytes.length, resource.codeSource);
        }
        if (this.postLoad(resolve, clazz)) {
            return clazz;
        }
        return null;
    }

    private byte[] doTransform(String resourceName, byte[] inBytes) {
        if (this.transformers.isEmpty()) {
            return inBytes;
        }
        byte[] bytes = inBytes;
        for (ClassFileTransformer transformer : this.transformers) {
            try {
                bytes = transformer.transform(this, resourceName, null, null, bytes);
            }
            catch (IllegalClassFormatException e) {
                log.error(e.getMessage() + ", will ignore the transformers", (Throwable)e);
                break;
            }
        }
        return bytes;
    }

    private void doDefinePackage(Manifest manifest, URL url, String pckName) {
        IllegalArgumentException iae = null;
        for (int i = 0; i < 3; ++i) {
            try {
                Package pck = super.getPackage(pckName);
                if (pck == null) {
                    if (manifest == null) {
                        this.definePackage(pckName, null, null, null, null, null, null, null);
                    } else {
                        this.definePackage(pckName, manifest, url);
                    }
                }
                return;
            }
            catch (IllegalArgumentException e) {
                iae = e;
                continue;
            }
        }
        throw iae;
    }

    private URLClassLoader createClassLoaderFromClasspath() {
        return new URLClassLoader((URL[])Arrays.stream(System.getProperty("java.class.path", "").split(File.pathSeparator)).filter(cp -> !".".equals(cp)).map(File::new).filter(File::exists).map(f -> {
            try {
                return f.toURL();
            }
            catch (MalformedURLException e) {
                return null;
            }
        }).filter(Objects::nonNull).toArray(URL[]::new));
    }

    public String getId() {
        return this.id;
    }

    public Predicate<String> getParentFilter() {
        return this.parentFilter;
    }

    public Predicate<String> getChildFirstFilter() {
        return this.childFirstFilter;
    }

    static {
        ClassLoader.registerAsParallelCapable();
        SYSTEM_CLASS_LOADER = ConfigurableClassLoader.getSystemClassLoader();
    }

    private static class ChainedEnumerations
    implements Enumeration<URL> {
        private final Iterator<Enumeration<URL>> enumerations;
        private Enumeration<URL> current;

        @Override
        public boolean hasMoreElements() {
            if (this.current == null || !this.current.hasMoreElements()) {
                if (!this.enumerations.hasNext()) {
                    return false;
                }
                this.current = this.enumerations.next();
            }
            return this.current.hasMoreElements();
        }

        @Override
        public URL nextElement() {
            return this.current.nextElement();
        }

        private ChainedEnumerations(Iterator<Enumeration<URL>> enumerations) {
            this.enumerations = enumerations;
        }
    }

    private static class FilteringUrlEnum
    implements Enumeration<URL> {
        private final Enumeration<URL> delegate;
        private final Predicate<URL> filter;
        private URL next;

        @Override
        public boolean hasMoreElements() {
            while (this.delegate.hasMoreElements()) {
                this.next = this.delegate.nextElement();
                if (!this.filter.test(this.next)) continue;
                return true;
            }
            return false;
        }

        @Override
        public URL nextElement() {
            return this.next;
        }

        private FilteringUrlEnum(Enumeration<URL> delegate, Predicate<URL> filter) {
            this.delegate = delegate;
            this.filter = filter;
        }
    }

    private static class Connection
    extends URLConnection {
        private final Resource resource;

        private Connection(URL url, Resource resource) {
            super(url);
            this.resource = resource;
        }

        @Override
        public void connect() {
        }

        @Override
        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.resource.resource);
        }
    }

    private static class Handler
    extends URLStreamHandler {
        private final Resource resource;

        @Override
        protected URLConnection openConnection(URL url) {
            return new Connection(url, this.resource);
        }

        private Handler(Resource resource) {
            this.resource = resource;
        }
    }

    private static class Resource {
        private final String entry;
        private final byte[] resource;
        private final Manifest manifest;
        private final CodeSource codeSource;

        private Resource(String entry, byte[] resource, Manifest manifest, CodeSource codeSource) {
            this.entry = entry;
            this.resource = resource;
            this.manifest = manifest;
            this.codeSource = codeSource;
        }
    }
}

