/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jcache.simple;

import javax.cache.Cache;
import javax.cache.processor.MutableEntry;

public class SimpleMutableEntry<K, V>
implements MutableEntry<K, V> {
    private final Cache<K, V> cache;
    private final K key;

    public SimpleMutableEntry(Cache<K, V> cache, K key) {
        this.cache = cache;
        this.key = key;
    }

    public boolean exists() {
        return this.cache.containsKey(this.key);
    }

    public void remove() {
        this.cache.remove(this.key);
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return (V)this.cache.get(this.key);
    }

    public void setValue(V value) {
        this.cache.put(this.key, value);
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        throw new IllegalArgumentException(clazz.getName() + " not supported in unwrap");
    }
}

