/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jcache.simple;

import javax.cache.expiry.Duration;
import org.apache.geronimo.jcache.simple.Times;

public class SimpleElement<V> {
    private final V element;
    private final long end;

    public SimpleElement(V element, Duration duration) {
        this.element = element;
        this.end = duration == null || duration.isEternal() ? Long.MAX_VALUE : (System.nanoTime() + duration.getTimeUnit().toNanos(duration.getDurationAmount())) / 1000L;
    }

    public V getElement() {
        return this.element;
    }

    public boolean isExpired() {
        return this.end != -1L && (this.end == 0L || Times.now(false) > this.end);
    }
}

