/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jcache.simple;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Pattern;

public class Serializations {
    private final Collection<String> acceptedClasses;

    public Serializations(String acceptedClasses) {
        this.acceptedClasses = acceptedClasses == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(acceptedClasses.split(",")));
    }

    public <K> K copy(ClassLoader loader, K key) {
        try {
            return (K)this.deSerialize(this.serialize(key), loader);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> byte[] serialize(T obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(obj);
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T deSerialize(byte[] data, ClassLoader loader) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        BufferedInputStream bis = new BufferedInputStream(bais);
        try (ObjectInputStreamClassLoaderAware ois = new ObjectInputStreamClassLoaderAware(bis, loader, this.acceptedClasses);){
            Object object = ois.readObject();
            return (T)object;
        }
    }

    private static class ObjectInputStreamClassLoaderAware
    extends ObjectInputStream {
        private static final Pattern PRIMITIVE_ARRAY = Pattern.compile("^\\[+[BCDFIJSVZ]$");
        private final ClassLoader classLoader;
        private final Collection<String> accepted;

        public ObjectInputStreamClassLoaderAware(InputStream in, ClassLoader classLoader, Collection<String> accepted) throws IOException {
            super(in);
            this.classLoader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
            this.accepted = accepted;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
            if (this.isAccepted(desc.getName())) {
                return Class.forName(desc.getName(), false, this.classLoader);
            }
            throw new SecurityException(desc.getName() + " not whitelisted");
        }

        protected Class resolveProxyClass(String[] interfaces) throws ClassNotFoundException {
            Class[] cinterfaces = new Class[interfaces.length];
            for (int i = 0; i < cinterfaces.length; ++i) {
                if (!this.isAccepted(interfaces[i])) {
                    throw new SecurityException(interfaces[i] + " not whitelisted");
                }
                cinterfaces[i] = Class.forName(interfaces[i], false, this.classLoader);
            }
            try {
                return Proxy.getProxyClass(this.classLoader, cinterfaces);
            }
            catch (IllegalArgumentException e) {
                throw new ClassNotFoundException(null, e);
            }
        }

        private boolean isAccepted(String name) {
            if (PRIMITIVE_ARRAY.matcher(name).matches()) {
                return false;
            }
            if (name.startsWith("[L") && name.endsWith(";")) {
                return this.isAccepted(name.substring(2, name.length() - 1));
            }
            return !this.accepted.contains(name);
        }
    }
}

