/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.johnzon.core.BufferStrategy;
import org.apache.johnzon.core.JsonArrayBuilderImpl;
import org.apache.johnzon.core.JsonDoubleImpl;
import org.apache.johnzon.core.JsonLongImpl;
import org.apache.johnzon.core.JsonNumberImpl;
import org.apache.johnzon.core.JsonObjectImpl;
import org.apache.johnzon.core.JsonStringImpl;
import org.apache.johnzon.core.util.ArrayUtil;

class JsonObjectBuilderImpl
implements JsonObjectBuilder,
Serializable {
    private BufferStrategy.BufferProvider<char[]> bufferProvider;
    private Map<String, JsonValue> attributeMap = new LinkedHashMap<String, JsonValue>();

    protected JsonObjectBuilderImpl() {
    }

    public JsonObjectBuilderImpl(JsonObject initialData, BufferStrategy.BufferProvider<char[]> bufferProvider) {
        this.bufferProvider = bufferProvider;
        this.attributeMap = new LinkedHashMap<String, JsonValue>((Map<String, JsonValue>)initialData);
    }

    public JsonObjectBuilderImpl(Map<String, Object> initialValues, BufferStrategy.BufferProvider<char[]> bufferProvider) {
        this.bufferProvider = bufferProvider;
        if (!initialValues.isEmpty()) {
            for (Map.Entry<String, Object> entry : initialValues.entrySet()) {
                this.add(entry.getKey(), entry.getValue());
            }
        }
    }

    public void add(String name, Object value) {
        if (value instanceof JsonValue) {
            this.add(name, (JsonValue)value);
        } else if (value instanceof BigDecimal) {
            this.add(name, (BigDecimal)value);
        } else if (value instanceof BigInteger) {
            this.add(name, (BigInteger)value);
        } else if (value instanceof Boolean) {
            this.add(name, (Boolean)value);
        } else if (value instanceof Double) {
            this.add(name, (Double)value);
        } else if (value instanceof Integer) {
            this.add(name, (Integer)value);
        } else if (value instanceof Long) {
            this.add(name, (Long)value);
        } else if (value instanceof String) {
            this.add(name, (String)value);
        } else if (value == null) {
            this.addNull(name);
        } else if (value instanceof Map) {
            this.add(name, (JsonValue)new JsonObjectBuilderImpl((Map)Map.class.cast(value), this.bufferProvider).build());
        } else if (value instanceof Collection) {
            this.add(name, (JsonValue)new JsonArrayBuilderImpl((Collection)Collection.class.cast(value), this.bufferProvider).build());
        } else if (value.getClass().isArray()) {
            Collection<Object> collection = ArrayUtil.newCollection(value);
            this.add(name, (JsonValue)new JsonArrayBuilderImpl(collection, this.bufferProvider).build());
        } else {
            throw new JsonException("Illegal JSON type! name=" + name + " type=" + value.getClass());
        }
    }

    public JsonObjectBuilder add(String name, JsonValue value) {
        this.putValue(name, value);
        return this;
    }

    public JsonObjectBuilder add(String name, String value) {
        this.putValue(name, (JsonValue)new JsonStringImpl(value));
        return this;
    }

    public JsonObjectBuilder add(String name, BigInteger value) {
        this.putValue(name, (JsonValue)new JsonNumberImpl(new BigDecimal(value)));
        return this;
    }

    public JsonObjectBuilder add(String name, BigDecimal value) {
        this.putValue(name, (JsonValue)new JsonNumberImpl(value));
        return this;
    }

    public JsonObjectBuilder add(String name, int value) {
        this.putValue(name, (JsonValue)new JsonLongImpl(value));
        return this;
    }

    public JsonObjectBuilder add(String name, long value) {
        this.putValue(name, (JsonValue)new JsonLongImpl(value));
        return this;
    }

    public JsonObjectBuilder add(String name, double value) {
        this.putValue(name, (JsonValue)new JsonDoubleImpl(value));
        return this;
    }

    public JsonObjectBuilder add(String name, boolean value) {
        this.putValue(name, value ? JsonValue.TRUE : JsonValue.FALSE);
        return this;
    }

    public JsonObjectBuilder addNull(String name) {
        this.putValue(name, JsonValue.NULL);
        return this;
    }

    public JsonObjectBuilder add(String name, JsonObjectBuilder builder) {
        this.putValue(name, (JsonValue)builder.build());
        return this;
    }

    public JsonObjectBuilder add(String name, JsonArrayBuilder builder) {
        this.putValue(name, (JsonValue)builder.build());
        return this;
    }

    public JsonObjectBuilder addAll(JsonObjectBuilder builder) {
        this.attributeMap.putAll((Map<String, JsonValue>)builder.build());
        return this;
    }

    public JsonObjectBuilder remove(String name) {
        this.attributeMap.remove(Objects.requireNonNull(name));
        return this;
    }

    private void putValue(String name, JsonValue value) {
        if (name == null || value == null) {
            throw new NullPointerException("name or value/builder must not be null");
        }
        this.attributeMap.put(name, value);
    }

    public JsonObject build() {
        if (this.attributeMap == null || this.attributeMap.isEmpty()) {
            return JsonValue.EMPTY_JSON_OBJECT;
        }
        Map<String, JsonValue> dump = Collections.unmodifiableMap(this.attributeMap);
        return new JsonObjectImpl(dump, this.bufferProvider);
    }
}

