/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.Serializable;
import java.util.Map;
import javax.json.JsonMergePatch;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.johnzon.core.BufferStrategy;
import org.apache.johnzon.core.JsonObjectBuilderImpl;

public class JsonMergePatchImpl
implements JsonMergePatch,
Serializable {
    private JsonValue patch;
    private BufferStrategy.BufferProvider<char[]> bufferProvider;

    public JsonMergePatchImpl(JsonValue patch, BufferStrategy.BufferProvider<char[]> bufferProvider) {
        this.patch = patch;
        this.bufferProvider = bufferProvider;
    }

    public JsonValue apply(JsonValue valueToApplyPatchOn) {
        return this.applyPatch(valueToApplyPatchOn, this.patch);
    }

    private JsonValue applyPatch(JsonValue valueToApplyPatchOn, JsonValue patch) {
        if (patch == null) {
            return JsonValue.NULL;
        }
        if (patch instanceof JsonObject && valueToApplyPatchOn instanceof JsonObject) {
            JsonObject patchObject = patch.asJsonObject();
            return this.applyJsonObjectPatch(valueToApplyPatchOn.asJsonObject(), patchObject);
        }
        return patch;
    }

    private JsonValue applyJsonObjectPatch(JsonObject jsonObject, JsonObject patch) {
        JsonObjectBuilderImpl builder = new JsonObjectBuilderImpl(jsonObject, this.bufferProvider);
        for (Map.Entry patchAttrib : patch.entrySet()) {
            String attribName = (String)patchAttrib.getKey();
            if (((JsonValue)patchAttrib.getValue()).equals(JsonValue.NULL)) {
                builder.remove(attribName);
                continue;
            }
            JsonValue originalAttrib = (JsonValue)jsonObject.get((Object)attribName);
            if (originalAttrib == null) {
                builder.add(attribName, (JsonValue)patchAttrib.getValue());
                continue;
            }
            builder.add(attribName, this.applyPatch(originalAttrib, (JsonValue)patchAttrib.getValue()));
        }
        return builder.build();
    }

    public JsonValue toJsonValue() {
        return this.patch;
    }
}

