/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.record;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.json.bind.annotation.JsonbTransient;
import org.talend.sdk.component.api.record.Schema;

public class SchemaImpl
implements Schema {
    private final Schema.Type type;
    private final Schema elementSchema;
    private final List<Schema.Entry> entries;
    @JsonbTransient
    private final List<Schema.Entry> metadataEntries;
    private final Map<String, String> props;

    SchemaImpl(BuilderImpl builder) {
        this.type = builder.type;
        this.elementSchema = builder.elementSchema;
        this.entries = Collections.unmodifiableList(builder.entries);
        this.metadataEntries = Collections.unmodifiableList(builder.metadataEntries);
        this.props = builder.props;
    }

    public String getProp(String property) {
        return this.props.get(property);
    }

    public List<Schema.Entry> getMetadata() {
        return this.metadataEntries;
    }

    @JsonbTransient
    public Stream<Schema.Entry> getAllEntries() {
        return Stream.concat(this.metadataEntries.stream(), this.entries.stream());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaImpl)) {
            return false;
        }
        SchemaImpl other = (SchemaImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Schema.Type this$type = this.getType();
        Schema.Type other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Schema this$elementSchema = this.getElementSchema();
        Schema other$elementSchema = other.getElementSchema();
        if (this$elementSchema == null ? other$elementSchema != null : !this$elementSchema.equals(other$elementSchema)) {
            return false;
        }
        List<Schema.Entry> this$entries = this.getEntries();
        List<Schema.Entry> other$entries = other.getEntries();
        if (this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries)) {
            return false;
        }
        List<Schema.Entry> this$metadataEntries = this.metadataEntries;
        List<Schema.Entry> other$metadataEntries = other.metadataEntries;
        if (this$metadataEntries == null ? other$metadataEntries != null : !((Object)this$metadataEntries).equals(other$metadataEntries)) {
            return false;
        }
        Map<String, String> this$props = this.getProps();
        Map<String, String> other$props = other.getProps();
        return !(this$props == null ? other$props != null : !((Object)this$props).equals(other$props));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchemaImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Schema.Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Schema $elementSchema = this.getElementSchema();
        result = result * 59 + ($elementSchema == null ? 43 : $elementSchema.hashCode());
        List<Schema.Entry> $entries = this.getEntries();
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        List<Schema.Entry> $metadataEntries = this.metadataEntries;
        result = result * 59 + ($metadataEntries == null ? 43 : ((Object)$metadataEntries).hashCode());
        Map<String, String> $props = this.getProps();
        result = result * 59 + ($props == null ? 43 : ((Object)$props).hashCode());
        return result;
    }

    public Schema.Type getType() {
        return this.type;
    }

    public Schema getElementSchema() {
        return this.elementSchema;
    }

    public List<Schema.Entry> getEntries() {
        return this.entries;
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public static class EntryImpl
    implements Schema.Entry {
        private String name;
        private String rawName;
        private Schema.Type type;
        private boolean nullable;
        private final boolean metadata;
        private Object defaultValue;
        private Schema elementSchema;
        private String comment;
        private Map<String, String> props = new LinkedHashMap<String, String>(0);

        EntryImpl(BuilderImpl builder) {
            this.name = builder.name;
            this.rawName = builder.rawName;
            this.type = builder.type;
            this.nullable = builder.nullable;
            this.metadata = builder.metadata;
            this.defaultValue = builder.defaultValue;
            this.elementSchema = builder.elementSchema;
            this.comment = builder.comment;
            if (builder.props != null) {
                this.props.putAll(builder.props);
            }
        }

        private void initNames(String name) {
            this.name = Schema.sanitizeConnectionName((String)name);
            if (!name.equals(this.name)) {
                this.rawName = name;
            }
        }

        @JsonbTransient
        public String getOriginalFieldName() {
            return this.rawName != null ? this.rawName : this.name;
        }

        public String getProp(String property) {
            return this.props.get(property);
        }

        public String getName() {
            return this.name;
        }

        public String getRawName() {
            return this.rawName;
        }

        public Schema.Type getType() {
            return this.type;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public boolean isMetadata() {
            return this.metadata;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public Schema getElementSchema() {
            return this.elementSchema;
        }

        public String getComment() {
            return this.comment;
        }

        public Map<String, String> getProps() {
            return this.props;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setRawName(String rawName) {
            this.rawName = rawName;
        }

        public void setType(Schema.Type type) {
            this.type = type;
        }

        public void setNullable(boolean nullable) {
            this.nullable = nullable;
        }

        public void setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setElementSchema(Schema elementSchema) {
            this.elementSchema = elementSchema;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public void setProps(Map<String, String> props) {
            this.props = props;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EntryImpl)) {
                return false;
            }
            EntryImpl other = (EntryImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isNullable() != other.isNullable()) {
                return false;
            }
            if (this.isMetadata() != other.isMetadata()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$rawName = this.getRawName();
            String other$rawName = other.getRawName();
            if (this$rawName == null ? other$rawName != null : !this$rawName.equals(other$rawName)) {
                return false;
            }
            Schema.Type this$type = this.getType();
            Schema.Type other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Object this$defaultValue = this.getDefaultValue();
            Object other$defaultValue = other.getDefaultValue();
            if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
                return false;
            }
            Schema this$elementSchema = this.getElementSchema();
            Schema other$elementSchema = other.getElementSchema();
            if (this$elementSchema == null ? other$elementSchema != null : !this$elementSchema.equals(other$elementSchema)) {
                return false;
            }
            String this$comment = this.getComment();
            String other$comment = other.getComment();
            if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
                return false;
            }
            Map<String, String> this$props = this.getProps();
            Map<String, String> other$props = other.getProps();
            return !(this$props == null ? other$props != null : !((Object)this$props).equals(other$props));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EntryImpl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isNullable() ? 79 : 97);
            result = result * 59 + (this.isMetadata() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $rawName = this.getRawName();
            result = result * 59 + ($rawName == null ? 43 : $rawName.hashCode());
            Schema.Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Object $defaultValue = this.getDefaultValue();
            result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
            Schema $elementSchema = this.getElementSchema();
            result = result * 59 + ($elementSchema == null ? 43 : $elementSchema.hashCode());
            String $comment = this.getComment();
            result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
            Map<String, String> $props = this.getProps();
            result = result * 59 + ($props == null ? 43 : ((Object)$props).hashCode());
            return result;
        }

        public String toString() {
            return "SchemaImpl.EntryImpl(name=" + this.getName() + ", rawName=" + this.getRawName() + ", type=" + this.getType() + ", nullable=" + this.isNullable() + ", metadata=" + this.isMetadata() + ", defaultValue=" + this.getDefaultValue() + ", elementSchema=" + this.getElementSchema() + ", comment=" + this.getComment() + ", props=" + this.getProps() + ")";
        }

        public static class BuilderImpl
        implements Schema.Entry.Builder {
            private String name;
            private String rawName;
            private Schema.Type type;
            private boolean nullable;
            private boolean metadata = false;
            private Object defaultValue;
            private Schema elementSchema;
            private String comment;
            private final Map<String, String> props = new LinkedHashMap<String, String>(0);

            public Schema.Entry.Builder withName(String name) {
                this.name = Schema.sanitizeConnectionName((String)name);
                if (!name.equals(this.name)) {
                    this.withRawName(name);
                }
                return this;
            }

            public Schema.Entry.Builder withRawName(String rawName) {
                this.rawName = rawName;
                return this;
            }

            public Schema.Entry.Builder withType(Schema.Type type) {
                this.type = type;
                return this;
            }

            public Schema.Entry.Builder withNullable(boolean nullable) {
                this.nullable = nullable;
                return this;
            }

            public Schema.Entry.Builder withMetadata(boolean metadata) {
                this.metadata = metadata;
                return this;
            }

            public <T> Schema.Entry.Builder withDefaultValue(T value) {
                this.defaultValue = value;
                return this;
            }

            public Schema.Entry.Builder withElementSchema(Schema schema) {
                this.elementSchema = schema;
                return this;
            }

            public Schema.Entry.Builder withComment(String comment) {
                this.comment = comment;
                return this;
            }

            public Schema.Entry.Builder withProp(String key, String value) {
                this.props.put(key, value);
                return this;
            }

            public Schema.Entry.Builder withProps(Map props) {
                if (props == null) {
                    return this;
                }
                this.props.putAll(props);
                return this;
            }

            public Schema.Entry build() {
                return new EntryImpl(this);
            }
        }
    }

    public static class BuilderImpl
    implements Schema.Builder {
        private Schema.Type type;
        private Schema elementSchema;
        private final List<Schema.Entry> entries = new ArrayList<Schema.Entry>();
        private final List<Schema.Entry> metadataEntries = new ArrayList<Schema.Entry>();
        private Map<String, String> props = new LinkedHashMap<String, String>(0);

        public Schema.Builder withElementSchema(Schema schema) {
            if (this.type != Schema.Type.ARRAY && schema != null) {
                throw new IllegalArgumentException("elementSchema is only valid for ARRAY type of schema");
            }
            this.elementSchema = schema;
            return this;
        }

        public Schema.Builder withType(Schema.Type type) {
            this.type = type;
            return this;
        }

        public Schema.Builder withEntry(Schema.Entry entry) {
            if (this.type != Schema.Type.RECORD) {
                throw new IllegalArgumentException("entry is only valid for RECORD type of schema");
            }
            if (entry.isMetadata()) {
                this.metadataEntries.add(entry);
            } else {
                this.entries.add(entry);
            }
            return this;
        }

        public Schema.Builder withProp(String key, String value) {
            this.props.put(key, value);
            return this;
        }

        public Schema.Builder withProps(Map<String, String> props) {
            if (props != null) {
                this.props = props;
            }
            return this;
        }

        public Schema build() {
            return new SchemaImpl(this);
        }
    }
}

