/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.front;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.cache.annotation.CacheDefaults;
import javax.cache.annotation.CacheResult;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.exception.ComponentException;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.runtime.manager.ContainerComponentRegistry;
import org.talend.sdk.component.runtime.manager.ServiceMeta;
import org.talend.sdk.component.server.api.ActionResource;
import org.talend.sdk.component.server.dao.ComponentActionDao;
import org.talend.sdk.component.server.extension.api.action.Action;
import org.talend.sdk.component.server.front.model.ActionItem;
import org.talend.sdk.component.server.front.model.ActionList;
import org.talend.sdk.component.server.front.model.ErrorDictionary;
import org.talend.sdk.component.server.front.model.error.ErrorPayload;
import org.talend.sdk.component.server.service.ExtensionComponentMetadataManager;
import org.talend.sdk.component.server.service.LocaleMapper;
import org.talend.sdk.component.server.service.PropertiesService;
import org.talend.sdk.component.server.service.httpurlconnection.IgnoreNetAuthenticator;
import org.talend.sdk.component.server.service.jcache.FrontCacheKeyGenerator;
import org.talend.sdk.component.server.service.jcache.FrontCacheResolver;
import org.talend.sdk.components.vault.client.VaultClient;

@ApplicationScoped
@IgnoreNetAuthenticator
@CacheDefaults(cacheResolverFactory=FrontCacheResolver.class, cacheKeyGenerator=FrontCacheKeyGenerator.class)
public class ActionResourceImpl
implements ActionResource {
    private static final Logger log = LoggerFactory.getLogger(ActionResourceImpl.class);
    @Inject
    private ComponentManager manager;
    @Inject
    private ComponentActionDao actionDao;
    @Inject
    private PropertiesService propertiesService;
    @Inject
    private LocaleMapper localeMapper;
    @Inject
    private ExtensionComponentMetadataManager virtualActions;
    @Inject
    @Context
    private HttpHeaders headers;
    @Inject
    private VaultClient vault;

    public CompletionStage<Response> execute(String family, String type, String action, String lang, Map<String, String> params) {
        return this.virtualActions.getAction(family, type, action).map(it -> ((CompletionStage)it.getHandler().apply(params, lang)).exceptionally(this::onError)).orElseGet(() -> this.doExecuteLocalAction(family, type, action, lang, params));
    }

    @CacheResult
    public ActionList getIndex(final String[] types, final String[] families, String language) {
        Predicate<String> typeMatcher = new Predicate<String>(){
            private final Collection<String> accepted;
            {
                this.accepted = new HashSet<String>(Arrays.asList(types));
            }

            @Override
            public boolean test(String type) {
                return this.accepted.isEmpty() || this.accepted.contains(type);
            }
        };
        Predicate<String> componentMatcher = new Predicate<String>(){
            private final Collection<String> accepted;
            {
                this.accepted = new HashSet<String>(Arrays.asList(families));
            }

            @Override
            public boolean test(String family) {
                return this.accepted.isEmpty() || this.accepted.contains(family);
            }
        };
        Locale locale = this.localeMapper.mapLocale(language);
        return new ActionList((Collection)Stream.concat(this.findDeployedActions(typeMatcher, componentMatcher, locale), this.findVirtualActions(typeMatcher, componentMatcher, locale)).collect(Collectors.toList()));
    }

    private CompletableFuture<Response> doExecuteLocalAction(String family, String type, String action, String lang, Map<String, String> params) {
        return CompletableFuture.supplyAsync(() -> {
            if (action == null) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorPayload(ErrorDictionary.ACTION_MISSING, "Action can't be null")).build());
            }
            ServiceMeta.ActionMeta actionMeta = this.actionDao.findBy(family, type, action);
            if (actionMeta == null) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.ACTION_MISSING, "No action with id '" + action + "'")).build());
            }
            try {
                Map runtimeParams = Optional.ofNullable(params).map(HashMap::new).orElseGet(HashMap::new);
                runtimeParams.put("$lang", this.localeMapper.mapLocale(lang).getLanguage());
                Map deciphered = this.vault.decrypt(runtimeParams, this.headers.getHeaderString("x-talend-tenant-id"));
                Object result = actionMeta.getInvoker().apply(deciphered);
                return Response.ok(result).type(MediaType.APPLICATION_JSON_TYPE).build();
            }
            catch (RuntimeException re) {
                return this.onError(re);
            }
        }, Runnable::run).exceptionally(e -> {
            Throwable cause = ExecutionException.class.isInstance(e.getCause()) ? e.getCause().getCause() : e.getCause();
            if (WebApplicationException.class.isInstance(cause)) {
                WebApplicationException wae = (WebApplicationException)WebApplicationException.class.cast(cause);
                Response response = wae.getResponse();
                String message = "";
                if (ErrorPayload.class.isInstance(wae.getResponse().getEntity())) {
                    throw wae;
                }
                try {
                    message = (String)response.readEntity(String.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (message.isEmpty()) {
                    message = cause.getMessage();
                }
                throw new WebApplicationException(message, Response.status((int)response.getStatus()).entity((Object)new ErrorPayload(ErrorDictionary.UNEXPECTED, message)).build());
            }
            throw new WebApplicationException(Response.status((int)500).entity((Object)new ErrorPayload(ErrorDictionary.UNEXPECTED, cause.getMessage())).build());
        });
    }

    private Response onError(Throwable re) {
        log.warn(re.getMessage(), re);
        if (WebApplicationException.class.isInstance(re.getCause())) {
            return ((WebApplicationException)WebApplicationException.class.cast(re.getCause())).getResponse();
        }
        if (ComponentException.class.isInstance(re)) {
            ComponentException ce = (ComponentException)re;
            throw new WebApplicationException(Response.status((int)(ce.getErrorOrigin() == ComponentException.ErrorOrigin.USER ? 400 : (ce.getErrorOrigin() == ComponentException.ErrorOrigin.BACKEND ? 456 : 520)), (String)"Unexpected callback error").entity((Object)new ErrorPayload(ErrorDictionary.ACTION_ERROR, "Action execution failed with: " + Optional.ofNullable(re.getMessage()).orElseGet(() -> NullPointerException.class.isInstance(re) ? "unexpected null" : "no error message"))).build());
        }
        throw new WebApplicationException(Response.status((int)520, (String)"Unexpected callback error").entity((Object)new ErrorPayload(ErrorDictionary.ACTION_ERROR, "Action execution failed with: " + Optional.ofNullable(re.getMessage()).orElseGet(() -> NullPointerException.class.isInstance(re) ? "unexpected null" : "no error message"))).build());
    }

    private Stream<ActionItem> findVirtualActions(Predicate<String> typeMatcher, Predicate<String> componentMatcher, Locale locale) {
        return this.virtualActions.getActions().stream().filter(act -> typeMatcher.test(act.getReference().getType()) && componentMatcher.test(act.getReference().getFamily())).map(Action::getReference).map(it -> new ActionItem(it.getFamily(), it.getType(), it.getName(), it.getProperties()));
    }

    private Stream<ActionItem> findDeployedActions(Predicate<String> typeMatcher, Predicate<String> componentMatcher, Locale locale) {
        return this.manager.find(c -> ((ContainerComponentRegistry)c.get(ContainerComponentRegistry.class)).getServices().stream().map(s -> s.getActions().stream()).flatMap(Function.identity()).filter(act -> typeMatcher.test(act.getType()) && componentMatcher.test(act.getFamily())).map(s -> new ActionItem(s.getFamily(), s.getType(), s.getAction(), (Collection)this.propertiesService.buildProperties((List)s.getParameters().get(), (ClassLoader)c.getLoader(), locale, null).collect(Collectors.toList()))));
    }
}

