/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.front;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.cache.annotation.CacheDefaults;
import javax.cache.annotation.CacheResult;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.exception.ComponentException;
import org.talend.sdk.component.classloader.ConfigurableClassLoader;
import org.talend.sdk.component.container.Container;
import org.talend.sdk.component.design.extension.RepositoryModel;
import org.talend.sdk.component.design.extension.repository.Config;
import org.talend.sdk.component.runtime.internationalization.FamilyBundle;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.server.api.ConfigurationTypeResource;
import org.talend.sdk.component.server.configuration.ComponentServerConfiguration;
import org.talend.sdk.component.server.dao.ConfigurationDao;
import org.talend.sdk.component.server.front.base.internal.RequestKey;
import org.talend.sdk.component.server.front.model.ConfigTypeNode;
import org.talend.sdk.component.server.front.model.ConfigTypeNodes;
import org.talend.sdk.component.server.front.model.ErrorDictionary;
import org.talend.sdk.component.server.front.model.SimplePropertyDefinition;
import org.talend.sdk.component.server.front.model.error.ErrorPayload;
import org.talend.sdk.component.server.lang.MapCache;
import org.talend.sdk.component.server.service.ActionsService;
import org.talend.sdk.component.server.service.ExtensionComponentMetadataManager;
import org.talend.sdk.component.server.service.LocaleMapper;
import org.talend.sdk.component.server.service.PropertiesService;
import org.talend.sdk.component.server.service.SimpleQueryLanguageCompiler;
import org.talend.sdk.component.server.service.event.DeployedComponent;
import org.talend.sdk.component.server.service.jcache.FrontCacheKeyGenerator;
import org.talend.sdk.component.server.service.jcache.FrontCacheResolver;
import org.talend.sdk.components.vault.client.VaultClient;

@ApplicationScoped
@CacheDefaults(cacheResolverFactory=FrontCacheResolver.class, cacheKeyGenerator=FrontCacheKeyGenerator.class)
public class ConfigurationTypeResourceImpl
implements ConfigurationTypeResource {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationTypeResourceImpl.class);
    private final ConcurrentMap<RequestKey, ConfigTypeNodes> indicesPerRequest = new ConcurrentHashMap<RequestKey, ConfigTypeNodes>();
    @Inject
    private ComponentManager manager;
    @Inject
    private PropertiesService propertiesService;
    @Inject
    private ActionsService actionsService;
    @Inject
    private LocaleMapper localeMapper;
    @Inject
    private ConfigurationDao configurations;
    @Inject
    private ExtensionComponentMetadataManager virtualComponents;
    @Inject
    private MapCache caches;
    @Inject
    private ComponentServerConfiguration configuration;
    @Inject
    private SimpleQueryLanguageCompiler queryLanguageCompiler;
    @Inject
    @Context
    private HttpHeaders headers;
    @Inject
    private VaultClient vault;
    private final Map<String, Function<ConfigTypeNode, Object>> configNodeEvaluators = new HashMap<String, Function<ConfigTypeNode, Object>>();

    @PostConstruct
    private void init() {
        log.info("Initializing " + this.getClass());
        this.configNodeEvaluators.put("id", ConfigTypeNode::getId);
        this.configNodeEvaluators.put("type", ConfigTypeNode::getConfigurationType);
        this.configNodeEvaluators.put("name", ConfigTypeNode::getName);
        this.configNodeEvaluators.put("metadata", node -> {
            Iterator iterator = node.getProperties().stream().iterator();
            if (iterator.hasNext()) {
                return ((SimplePropertyDefinition)iterator.next()).getMetadata();
            }
            return Collections.emptyMap();
        });
    }

    public void clearCache(@Observes DeployedComponent deployedComponent) {
        this.indicesPerRequest.clear();
    }

    @CacheResult
    public ConfigTypeNodes getRepositoryModel(String language, boolean lightPayload, String query) {
        Locale locale = this.localeMapper.mapLocale(language);
        this.caches.evictIfNeeded(this.indicesPerRequest, this.configuration.getMaxCacheSize() - 1);
        return this.indicesPerRequest.computeIfAbsent(new RequestKey(locale, !lightPayload, query), key -> this.toNodes(locale, lightPayload, it -> true, this.queryLanguageCompiler.compile(query, this.configNodeEvaluators)));
    }

    @CacheResult
    public ConfigTypeNodes getDetail(String language, final String[] ids) {
        Predicate<String> filter = ids == null ? s -> false : new Predicate<String>(){
            private final Collection<String> values;
            {
                this.values = Stream.of(ids).collect(Collectors.toSet());
            }

            @Override
            public boolean test(String s) {
                return this.values.contains(s);
            }
        };
        Locale locale = this.localeMapper.mapLocale(language);
        return this.toNodes(locale, false, filter, it -> true);
    }

    public Map<String, String> migrate(String id, int version, Map<String, String> config) {
        Map decrypted = this.vault.decrypt(config, this.headers.getHeaderString("x-talend-tenant-id"));
        if (this.virtualComponents.isExtensionEntity(id)) {
            return decrypted;
        }
        HashMap<String, String> configToMigrate = new HashMap<String, String>(decrypted);
        Config configuration = Optional.ofNullable(this.configurations.findById(id)).orElseThrow(() -> new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.CONFIGURATION_MISSING, "Didn't find configuration " + id)).build()));
        String versionKey = configuration.getMeta().getPath() + ".__version";
        boolean addedVersion = configToMigrate.putIfAbsent(versionKey, Integer.toString(version)) == null;
        try {
            Map migrated = configuration.getMigrationHandler().migrate(version, configToMigrate);
            if (addedVersion) {
                migrated.remove(versionKey);
            }
            return migrated;
        }
        catch (Exception e) {
            if (ComponentException.class.isInstance(e)) {
                ComponentException ce = (ComponentException)e;
                throw new WebApplicationException(Response.status((int)(ce.getErrorOrigin() == ComponentException.ErrorOrigin.USER ? 400 : (ce.getErrorOrigin() == ComponentException.ErrorOrigin.BACKEND ? 456 : 520)), (String)"Unexpected migration error").entity((Object)new ErrorPayload(ErrorDictionary.UNEXPECTED, "Migration execution failed with: " + Optional.ofNullable(e.getMessage()).orElseGet(() -> NullPointerException.class.isInstance(e) ? "unexpected null" : "no error message"))).build());
            }
            throw new WebApplicationException(Response.status((int)520, (String)"Unexpected migration error").entity((Object)new ErrorPayload(ErrorDictionary.UNEXPECTED, "Migration execution failed with: " + Optional.ofNullable(e.getMessage()).orElseGet(() -> NullPointerException.class.isInstance(e) ? "unexpected null" : "no error message"))).build());
        }
    }

    private Stream<ConfigTypeNode> createNode(String parentId, String family, Stream<Config> configs, FamilyBundle resourcesBundle, Container container, Locale locale, Predicate<String> idFilter, boolean lightPayload) {
        ConfigurableClassLoader loader = container.getLoader();
        if (configs == null) {
            return Stream.empty();
        }
        return configs.flatMap(arg_0 -> this.lambda$createNode$9(idFilter, parentId, resourcesBundle, lightPayload, family, container, locale, (ClassLoader)loader, arg_0));
    }

    private ConfigTypeNodes toNodes(Locale locale, boolean lightPayload, Predicate<String> filter, Predicate<ConfigTypeNode> nodeFilter) {
        return new ConfigTypeNodes(Stream.concat(this.getDeployedConfigurations(filter, nodeFilter, lightPayload, locale), this.virtualComponents.getConfigurations().stream().filter(it -> filter.test(it.getId())).filter(nodeFilter).map(it -> lightPayload ? this.copyLight((ConfigTypeNode)it) : it)).collect(Collectors.toMap(ConfigTypeNode::getId, Function.identity())));
    }

    private ConfigTypeNode copyLight(ConfigTypeNode it) {
        return new ConfigTypeNode(it.getId(), it.getVersion(), it.getParentId(), it.getConfigurationType(), it.getName(), it.getDisplayName(), it.getEdges(), null, null);
    }

    private Stream<ConfigTypeNode> getDeployedConfigurations(Predicate<String> filter, Predicate<ConfigTypeNode> nodeFilter, boolean lightPayload, Locale locale) {
        return this.manager.find(Stream::of).filter(c -> c.get(RepositoryModel.class) != null).flatMap(c -> ((RepositoryModel)c.get(RepositoryModel.class)).getFamilies().stream().filter(f -> !((List)f.getConfigs().get()).isEmpty()).flatMap(family -> {
            Stream<Object> familyNode;
            FamilyBundle resourcesBundle = family.getMeta().findBundle((ClassLoader)c.getLoader(), locale);
            if (filter.test(family.getId())) {
                ConfigTypeNode node = new ConfigTypeNode();
                node.setId(family.getId());
                node.setName(family.getMeta().getName());
                node.setDisplayName(resourcesBundle.displayName().orElse(family.getMeta().getName()));
                node.setEdges(((List)family.getConfigs().get()).stream().map(Config::getId).collect(Collectors.toSet()));
                familyNode = Stream.of(node);
            } else {
                familyNode = Stream.empty();
            }
            return Stream.concat(familyNode, this.createNode(family.getId(), family.getMeta().getName(), ((List)family.getConfigs().get()).stream(), resourcesBundle, (Container)c, locale, filter, lightPayload));
        })).filter(nodeFilter);
    }

    private /* synthetic */ Stream lambda$createNode$9(Predicate idFilter, String parentId, FamilyBundle resourcesBundle, boolean lightPayload, String family, Container container, Locale locale, ClassLoader loader, Config c) {
        Stream<Object> configNode;
        if (idFilter.test(c.getId())) {
            ConfigTypeNode node = new ConfigTypeNode();
            node.setId(c.getId());
            node.setVersion(c.getVersion());
            node.setConfigurationType(c.getKey().getConfigType());
            node.setName(c.getKey().getConfigName());
            node.setParentId(parentId);
            node.setDisplayName(resourcesBundle.configurationDisplayName(c.getKey().getConfigType(), c.getKey().getConfigName()).orElse(c.getKey().getConfigName()));
            if (!lightPayload) {
                node.setActions(this.actionsService.findActions(family, container, locale, c, resourcesBundle));
                int prefixLen = c.getMeta().getPath().length();
                String forcedPrefix = c.getMeta().getName();
                node.setProperties(this.propertiesService.buildProperties(Collections.singletonList(c.getMeta()), loader, locale, null).map(p -> new SimplePropertyDefinition(forcedPrefix + p.getPath().substring(prefixLen), p.getName(), p.getDisplayName(), p.getType(), p.getDefaultValue(), p.getValidation(), p.getMetadata(), p.getPlaceholder(), p.getProposalDisplayNames())).collect(Collectors.toList()));
            }
            node.setEdges(c.getChildConfigs().stream().map(Config::getId).collect(Collectors.toSet()));
            configNode = Stream.of(node);
        } else {
            configNode = Stream.empty();
        }
        return Stream.concat(configNode, this.createNode(c.getId(), family, c.getChildConfigs().stream(), resourcesBundle, container, locale, idFilter, lightPayload));
    }
}

