/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.front.security.web;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.talend.sdk.component.server.configuration.ComponentServerConfiguration;

@ApplicationScoped
public class EndpointSecurityService {
    @Inject
    private ComponentServerConfiguration configuration;
    private Set<String> tokens;

    @PostConstruct
    private void init() {
        this.tokens = Stream.of(this.configuration.getSecuredEndpointsTokens().split(",")).map(String::trim).filter(it -> !it.isEmpty() && !"-".equals(it)).collect(Collectors.toSet());
    }

    public boolean isAllowed(ServletRequest servletRequest) {
        return this.isSecured(servletRequest) || this.isLocal(servletRequest);
    }

    private boolean isLocal(String addr) {
        return addr != null && (addr.startsWith("127.0.0.") || addr.equals("::1") || addr.equals("0:0:0:0:0:0:0:1"));
    }

    private boolean isSecured(ServletRequest servletRequest) {
        String authorization = ((HttpServletRequest)HttpServletRequest.class.cast(servletRequest)).getHeader("Authorization");
        return authorization != null && this.tokens.contains(authorization);
    }

    private boolean isLocal(ServletRequest servletRequest) {
        return HttpServletRequest.class.isInstance(servletRequest) && Optional.ofNullable(((HttpServletRequest)HttpServletRequest.class.cast(servletRequest)).getRemoteAddr()).map(this::isLocal).orElse(false) != false;
    }
}

