/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.openwebbeans;

import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.enterprise.inject.spi.Extension;
import org.apache.meecrowave.cxf.Cxfs;
import org.apache.webbeans.spi.LoaderService;

public class MeecrowaveLoaderService
implements LoaderService {
    public <T> List<T> load(Class<T> serviceType) {
        return this.load(serviceType, Thread.currentThread().getContextClassLoader());
    }

    public <T> List<T> load(Class<T> serviceType, ClassLoader classLoader) {
        if (Extension.class == serviceType) {
            return this.doLoad(serviceType, classLoader).map(e -> serviceType.cast(Cxfs.mapCdiExtensionIfNeeded((Extension)Extension.class.cast(e)))).collect(Collectors.toList());
        }
        return this.doLoad(serviceType, classLoader).collect(Collectors.toList());
    }

    private <T> Stream<T> doLoad(Class<T> serviceType, ClassLoader classLoader) {
        return StreamSupport.stream(ServiceLoader.load(serviceType, classLoader).spliterator(), false);
    }
}

