/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.jmx;

import java.util.Date;
import java.util.stream.Stream;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import org.talend.sdk.component.container.Container;
import org.talend.sdk.component.container.ContainerManager;

public class ContainerMBean
implements DynamicMBean {
    private final ContainerManager manager;
    private final Container delegate;
    private MBeanInfo info;

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute name can't be null");
        }
        switch (attribute) {
            case "closed": {
                return this.delegate.isClosed();
            }
            case "created": {
                return this.delegate.getCreated();
            }
        }
        throw new AttributeNotFoundException(attribute);
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList attributeList = new AttributeList();
        if (attributes != null) {
            Stream.of(attributes).forEach(name -> {
                try {
                    attributeList.add(new Attribute((String)name, this.getAttribute((String)name)));
                }
                catch (AttributeNotFoundException | MBeanException | ReflectionException jMException) {
                    // empty catch block
                }
            });
        }
        return attributeList;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new AttributeNotFoundException();
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return new AttributeList();
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName == null) {
            throw new IllegalArgumentException("Action can't be null");
        }
        switch (actionName) {
            case "reload": {
                this.delegate.get(ContainerManager.Actions.class).reload();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown action: '" + actionName + "'");
            }
        }
        return null;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.info == null ? (this.info = new MBeanInfo(ContainerMBean.class.getName(), "MBean for container " + this.delegate.getId(), new MBeanAttributeInfo[]{new MBeanAttributeInfo("closed", Boolean.TYPE.getName(), "Is the container already closed", true, false, false), new MBeanAttributeInfo("created", Date.class.getName(), "When was the container created", true, false, false)}, new MBeanConstructorInfo[0], new MBeanOperationInfo[]{new MBeanOperationInfo("reload", "Reloads the container (ie stops it, recreates the classloader from the same files and starts it. Allows to kind of hot reload a plugin.", new MBeanParameterInfo[0], Void.TYPE.getName(), 1)}, new MBeanNotificationInfo[0])) : this.info;
    }

    public ContainerMBean(ContainerManager manager, Container delegate) {
        this.manager = manager;
        this.delegate = delegate;
    }
}

