/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config.configsource;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.Vetoed;
import org.apache.geronimo.config.configsource.PropertyFileConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

@Typed
@Vetoed
public class PropertyFileConfigSourceProvider
implements ConfigSourceProvider {
    private static final Logger LOG = Logger.getLogger(PropertyFileConfigSourceProvider.class.getName());
    private List<ConfigSource> configSources = new ArrayList<ConfigSource>();

    public PropertyFileConfigSourceProvider(String propertyFileName, boolean optional, ClassLoader forClassLoader) {
        try {
            Collection<URL> propertyFileUrls = this.resolvePropertyFiles(forClassLoader, propertyFileName);
            if (!optional && propertyFileUrls.isEmpty()) {
                throw new IllegalStateException(propertyFileName + " wasn't found.");
            }
            for (URL propertyFileUrl : propertyFileUrls) {
                LOG.log(Level.INFO, "Custom config found by GeronimoConfig. Name: ''{0}'', URL: ''{1}''", new Object[]{propertyFileName, propertyFileUrl});
                this.configSources.add(new PropertyFileConfigSource(propertyFileUrl));
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("problem while loading GeronimoConfig property files", ioe);
        }
    }

    public Collection<URL> resolvePropertyFiles(ClassLoader forClassLoader, String propertyFileName) throws IOException {
        Map<String, URL> propertyFileUrls = this.resolveUrls(propertyFileName, forClassLoader);
        propertyFileUrls.putAll(this.resolveUrls("/" + propertyFileName, forClassLoader));
        return propertyFileUrls.values();
    }

    private Map<String, URL> resolveUrls(String propertyFileName, ClassLoader forClassLoader) throws IOException {
        HashMap<String, URL> propertyFileUrls = new HashMap<String, URL>();
        Enumeration<URL> urls = forClassLoader.getResources(propertyFileName);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            propertyFileUrls.put(url.toExternalForm(), url);
        }
        return propertyFileUrls;
    }

    public List<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
        return this.configSources;
    }
}

