/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.front;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.bind.Jsonb;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.Bus;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.servlet.ServletController;
import org.apache.cxf.transport.servlet.servicelist.ServiceListGeneratorServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.server.api.BulkReadResource;
import org.talend.sdk.component.server.front.cxf.CxfExtractor;
import org.talend.sdk.component.server.front.memory.InMemoryRequest;
import org.talend.sdk.component.server.front.memory.InMemoryResponse;
import org.talend.sdk.component.server.front.memory.MemoryInputStream;
import org.talend.sdk.component.server.front.memory.SimpleServletConfig;
import org.talend.sdk.component.server.front.model.BulkRequests;
import org.talend.sdk.component.server.front.model.BulkResponses;
import org.talend.sdk.component.server.front.model.ErrorDictionary;
import org.talend.sdk.component.server.front.model.error.ErrorPayload;
import org.talend.sdk.component.server.front.security.web.EndpointSecurityService;
import org.talend.sdk.component.server.service.qualifier.ComponentServer;

@ApplicationScoped
public class BulkReadResourceImpl
implements BulkReadResource {
    private static final Logger log = LoggerFactory.getLogger(BulkReadResourceImpl.class);
    private static final CompletableFuture[] EMPTY_PROMISES = new CompletableFuture[0];
    @Inject
    private CxfExtractor cxf;
    @Inject
    private Bus bus;
    @Inject
    @Context
    private ServletContext servletContext;
    @Inject
    @Context
    private HttpServletRequest httpServletRequest;
    @Inject
    @Context
    private UriInfo uriInfo;
    @Inject
    @Context
    private HttpServletRequest request;
    @Inject
    @ComponentServer
    private Jsonb defaultMapper;
    @Inject
    private EndpointSecurityService endpointSecurityService;
    private ServletController controller;
    private final String appPrefix = "/api/v1";
    private final Collection<String> blacklisted = Stream.of("/api/v1/component/icon/", "/api/v1/component/dependency/").collect(Collectors.toSet());
    private final BulkResponses.Result forbiddenInBulkModeResponse = new BulkResponses.Result(Response.Status.FORBIDDEN.getStatusCode(), Collections.emptyMap(), "{\"code\":\"UNAUTHORIZED\",\"description\":\"Forbidden endpoint in bulk mode.\"}".getBytes(StandardCharsets.UTF_8));
    private final BulkResponses.Result forbiddenResponse = new BulkResponses.Result(Response.Status.FORBIDDEN.getStatusCode(), Collections.emptyMap(), "{\"code\":\"UNAUTHORIZED\",\"description\":\"Secured endpoint, ensure to pass the right token.\"}".getBytes(StandardCharsets.UTF_8));
    private final BulkResponses.Result invalidResponse = new BulkResponses.Result(Response.Status.BAD_REQUEST.getStatusCode(), Collections.emptyMap(), "{\"code\":\"UNEXPECTED\",\"description\":\"unknownEndpoint.\"}".getBytes(StandardCharsets.UTF_8));

    @PostConstruct
    private void init() {
        DestinationRegistry registry = this.cxf.getRegistry();
        this.controller = new ServletController(registry, (ServletConfig)new SimpleServletConfig(this.servletContext, "Talend Component Kit Bulk Transport"), (HttpServlet)new ServiceListGeneratorServlet(registry, this.bus));
    }

    public CompletionStage<BulkResponses> bulk(BulkRequests requests) {
        Collection responses = Optional.ofNullable(requests.getRequests()).map(Collection::stream).orElseGet(Stream::empty).map(request -> {
            if (this.isBlacklisted((BulkRequests.Request)request)) {
                return CompletableFuture.completedFuture(this.forbiddenInBulkModeResponse);
            }
            if ("/api/v1/environment".equals(request.getPath()) && !this.endpointSecurityService.isAllowed((ServletRequest)this.httpServletRequest)) {
                return CompletableFuture.completedFuture(this.forbiddenResponse);
            }
            if (request.getPath() == null || !request.getPath().startsWith("/api/v1") || request.getPath().contains("?")) {
                return CompletableFuture.completedFuture(this.invalidResponse);
            }
            return this.doExecute((BulkRequests.Request)request, this.uriInfo);
        }).collect(Collectors.toList());
        return CompletableFuture.allOf(responses.toArray(EMPTY_PROMISES)).handle((ignored, error) -> new BulkResponses(responses.stream().map(it -> {
            try {
                return (BulkResponses.Result)it.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
            catch (ExecutionException e) {
                throw new WebApplicationException(Response.serverError().entity((Object)new ErrorPayload(ErrorDictionary.UNEXPECTED, e.getMessage())).build());
            }
        }).collect(Collectors.toList())));
    }

    private boolean isBlacklisted(BulkRequests.Request request) {
        return this.blacklisted.stream().anyMatch(it -> request.getPath() == null || request.getPath().startsWith((String)it));
    }

    private CompletableFuture<BulkResponses.Result> doExecute(BulkRequests.Request inputRequest, UriInfo info) {
        Map headers = Optional.ofNullable(inputRequest.getHeaders()).orElseGet(Collections::emptyMap);
        String path = Optional.ofNullable(inputRequest.getPath()).map(it -> it.substring("/api/v1".length())).orElse("/");
        String queryString = Optional.ofNullable(inputRequest.getQueryParameters()).map(Map::entrySet).map(Collection::stream).orElseGet(Stream::empty).flatMap(it -> Optional.ofNullable(it.getValue()).map(Collection::stream).orElseGet(Stream::empty).map(value -> (String)it.getKey() + '=' + value)).collect(Collectors.joining("&"));
        int port = info.getBaseUri().getPort();
        Principal userPrincipal = this.request.getUserPrincipal();
        InMemoryRequest request = new InMemoryRequest("GET", headers, path, "/api/v1" + path, "/api/v1", queryString, port < 0 ? 8080 : port, this.servletContext, new MemoryInputStream(null){

            public int read() {
                return -1;
            }
        }, () -> userPrincipal);
        BulkResponses.Result result = new BulkResponses.Result();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        CompletableFuture<BulkResponses.Result> promise = new CompletableFuture<BulkResponses.Result>();
        try {
            this.controller.invoke((HttpServletRequest)request, (HttpServletResponse)new InMemoryResponse(() -> true, () -> {
                result.setResponse(outputStream.toByteArray());
                promise.complete(result);
            }, bytes -> {
                try {
                    outputStream.write((byte[])bytes);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }, (status, responseHeaders) -> {
                result.setStatus(status.intValue());
                result.setHeaders(headers);
                return "";
            }));
        }
        catch (ServletException e) {
            result.setStatus(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            result.setResponse(this.defaultMapper.toJson((Object)new ErrorPayload(ErrorDictionary.UNEXPECTED, e.getMessage())).getBytes(StandardCharsets.UTF_8));
            promise.complete(result);
            throw new IllegalStateException(e);
        }
        return promise;
    }
}

