/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.front.monitoring;

import brave.Tracing;
import brave.http.HttpRuleSampler;
import brave.http.HttpTracing;
import brave.sampler.CountingSampler;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.talend.sdk.component.server.configuration.ComponentServerConfiguration;
import org.talend.sdk.component.server.front.monitoring.MonitoringLogger;
import zipkin2.Span;
import zipkin2.reporter.Reporter;

@ApplicationScoped
public class BraveConfiguration {
    @Inject
    @ConfigProperty(name="TRACING_SAMPLING_RATE", defaultValue="0.1f")
    private Float samplingRate;
    @Inject
    @ConfigProperty(name="TRACING_ON", defaultValue="false")
    private Boolean tracingOn;
    @Inject
    private MonitoringLogger monitoringLogger;

    @Produces
    @ApplicationScoped
    public HttpTracing httpTracing(ComponentServerConfiguration configuration) {
        return HttpTracing.newBuilder((Tracing)Tracing.newBuilder().localServiceName(configuration.getServiceName()).sampler(CountingSampler.create((float)this.toActualRate(configuration.getSamplerRate().floatValue()))).spanReporter(this.createReporter(configuration)).build()).serverSampler(HttpRuleSampler.newBuilder().addRule("GET", "/api/v1/environment", this.toActualRate(configuration.getSamplerEnvironmentRate().floatValue())).addRule("GET", "/api/v1/configurationtype", this.toActualRate(configuration.getSamplerConfigurationTypeRate().floatValue())).addRule("GET", "/api/v1/component", this.toActualRate(configuration.getSamplerComponentRate().floatValue())).addRule("POST", "/api/v1/component", this.toActualRate(configuration.getSamplerComponentRate().floatValue())).addRule("POST", "/api/v1/execution", configuration.getSamplerExecutionRate().floatValue()).addRule("GET", "/api/v1/action", this.toActualRate(configuration.getSamplerActionRate().floatValue())).addRule("POST", "/api/v1/action", this.toActualRate(configuration.getSamplerActionRate().floatValue())).addRule("GET", "/api/v1/documentation", this.toActualRate(configuration.getSamplerDocumentationRate().floatValue())).build()).clientSampler(HttpRuleSampler.newBuilder().build()).build();
    }

    private float toActualRate(float rate) {
        if (rate < 0.0f) {
            return this.samplingRate.floatValue();
        }
        return rate;
    }

    private Reporter<Span> createReporter(ComponentServerConfiguration configuration) {
        String type;
        if (!this.tracingOn.booleanValue()) {
            return Reporter.NOOP;
        }
        String reporter = configuration.getReporter();
        switch (type = reporter.contains("(") ? reporter.substring(0, reporter.indexOf(40)) : reporter) {
            case "noop": {
                return Reporter.NOOP;
            }
            case "log": {
                return this.monitoringLogger;
            }
        }
        throw new IllegalArgumentException("Unsupported reporter: '" + reporter + "', please do a PR on github@Talend/component-runtime if you want it to be supported");
    }
}

