/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.front;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.ParameterIn;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.classloader.ConfigurableClassLoader;
import org.talend.sdk.component.container.Container;
import org.talend.sdk.component.design.extension.RepositoryModel;
import org.talend.sdk.component.design.extension.repository.Config;
import org.talend.sdk.component.runtime.internationalization.FamilyBundle;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.server.dao.ConfigurationDao;
import org.talend.sdk.component.server.front.model.ConfigTypeNode;
import org.talend.sdk.component.server.front.model.ConfigTypeNodes;
import org.talend.sdk.component.server.front.model.ErrorDictionary;
import org.talend.sdk.component.server.front.model.SimplePropertyDefinition;
import org.talend.sdk.component.server.front.model.error.ErrorPayload;
import org.talend.sdk.component.server.service.ActionsService;
import org.talend.sdk.component.server.service.LocaleMapper;
import org.talend.sdk.component.server.service.PropertiesService;

@Tag(name="Configuration Type", description="Endpoints related to configuration types (reusable configuration) metadata access.")
@Path(value="configurationtype")
@ApplicationScoped
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ConfigurationTypeResource {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationTypeResource.class);
    @Inject
    private ComponentManager manager;
    @Inject
    private PropertiesService propertiesService;
    @Inject
    private ActionsService actionsService;
    @Inject
    private LocaleMapper localeMapper;
    @Inject
    private ConfigurationDao configurations;

    @GET
    @Path(value="index")
    @Operation(description="Returns all available configuration type - storable models. Note that the lightPayload flag allows to load all of them at once when you eagerly need  to create a client model for all configurations.")
    @APIResponse(responseCode="200", description="the list of available and storable configurations (datastore, dataset, ...).", content={@Content(mediaType="application/json")})
    public ConfigTypeNodes getRepositoryModel(@QueryParam(value="language") @DefaultValue(value="en") @Parameter(name="language", description="the language for display names.", in=ParameterIn.QUERY, schema=@Schema(type=SchemaType.STRING, defaultValue="en")) String language, @QueryParam(value="lightPayload") @DefaultValue(value="true") @Parameter(name="lightPayload", description="should the payload skip the forms and actions associated to the configuration.", in=ParameterIn.QUERY, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="true")) boolean lightPaylaod) {
        return this.toNodes(language, s -> true, lightPaylaod);
    }

    @GET
    @Path(value="details")
    @Operation(description="Returns all available configuration type - storable models. Note that the lightPayload flag allows to load all of them at once when you eagerly need  to create a client model for all configurations.")
    @APIResponse(responseCode="200", description="the list of available and storable configurations (datastore, dataset, ...).", content={@Content(mediaType="application/json")})
    public ConfigTypeNodes getDetail(@QueryParam(value="language") @DefaultValue(value="en") @Parameter(name="language", description="the language for display names.", in=ParameterIn.QUERY, schema=@Schema(type=SchemaType.STRING, defaultValue="en")) String language, final @QueryParam(value="identifiers") @Parameter(name="identifiers", description="the comma separated list of identifiers to request.", in=ParameterIn.QUERY) String[] ids) {
        Predicate<String> filter = ids == null ? s -> false : new Predicate<String>(){
            private final Collection<String> values;
            {
                this.values = Stream.of(ids).collect(Collectors.toSet());
            }

            @Override
            public boolean test(String s) {
                return this.values.contains(s);
            }
        };
        return this.toNodes(language, filter, false);
    }

    @POST
    @Path(value="migrate/{id}/{configurationVersion}")
    @Operation(description="Allows to migrate a configuration without calling any component execution.")
    @APIResponses(value={@APIResponse(responseCode="200", description="the new values for that configuration (or the same if no migration was needed).", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="The configuration is not found", content={@Content(mediaType="application/json")})})
    public Map<String, String> migrate(@PathParam(value="id") @Parameter(name="id", description="the configuration identifier", in=ParameterIn.PATH) String id, @PathParam(value="configurationVersion") @Parameter(name="configurationVersion", description="the configuration version you send", in=ParameterIn.PATH) int version, @RequestBody(description="the actual configuration in key/value form.", required=true, content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT))}) Map<String, String> config) {
        return Optional.ofNullable(this.configurations.findById(id)).orElseThrow(() -> new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.CONFIGURATION_MISSING, "Didn't find configuration " + id)).build())).getMigrationHandler().migrate(version, config);
    }

    private Stream<ConfigTypeNode> createNode(String parentId, String family, Stream<Config> configs, FamilyBundle resourcesBundle, Container container, Locale locale, Predicate<String> idFilter, boolean lightPayload) {
        ConfigurableClassLoader loader = container.getLoader();
        if (configs == null) {
            return Stream.empty();
        }
        return configs.flatMap(arg_0 -> this.lambda$createNode$4(idFilter, parentId, resourcesBundle, lightPayload, family, container, locale, (ClassLoader)loader, arg_0));
    }

    private ConfigTypeNodes toNodes(String language, Predicate<String> filter, boolean lightPayload) {
        Locale locale = this.localeMapper.mapLocale(language);
        return this.manager.find(Stream::of).filter(c -> c.get(RepositoryModel.class) != null).map(c -> ((RepositoryModel)c.get(RepositoryModel.class)).getFamilies().stream().filter(f -> !f.getConfigs().isEmpty()).flatMap(family -> {
            Stream<Object> familyNode;
            FamilyBundle resourcesBundle = family.getMeta().findBundle((ClassLoader)c.getLoader(), locale);
            if (filter.test(family.getId())) {
                ConfigTypeNode node = new ConfigTypeNode();
                node.setId(family.getId());
                node.setName(family.getMeta().getName());
                node.setDisplayName(resourcesBundle.displayName().orElse(family.getMeta().getName()));
                node.setEdges(family.getConfigs().stream().map(Config::getId).collect(Collectors.toSet()));
                familyNode = Stream.of(node);
            } else {
                familyNode = Stream.empty();
            }
            return Stream.concat(familyNode, this.createNode(family.getId(), family.getMeta().getName(), family.getConfigs().stream(), resourcesBundle, (Container)c, locale, filter, lightPayload));
        })).collect(() -> {
            ConfigTypeNodes nodes = new ConfigTypeNodes();
            nodes.setNodes(new HashMap());
            return nodes;
        }, (root, children) -> root.getNodes().putAll(children.collect(Collectors.toMap(ConfigTypeNode::getId, Function.identity()))), (first, second) -> first.getNodes().putAll(second.getNodes()));
    }

    private /* synthetic */ Stream lambda$createNode$4(Predicate idFilter, String parentId, FamilyBundle resourcesBundle, boolean lightPayload, String family, Container container, Locale locale, ClassLoader loader, Config c) {
        Stream<Object> configNode;
        if (idFilter.test(c.getId())) {
            ConfigTypeNode node = new ConfigTypeNode();
            node.setId(c.getId());
            node.setVersion(c.getVersion());
            node.setConfigurationType(c.getKey().getConfigType());
            node.setName(c.getKey().getConfigName());
            node.setParentId(parentId);
            node.setDisplayName(resourcesBundle.configurationDisplayName(c.getKey().getConfigType(), c.getKey().getConfigName()).orElse(c.getKey().getConfigName()));
            if (!lightPayload) {
                node.setActions(this.actionsService.findActions(family, container, locale, c));
                int prefixLen = c.getMeta().getPath().length();
                String forcedPrefix = c.getMeta().getName();
                node.setProperties(this.propertiesService.buildProperties(Collections.singletonList(c.getMeta()), loader, locale, null).map(p -> new SimplePropertyDefinition(forcedPrefix + p.getPath().substring(prefixLen), p.getName(), p.getDisplayName(), p.getType(), p.getDefaultValue(), p.getValidation(), p.getMetadata(), p.getPlaceholder(), p.getProposalDisplayNames())).collect(Collectors.toList()));
            }
            node.setEdges(c.getChildConfigs().stream().map(Config::getId).collect(Collectors.toSet()));
            configNode = Stream.of(node);
        } else {
            configNode = Stream.empty();
        }
        return Stream.concat(configNode, this.createNode(c.getId(), family, c.getChildConfigs().stream(), resourcesBundle, container, locale, idFilter, lightPayload));
    }
}

