/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.front;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.ParameterIn;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.classloader.ConfigurableClassLoader;
import org.talend.sdk.component.container.Container;
import org.talend.sdk.component.dependencies.maven.Artifact;
import org.talend.sdk.component.design.extension.DesignModel;
import org.talend.sdk.component.runtime.manager.ComponentFamilyMeta;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.runtime.manager.ContainerComponentRegistry;
import org.talend.sdk.component.runtime.manager.extension.ComponentContexts;
import org.talend.sdk.component.server.configuration.ComponentServerConfiguration;
import org.talend.sdk.component.server.dao.ComponentDao;
import org.talend.sdk.component.server.dao.ComponentFamilyDao;
import org.talend.sdk.component.server.front.base.internal.RequestKey;
import org.talend.sdk.component.server.front.model.ComponentDetail;
import org.talend.sdk.component.server.front.model.ComponentDetailList;
import org.talend.sdk.component.server.front.model.ComponentId;
import org.talend.sdk.component.server.front.model.ComponentIndex;
import org.talend.sdk.component.server.front.model.ComponentIndices;
import org.talend.sdk.component.server.front.model.Dependencies;
import org.talend.sdk.component.server.front.model.DependencyDefinition;
import org.talend.sdk.component.server.front.model.ErrorDictionary;
import org.talend.sdk.component.server.front.model.Icon;
import org.talend.sdk.component.server.front.model.Link;
import org.talend.sdk.component.server.front.model.error.ErrorPayload;
import org.talend.sdk.component.server.service.ActionsService;
import org.talend.sdk.component.server.service.ComponentManagerService;
import org.talend.sdk.component.server.service.IconResolver;
import org.talend.sdk.component.server.service.LocaleMapper;
import org.talend.sdk.component.server.service.PropertiesService;
import org.talend.sdk.component.spi.component.ComponentExtension;

@Tag(name="Component", description="Endpoints related to component metadata access.")
@Path(value="component")
@ApplicationScoped
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ComponentResource {
    private static final Logger log = LoggerFactory.getLogger(ComponentResource.class);
    private final ConcurrentMap<RequestKey, ComponentIndices> indicesPerRequest = new ConcurrentHashMap<RequestKey, ComponentIndices>();
    @Inject
    private ComponentManager manager;
    @Inject
    private ComponentManagerService componentManagerService;
    @Inject
    private ComponentDao componentDao;
    @Inject
    private ComponentFamilyDao componentFamilyDao;
    @Inject
    private LocaleMapper localeMapper;
    @Inject
    private ActionsService actionsService;
    @Inject
    private PropertiesService propertiesService;
    @Inject
    private IconResolver iconResolver;
    @Inject
    private ComponentServerConfiguration configuration;

    @PostConstruct
    private void setupRuntime() {
        log.info("Initializing " + this.getClass());
        this.getIndex("en", false);
    }

    @GET
    @Path(value="dependencies")
    @Operation(description="Returns a list of dependencies for the given components. IMPORTANT: don't forget to add the component itself since it will not be part of the dependencies.Then you can use /dependency/{id} to download the binary.")
    @APIResponse(responseCode="200", description="The list of dependencies per component", content={@Content(mediaType="application/json")})
    public Dependencies getDependencies(@QueryParam(value="identifier") @Parameter(name="identifier", description="the list of component identifiers to find the dependencies for.", in=ParameterIn.QUERY) String[] ids) {
        if (ids.length == 0) {
            return new Dependencies(Collections.emptyMap());
        }
        return new Dependencies(Stream.of(ids).map(id -> this.componentDao.findById((String)id)).collect(Collectors.toMap(ComponentFamilyMeta.BaseMeta::getId, meta -> this.componentManagerService.manager().findPlugin(meta.getParent().getPlugin()).map(c -> {
            Stream<Artifact> artifacts;
            ComponentExtension.ComponentContext context = (ComponentExtension.ComponentContext)((ComponentContexts)c.get(ComponentContexts.class)).getContexts().get(meta.getType());
            ComponentExtension extension = context.owningExtension();
            Stream<Artifact> deps = c.findDependencies();
            if (this.configuration.getAddExtensionDependencies().booleanValue() && extension != null) {
                List dependencies = deps.collect(Collectors.toList());
                Stream<Artifact> addDeps = extension.getAdditionalDependencies().stream().map(Artifact::from).filter(extArtifact -> dependencies.stream().map(d -> d.getGroup() + ":" + d.getArtifact()).noneMatch(ga -> ga.equals(extArtifact.getGroup() + ":" + extArtifact.getArtifact())));
                artifacts = Stream.concat(dependencies.stream(), addDeps);
            } else {
                artifacts = deps;
            }
            return new DependencyDefinition((Collection)artifacts.map(Artifact::toCoordinate).collect(Collectors.toList()));
        }).orElse(new DependencyDefinition(Collections.emptyList())))));
    }

    @GET
    @Path(value="dependency/{id}")
    @Produces(value={"application/octet-stream"})
    @Operation(description="Return a binary of the dependency represented by `id`. It can be maven coordinates for dependencies or a component id.")
    @APIResponse(responseCode="200", description="The dependency binary (jar).", content={@Content(mediaType="application/octet-stream")})
    public StreamingOutput getDependency(@PathParam(value="id") @Parameter(name="id", description="the dependency binary (jar).", in=ParameterIn.PATH) String id) {
        File file;
        ComponentFamilyMeta.BaseMeta component = this.componentDao.findById(id);
        if (component != null) {
            file = (File)((Container)this.componentManagerService.manager().findPlugin(component.getParent().getPlugin()).orElseThrow(() -> new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorPayload(ErrorDictionary.PLUGIN_MISSING, "No plugin matching the id: " + id)).build()))).getContainerFile().orElseThrow(() -> new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorPayload(ErrorDictionary.PLUGIN_MISSING, "No dependency matching the id: " + id)).build()));
        } else {
            Artifact artifact = Artifact.from((String)id);
            file = this.componentManagerService.manager().getContainer().resolve(artifact.toPath());
        }
        if (!file.exists()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorPayload(ErrorDictionary.PLUGIN_MISSING, "No file found for: " + id)).build());
        }
        return output -> {
            byte[] buffer = new byte[40960];
            try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file), buffer.length);){
                int count;
                while ((count = ((InputStream)stream).read(buffer)) >= 0) {
                    if (count == 0) continue;
                    output.write(buffer, 0, count);
                }
            }
        };
    }

    @GET
    @Path(value="index")
    @Operation(description="Returns the list of available components.")
    @APIResponse(responseCode="200", description="The index of available components.", content={@Content(mediaType="application/octet-stream")})
    public ComponentIndices getIndex(@QueryParam(value="language") @DefaultValue(value="en") @Parameter(name="language", description="the language for display names.", in=ParameterIn.QUERY, schema=@Schema(type=SchemaType.STRING, defaultValue="en")) String language, @QueryParam(value="includeIconContent") @DefaultValue(value="false") @Parameter(name="includeIconContent", description="should the icon binary format be included in the payload.", in=ParameterIn.QUERY, schema=@Schema(type=SchemaType.STRING, defaultValue="en")) boolean includeIconContent) {
        Locale locale = this.localeMapper.mapLocale(language);
        return this.indicesPerRequest.computeIfAbsent(new RequestKey(locale, includeIconContent), k -> new ComponentIndices(this.manager.find(c -> ((Stream)c.execute(() -> ((ContainerComponentRegistry)c.get(ContainerComponentRegistry.class)).getComponents().values().stream())).flatMap(component -> Stream.concat(component.getPartitionMappers().values().stream().map(mapper -> this.toComponentIndex((Container)c, locale, c.getId(), (ComponentFamilyMeta.BaseMeta)mapper, (ComponentManager.OriginalId)c.get(ComponentManager.OriginalId.class), includeIconContent)), component.getProcessors().values().stream().map(proc -> this.toComponentIndex((Container)c, locale, c.getId(), (ComponentFamilyMeta.BaseMeta)proc, (ComponentManager.OriginalId)c.get(ComponentManager.OriginalId.class), includeIconContent))))).collect(Collectors.toList())));
    }

    @GET
    @Path(value="icon/family/{id}")
    @Produces(value={"application/json", "application/octet-stream"})
    @Operation(description="Returns the icon for a family.")
    @APIResponses(value={@APIResponse(responseCode="200", description="Returns a particular family icon in raw bytes.", content={@Content(mediaType="application/octet-stream")}), @APIResponse(responseCode="404", description="The family or icon is not found", content={@Content(mediaType="application/json")})})
    public Response familyIcon(@PathParam(value="id") @Parameter(name="id", description="the family identifier", in=ParameterIn.PATH) String id) {
        ComponentFamilyMeta meta = this.componentFamilyDao.findById(id);
        if (meta == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.FAMILY_MISSING, "No family for identifier: " + id)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        Optional plugin = this.manager.findPlugin(meta.getPlugin());
        if (!plugin.isPresent()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.PLUGIN_MISSING, "No plugin '" + meta.getPlugin() + "' for identifier: " + id)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        IconResolver.Icon iconContent = this.iconResolver.resolve((Container)plugin.get(), meta.getIcon());
        if (iconContent == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.ICON_MISSING, "No icon for family identifier: " + id)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        return Response.ok((Object)iconContent.getBytes()).type(iconContent.getType()).build();
    }

    @GET
    @Path(value="icon/{id}")
    @Produces(value={"application/json", "application/octet-stream"})
    @Operation(description="Returns a particular component icon in raw bytes.")
    @APIResponses(value={@APIResponse(responseCode="200", description="The component icon in binary form.", content={@Content(mediaType="application/octet-stream")}), @APIResponse(responseCode="404", description="The family or icon is not found", content={@Content(mediaType="application/json")})})
    public Response icon(@PathParam(value="id") @Parameter(name="id", description="the component icon identifier", in=ParameterIn.PATH) String id) {
        ComponentFamilyMeta.BaseMeta meta = this.componentDao.findById(id);
        if (meta == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.COMPONENT_MISSING, "No component for identifier: " + id)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        Optional plugin = this.manager.findPlugin(meta.getParent().getPlugin());
        if (!plugin.isPresent()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.PLUGIN_MISSING, "No plugin '" + meta.getParent().getPlugin() + "' for identifier: " + id)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        IconResolver.Icon iconContent = this.iconResolver.resolve((Container)plugin.get(), meta.getIcon());
        if (iconContent == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.ICON_MISSING, "No icon for identifier: " + id)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        return Response.ok((Object)iconContent.getBytes()).type(iconContent.getType()).build();
    }

    @POST
    @Path(value="migrate/{id}/{configurationVersion}")
    @Operation(description="Allows to migrate a component configuration without calling any component execution.")
    @APIResponses(value={@APIResponse(responseCode="200", description="the new configuration for that component (or the same if no migration was needed).", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="The component is not found", content={@Content(mediaType="application/json")})})
    public Map<String, String> migrate(@PathParam(value="id") @Parameter(name="id", description="the component identifier", in=ParameterIn.PATH) String id, @PathParam(value="configurationVersion") @Parameter(name="configurationVersion", description="the configuration version you send", in=ParameterIn.PATH) int version, @RequestBody(description="the actual configuration in key/value form.", required=true, content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT))}) Map<String, String> config) {
        return Optional.ofNullable(this.componentDao.findById(id)).orElseThrow(() -> new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.COMPONENT_MISSING, "Didn't find component " + id)).build())).getMigrationHandler().migrate(version, config);
    }

    @GET
    @Path(value="details")
    @Operation(description="Returns the set of metadata about a few components identified by their 'id'.")
    @APIResponses(value={@APIResponse(responseCode="200", description="the list of details for the requested components.", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="400", description="Some identifiers were not valid.", content={@Content(mediaType="application/json")})})
    public ComponentDetailList getDetail(@QueryParam(value="language") @DefaultValue(value="en") @Parameter(name="language", description="the language for display names.", in=ParameterIn.QUERY, schema=@Schema(type=SchemaType.STRING, defaultValue="en")) String language, @QueryParam(value="identifiers") @Parameter(name="identifiers", description="the component identifiers to request.", in=ParameterIn.QUERY) String[] ids) {
        if (ids == null || ids.length == 0) {
            return new ComponentDetailList(Collections.emptyList());
        }
        HashMap errors = new HashMap();
        List details = Stream.of(ids).map(id -> Optional.ofNullable(this.componentDao.findById((String)id)).orElseGet(() -> {
            errors.put(id, new ErrorPayload(ErrorDictionary.COMPONENT_MISSING, "No component '" + id + "'"));
            return null;
        })).filter(Objects::nonNull).map(meta -> {
            Optional plugin = this.manager.findPlugin(meta.getParent().getPlugin());
            if (!plugin.isPresent()) {
                errors.put(meta.getId(), new ErrorPayload(ErrorDictionary.PLUGIN_MISSING, "No plugin '" + meta.getParent().getPlugin() + "'"));
                return null;
            }
            Container container = (Container)plugin.get();
            Optional<Object> model = Optional.ofNullable(meta.get(DesignModel.class));
            if (!model.isPresent()) {
                errors.put(meta.getId(), new ErrorPayload(ErrorDictionary.DESIGN_MODEL_MISSING, "No design model '" + meta.getId() + "'"));
                return null;
            }
            Locale locale = this.localeMapper.mapLocale(language);
            ComponentDetail componentDetail = new ComponentDetail();
            componentDetail.setLinks(Collections.emptyList());
            componentDetail.setId(this.createMetaId(container, (ComponentFamilyMeta.BaseMeta<Object>)meta));
            componentDetail.setVersion(meta.getVersion());
            componentDetail.setIcon(meta.getIcon());
            componentDetail.setInputFlows(((DesignModel)model.get()).getInputFlows());
            componentDetail.setOutputFlows(((DesignModel)model.get()).getOutputFlows());
            componentDetail.setType(ComponentFamilyMeta.ProcessorMeta.class.isInstance(meta) ? "processor" : "input");
            componentDetail.setDisplayName(meta.findBundle((ClassLoader)container.getLoader(), locale).displayName().orElse(meta.getName()));
            componentDetail.setProperties((Collection)this.propertiesService.buildProperties(meta.getParameterMetas(), (ClassLoader)container.getLoader(), locale, null).collect(Collectors.toList()));
            componentDetail.setActions(this.actionsService.findActions(meta.getParent().getName(), container, locale, (ComponentFamilyMeta.BaseMeta<Object>)meta));
            return componentDetail;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (!errors.isEmpty()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(errors).build());
        }
        return new ComponentDetailList(details);
    }

    private ComponentId createMetaId(Container container, ComponentFamilyMeta.BaseMeta<Object> meta) {
        return new ComponentId(meta.getId(), meta.getParent().getId(), meta.getParent().getPlugin(), Optional.ofNullable(container.get(ComponentManager.OriginalId.class)).map(ComponentManager.OriginalId::getValue).orElse(container.getId()), meta.getParent().getName(), meta.getName());
    }

    private ComponentIndex toComponentIndex(Container container, Locale locale, String plugin, ComponentFamilyMeta.BaseMeta meta, ComponentManager.OriginalId originalId, boolean includeIcon) {
        ConfigurableClassLoader loader = container.getLoader();
        String icon = meta.getIcon();
        String familyIcon = meta.getParent().getIcon();
        IconResolver.Icon iconContent = this.iconResolver.resolve(container, icon);
        IconResolver.Icon iconFamilyContent = this.iconResolver.resolve(container, familyIcon);
        String familyDisplayName = meta.getParent().findBundle((ClassLoader)loader, locale).displayName().orElse(meta.getParent().getName());
        List categories = Optional.ofNullable(meta.getParent().getCategories()).map(arg_0 -> this.lambda$toComponentIndex$22(meta, (ClassLoader)loader, locale, familyDisplayName, arg_0)).orElseGet(Collections::emptyList);
        return new ComponentIndex(new ComponentId(meta.getId(), meta.getParent().getId(), plugin, Optional.ofNullable(originalId).map(ComponentManager.OriginalId::getValue).orElse(plugin), meta.getParent().getName(), meta.getName()), meta.findBundle((ClassLoader)loader, locale).displayName().orElse(meta.getName()), familyDisplayName, new Icon(icon, iconContent == null ? null : iconContent.getType(), !includeIcon ? null : (iconContent == null ? null : iconContent.getBytes())), new Icon(familyIcon, iconFamilyContent == null ? null : iconFamilyContent.getType(), !includeIcon ? null : (iconFamilyContent == null ? null : iconFamilyContent.getBytes())), meta.getVersion(), (Collection)categories, Collections.singletonList(new Link("Detail", "/component/details?identifiers=" + meta.getId(), "application/json")));
    }

    private String normalizeCategory(String category) {
        if (!category.contains("${family}")) {
            return category + "/${family}";
        }
        return category;
    }

    private /* synthetic */ List lambda$toComponentIndex$22(ComponentFamilyMeta.BaseMeta meta, ClassLoader loader, Locale locale, String familyDisplayName, Collection vals) {
        return vals.stream().map(this::normalizeCategory).map(category -> category.replace("${family}", meta.getParent().getName())).map(category -> meta.getParent().findBundle(loader, locale).category(category).orElseGet(() -> category.replace("/" + meta.getParent().getName() + "/", "/" + familyDisplayName + "/"))).collect(Collectors.toList());
    }
}

