/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.front;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.ParameterIn;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.runtime.manager.ContainerComponentRegistry;
import org.talend.sdk.component.runtime.manager.ServiceMeta;
import org.talend.sdk.component.server.dao.ComponentActionDao;
import org.talend.sdk.component.server.front.model.ActionItem;
import org.talend.sdk.component.server.front.model.ActionList;
import org.talend.sdk.component.server.front.model.ErrorDictionary;
import org.talend.sdk.component.server.front.model.error.ErrorPayload;
import org.talend.sdk.component.server.service.LocaleMapper;
import org.talend.sdk.component.server.service.PropertiesService;
import org.talend.sdk.component.server.service.httpurlconnection.IgnoreNetAuthenticator;

@Tag(name="Action", description="Endpoints related to callbacks/triggers execution.")
@Path(value="action")
@ApplicationScoped
@IgnoreNetAuthenticator
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ActionResource {
    private static final Logger log = LoggerFactory.getLogger(ActionResource.class);
    @Inject
    private ComponentManager manager;
    @Inject
    private ComponentActionDao actionDao;
    @Inject
    private PropertiesService propertiesService;
    @Inject
    private LocaleMapper localeMapper;

    @POST
    @Path(value="execute")
    @Operation(description="This endpoint will execute any UI action and serialize the response as a JSON (pojo model). It takes as input the family, type and name of the related action to identify it and its configuration as a flat key value set using the same kind of mapping than for components (option path as key).")
    @APIResponses(value={@APIResponse(responseCode="200", description="The action payload serialized in JSON.", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="400", description="If the action is not set, payload will be an ErrorPayload with the code ACTION_MISSING.", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="If the action can't be found, payload will be an ErrorPayload with the code ACTION_MISSING.", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="520", description="If the action execution failed, payload will be an ErrorPayload with the code ACTION_ERROR.", content={@Content(mediaType="application/json")})})
    public Response execute(@QueryParam(value="family") @Parameter(name="family", required=true, in=ParameterIn.QUERY, description="the component family") String family, @QueryParam(value="type") @Parameter(name="type", required=true, in=ParameterIn.QUERY, description="the type of action") String type, @QueryParam(value="action") @Parameter(name="action", required=true, in=ParameterIn.QUERY, description="the action name") String action, @QueryParam(value="lang") @DefaultValue(value="en") @Parameter(name="language", in=ParameterIn.QUERY, description="the requested language (as in a Locale) if supported by the action", schema=@Schema(defaultValue="en", type=SchemaType.STRING)) String lang, @RequestBody(description="the action parameters as a flat map of strings", required=true, content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT))}) Map<String, String> params) {
        if (action == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorPayload(ErrorDictionary.ACTION_MISSING, "Action can't be null")).build());
        }
        ServiceMeta.ActionMeta actionMeta = this.actionDao.findBy(family, type, action);
        if (actionMeta == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.ACTION_MISSING, "No action with id '" + action + "'")).build());
        }
        try {
            Map runtimeParams = Optional.ofNullable(params).map(HashMap::new).orElseGet(HashMap::new);
            runtimeParams.put("$lang", this.localeMapper.mapLocale(lang).getLanguage());
            Object result = actionMeta.getInvoker().apply(runtimeParams);
            return Response.ok(result).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (RuntimeException re) {
            log.warn(re.getMessage(), (Throwable)re);
            throw new WebApplicationException(Response.status((int)520, (String)"Unexpected callback error").entity((Object)new ErrorPayload(ErrorDictionary.ACTION_ERROR, "Action execution failed with: " + Optional.ofNullable(re.getMessage()).orElseGet(() -> NullPointerException.class.isInstance(re) ? "unexpected null" : "no error message"))).build());
        }
    }

    @GET
    @Path(value="index")
    @Operation(description="This endpoint returns the list of available actions for a certain family and potentially filters the output limiting it to some families and types of actions.")
    @APIResponse(responseCode="200", description="The action index.", content={@Content(mediaType="application/json")})
    public ActionList getIndex(final @QueryParam(value="type") @Parameter(name="type", in=ParameterIn.QUERY, description="the types of actions") String[] types, final @QueryParam(value="family") @Parameter(name="family", in=ParameterIn.QUERY, description="the families") String[] families, @QueryParam(value="language") @Parameter(name="language", description="the language to use", in=ParameterIn.QUERY, schema=@Schema(defaultValue="en", type=SchemaType.STRING)) @DefaultValue(value="en") String language) {
        Predicate<ServiceMeta.ActionMeta> typeMatcher = new Predicate<ServiceMeta.ActionMeta>(){
            private final Collection<String> accepted;
            {
                this.accepted = new HashSet<String>(Arrays.asList(types));
            }

            @Override
            public boolean test(ServiceMeta.ActionMeta actionMeta) {
                return this.accepted.isEmpty() || this.accepted.contains(actionMeta.getType());
            }
        };
        Predicate<ServiceMeta.ActionMeta> componentMatcher = new Predicate<ServiceMeta.ActionMeta>(){
            private final Collection<String> accepted;
            {
                this.accepted = new HashSet<String>(Arrays.asList(families));
            }

            @Override
            public boolean test(ServiceMeta.ActionMeta actionMeta) {
                return this.accepted.isEmpty() || this.accepted.contains(actionMeta.getFamily());
            }
        };
        Locale locale = this.localeMapper.mapLocale(language);
        return new ActionList((Collection)this.manager.find(c -> ((ContainerComponentRegistry)c.get(ContainerComponentRegistry.class)).getServices().stream().map(s -> s.getActions().stream()).flatMap(Function.identity()).filter(typeMatcher.and(componentMatcher)).map(s -> new ActionItem(s.getFamily(), s.getType(), s.getAction(), (Collection)this.propertiesService.buildProperties(s.getParameters(), (ClassLoader)c.getLoader(), locale, null).collect(Collectors.toList())))).collect(Collectors.toList()));
    }
}

