/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.configuration;

import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.talend.sdk.component.api.meta.Documentation;

@ApplicationScoped
public class ComponentServerConfiguration {
    @Inject
    @Documentation(value="If set it will replace any message for exceptions. Set to `false` to use the actual exception message.")
    @ConfigProperty(name="talend.component.server.jaxrs.exceptionhandler.defaultMessage", defaultValue="false")
    private String defaultExceptionMessage;
    @Inject
    @Documentation(value="The local maven repository used to locate components and their dependencies")
    @ConfigProperty(name="talend.component.server.maven.repository")
    private Optional<String> mavenRepository;
    @Inject
    @Documentation(value="A comma separated list of gav to locate the components")
    @ConfigProperty(name="talend.component.server.component.coordinates")
    private Optional<String> componentCoordinates;
    @Inject
    @Documentation(value="A property file where the value is a gav of a component to register (complementary with `coordinates`)")
    @ConfigProperty(name="talend.component.server.component.registry")
    private Optional<String> componentRegistry;
    @Inject
    @Documentation(value="The size of the execution pool for runtime endpoints.")
    @ConfigProperty(name="talend.component.server.execution.pool.size", defaultValue="64")
    private Integer executionPoolSize;
    @Inject
    @Documentation(value="How long the application waits during shutdown for the execution tasks to complete")
    @ConfigProperty(name="talend.component.server.execution.pool.wait", defaultValue="PT10S")
    private String executionPoolShutdownTimeout;
    @Inject
    @Documentation(value="How long the read execution endpoint can last (max)")
    @ConfigProperty(name="talend.component.server.execution.dataset.retriever.timeout", defaultValue="180")
    private Long datasetRetrieverTimeout;
    @Inject
    @Documentation(value="The name used by the brave integration (zipkin)")
    @ConfigProperty(name="talend.component.server.monitoring.brave.service.name", defaultValue="component-server")
    private String serviceName;
    @Inject
    @Documentation(value="The accuracy rate of the sampling.")
    @ConfigProperty(name="talend.component.server.monitoring.brave.sampling.rate", defaultValue="-1.")
    private Float samplerRate;
    @Inject
    @Documentation(value="The accuracy rate of the sampling for environment endpoints.")
    @ConfigProperty(name="talend.component.server.monitoring.brave.sampling.environment.rate", defaultValue="-1")
    private Float samplerEnvironmentRate;
    @Inject
    @Documentation(value="The accuracy rate of the sampling for environment endpoints.")
    @ConfigProperty(name="talend.component.server.monitoring.brave.sampling.configurationtype.rate", defaultValue="-1")
    private Float samplerConfigurationTypeRate;
    @Inject
    @Documentation(value="The accuracy rate of the sampling for component endpoints.")
    @ConfigProperty(name="talend.component.server.monitoring.brave.sampling.component.rate", defaultValue="-1")
    private Float samplerComponentRate;
    @Inject
    @Documentation(value="The accuracy rate of the sampling for documentation endpoint.")
    @ConfigProperty(name="talend.component.server.monitoring.brave.sampling.documentation.rate", defaultValue="-1")
    private Float samplerDocumentationRate;
    @Inject
    @Documentation(value="The accuracy rate of the sampling for action endpoints.")
    @ConfigProperty(name="talend.component.server.monitoring.brave.sampling.action.rate", defaultValue="-1")
    private Float samplerActionRate;
    @Inject
    @Documentation(value="The accuracy rate of the sampling for execution endpoints.")
    @ConfigProperty(name="talend.component.server.monitoring.brave.sampling.execution.rate", defaultValue="1")
    private Float samplerExecutionRate;
    @Inject
    @Documentation(value="The brave reporter to use to send the spans. Supported values are [log, noop]. When configuration is needed,you can use this syntax to configure the repoter if needed: `<name>(config1=value1, config2=value2)`, for example: `url(endpoint=http://brave.company.com`.\n\nIn `log` mode, if environment variable `TRACING_ON` doesn't exist or is set to `false`, `noop` will be selected, and is set to `true`, `TRACING_KAFKA_URL`, `TRACING_KAFKA_TOPIC` and `TRACING_SAMPLING_RATE` will configure `kafka` reporter..")
    @ConfigProperty(name="talend.component.server.monitoring.brave.reporter.type", defaultValue="noop")
    private String reporter;
    @Inject
    @Documentation(value="When using url or kafka reporter, you can configure the async reporter with properties passed to this configuration entry.Ex: `messageTimeout=5000,closeTimeout=5000`.")
    @ConfigProperty(name="talend.component.server.monitoring.brave.reporter.async", defaultValue="console")
    private String reporterAsyncConfiguration;
    @Inject
    @Documentation(value="Should the /documentation endpoint be activated.")
    @ConfigProperty(name="talend.component.server.documentation.active", defaultValue="true")
    private Boolean supportsDocumentation;
    @Inject
    @Documentation(value="How to validate a connection. Accepted values: securityNoopHandler.")
    @ConfigProperty(name="talend.component.server.security.connection.handler", defaultValue="securityNoopHandler")
    private String securityConnectionHandler;
    @Inject
    @Documentation(value="How to validate a command/request. Accepted values: securityNoopHandler.")
    @ConfigProperty(name="talend.component.server.security.command.handler", defaultValue="securityNoopHandler")
    private String securityCommandHandler;
    @Inject
    @Documentation(value="Should the component extensions add required dependencies.")
    @ConfigProperty(name="talend.component.server.component.extend.dependencies", defaultValue="true")
    private Boolean addExtensionDependencies;

    public String getDefaultExceptionMessage() {
        return this.defaultExceptionMessage;
    }

    public Optional<String> getMavenRepository() {
        return this.mavenRepository;
    }

    public Optional<String> getComponentCoordinates() {
        return this.componentCoordinates;
    }

    public Optional<String> getComponentRegistry() {
        return this.componentRegistry;
    }

    public Integer getExecutionPoolSize() {
        return this.executionPoolSize;
    }

    public String getExecutionPoolShutdownTimeout() {
        return this.executionPoolShutdownTimeout;
    }

    public Long getDatasetRetrieverTimeout() {
        return this.datasetRetrieverTimeout;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Float getSamplerRate() {
        return this.samplerRate;
    }

    public Float getSamplerEnvironmentRate() {
        return this.samplerEnvironmentRate;
    }

    public Float getSamplerConfigurationTypeRate() {
        return this.samplerConfigurationTypeRate;
    }

    public Float getSamplerComponentRate() {
        return this.samplerComponentRate;
    }

    public Float getSamplerDocumentationRate() {
        return this.samplerDocumentationRate;
    }

    public Float getSamplerActionRate() {
        return this.samplerActionRate;
    }

    public Float getSamplerExecutionRate() {
        return this.samplerExecutionRate;
    }

    public String getReporter() {
        return this.reporter;
    }

    public String getReporterAsyncConfiguration() {
        return this.reporterAsyncConfiguration;
    }

    public Boolean getSupportsDocumentation() {
        return this.supportsDocumentation;
    }

    public String getSecurityConnectionHandler() {
        return this.securityConnectionHandler;
    }

    public String getSecurityCommandHandler() {
        return this.securityCommandHandler;
    }

    public Boolean getAddExtensionDependencies() {
        return this.addExtensionDependencies;
    }
}

