/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.CDI;
import org.apache.meecrowave.Meecrowave;
import org.apache.meecrowave.runner.cli.CliOption;
import org.eclipse.microprofile.config.spi.ConfigSource;

@Vetoed
public class ComponentConfigurationLoader
implements ConfigSource {
    private final Map<String, String> map = new HashMap<String, String>();
    private volatile boolean init;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInit() {
        if (this.init) {
            return;
        }
        ComponentConfigurationLoader componentConfigurationLoader = this;
        synchronized (componentConfigurationLoader) {
            if (this.init) {
                return;
            }
            Meecrowave.Builder builder = (Meecrowave.Builder)CDI.current().select(Meecrowave.Builder.class, new Annotation[0]).get();
            this.map.putAll(this.asMap(builder.getProperties()));
            Optional.ofNullable(((Cli)builder.getExtension(Cli.class)).getConfiguration()).ifPresent(configuration -> {
                block30: {
                    File file = new File((String)configuration);
                    if (file.exists()) {
                        try (FileInputStream is = new FileInputStream(file);){
                            this.map.putAll(this.load(is));
                            break block30;
                        }
                        catch (IOException e) {
                            throw new IllegalArgumentException(e);
                        }
                    }
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    try (InputStream is = loader.getResourceAsStream((String)configuration);){
                        if (is != null) {
                            this.map.putAll(this.load(is));
                        }
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            });
            this.init = true;
        }
    }

    public Map<String, String> getProperties() {
        this.ensureInit();
        return this.map;
    }

    public Set<String> getPropertyNames() {
        this.ensureInit();
        return this.map.keySet();
    }

    public String getValue(String key) {
        this.ensureInit();
        return this.getProperties().get(key);
    }

    public String getName() {
        return "component-configuration";
    }

    public int getOrdinal() {
        return 1000;
    }

    private Map<String, String> load(InputStream is) throws IOException {
        Properties properties = new Properties();
        properties.load(is);
        return this.asMap(properties);
    }

    private Map<String, String> asMap(Properties properties) {
        return properties.stringPropertyNames().stream().collect(Collectors.toMap(Function.identity(), properties::getProperty));
    }

    public static class Cli {
        @CliOption(name="component-configuration", description="The file containing application configuration")
        private String configuration;

        public String getConfiguration() {
            return this.configuration;
        }

        public void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cli)) {
                return false;
            }
            Cli other = (Cli)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$configuration = this.getConfiguration();
            String other$configuration = other.getConfiguration();
            return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Cli;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $configuration = this.getConfiguration();
            result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
            return result;
        }

        public String toString() {
            return "ComponentConfigurationLoader.Cli(configuration=" + this.getConfiguration() + ")";
        }
    }
}

