/**
 * Copyright (C) 2006-2024 Talend Inc. - www.talend.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.talend.sdk.component.server.api;

import static javax.ws.rs.core.MediaType.APPLICATION_JSON;

import javax.ws.rs.GET;
import javax.ws.rs.Path;

import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.talend.sdk.component.server.front.model.Environment;

@Path("environment")
@Tag(name = "Environment", description = "Endpoint giving access to versions and last update timestamp of the server.")
public interface EnvironmentResource {

    @GET
    @Operation(operationId = "getEnvironment",
            description = "Returns the environment information of this instance. " +
                    "Useful to check the version or configure a healthcheck for the server.")
    @APIResponse(responseCode = "200",
            description = "Current environment representation.",
            content = @Content(mediaType = APPLICATION_JSON))
    Environment get();
}
