/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.api;

import java.util.Map;
import java.util.concurrent.CompletionStage;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.ParameterIn;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.talend.sdk.component.server.front.model.ActionList;
import org.talend.sdk.component.server.front.model.error.ErrorPayload;

@Path(value="action")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Tag(name="Action", description="Endpoints related to callbacks/triggers execution.")
public interface ActionResource {
    @POST
    @Path(value="execute")
    @Operation(description="This endpoint will execute any UI action and serialize the response as a JSON (pojo model). It takes as input the family, type and name of the related action to identify it and its configuration as a flat key value set using the same kind of mapping than for components (option path as key).")
    @APIResponses(value={@APIResponse(responseCode="200", description="The action payload serialized in JSON.", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="400", description="If the action is not set, payload will be an ErrorPayload with the code ACTION_MISSING.", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT, implementation=ErrorPayload.class))}), @APIResponse(responseCode="404", description="If the action can't be found, payload will be an ErrorPayload with the code ACTION_MISSING.", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT, implementation=ErrorPayload.class))}), @APIResponse(responseCode="520", description="If the action execution failed, payload will be an ErrorPayload with the code ACTION_ERROR.", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT, implementation=ErrorPayload.class))})})
    public CompletionStage<Response> execute(@QueryParam(value="family") @Parameter(name="family", required=true, in=ParameterIn.QUERY, description="the component family") String var1, @QueryParam(value="type") @Parameter(name="type", required=true, in=ParameterIn.QUERY, description="the type of action") String var2, @QueryParam(value="action") @Parameter(name="action", required=true, in=ParameterIn.QUERY, description="the action name") String var3, @QueryParam(value="lang") @DefaultValue(value="en") @Parameter(name="language", in=ParameterIn.QUERY, description="the requested language (as in a Locale) if supported by the action", schema=@Schema(defaultValue="en", type=SchemaType.STRING)) String var4, @RequestBody(description="the action parameters as a flat map of strings", required=true, content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT))}) Map<String, String> var5);

    @GET
    @Path(value="index")
    @Operation(description="This endpoint returns the list of available actions for a certain family and potentially filters the output limiting it to some families and types of actions.")
    @APIResponse(responseCode="200", description="The action index.", content={@Content(mediaType="application/json")})
    public ActionList getIndex(@QueryParam(value="type") @Parameter(name="type", in=ParameterIn.QUERY, description="the types of actions") String[] var1, @QueryParam(value="family") @Parameter(name="family", in=ParameterIn.QUERY, description="the families") String[] var2, @QueryParam(value="language") @Parameter(name="language", description="the language to use", in=ParameterIn.QUERY, schema=@Schema(defaultValue="en", type=SchemaType.STRING)) @DefaultValue(value="en") String var3);
}

