/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.api;

import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.ParameterIn;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.talend.sdk.component.server.front.model.ConfigTypeNodes;
import org.talend.sdk.component.server.front.model.error.ErrorPayload;

@Path(value="configurationtype")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Tag(name="Configuration Type", description="Endpoints related to configuration types (reusable configuration) metadata access.")
public interface ConfigurationTypeResource {
    @GET
    @Path(value="index")
    @Operation(description="Returns all available configuration type - storable models. Note that the lightPayload flag allows to load all of them at once when you eagerly need  to create a client model for all configurations.")
    @APIResponse(responseCode="200", description="the list of available and storable configurations (datastore, dataset, ...).", content={@Content(mediaType="application/json")})
    public ConfigTypeNodes getRepositoryModel(@QueryParam(value="language") @DefaultValue(value="en") @Parameter(name="language", description="the language for display names.", in=ParameterIn.QUERY, schema=@Schema(type=SchemaType.STRING, defaultValue="en")) String var1, @QueryParam(value="lightPayload") @DefaultValue(value="true") @Parameter(name="lightPayload", description="should the payload skip the forms and actions associated to the configuration.", in=ParameterIn.QUERY, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="true")) boolean var2, @QueryParam(value="q") @Parameter(name="q", description="Query in simple query language to filter configurations. It provides access to the configuration `type`, `name`, `type` and first configuration property `metadata`. See component index endpoint for a syntax example.", in=ParameterIn.QUERY, schema=@Schema(type=SchemaType.STRING)) String var3);

    @GET
    @Path(value="details")
    @Operation(operationId="getConfigurationDetail", description="Returns all available configuration type - storable models. Note that the lightPayload flag allows to load all of them at once when you eagerly need  to create a client model for all configurations.")
    @APIResponse(responseCode="200", description="the list of available and storable configurations (datastore, dataset, ...).", content={@Content(mediaType="application/json")})
    public ConfigTypeNodes getDetail(@QueryParam(value="language") @DefaultValue(value="en") @Parameter(name="language", description="the language for display names.", in=ParameterIn.QUERY, schema=@Schema(type=SchemaType.STRING, defaultValue="en")) String var1, @QueryParam(value="identifiers") @Parameter(name="identifiers", description="the comma separated list of identifiers to request.", in=ParameterIn.QUERY) String[] var2);

    @POST
    @Path(value="migrate/{id}/{configurationVersion}")
    @Operation(operationId="migrateConfiguration", description="Allows to migrate a configuration without calling any component execution.")
    @APIResponses(value={@APIResponse(responseCode="200", description="the new values for that configuration (or the same if no migration was needed).", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="400", description="If the configuration is missing, payload will be an ErrorPayload with the code CONFIGURATION_MISSING.", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT, implementation=ErrorPayload.class))}), @APIResponse(responseCode="404", description="The configuration is not found", content={@Content(mediaType="application/json")})})
    public Map<String, String> migrate(@PathParam(value="id") @Parameter(name="id", description="the configuration identifier", in=ParameterIn.PATH) String var1, @PathParam(value="configurationVersion") @Parameter(name="configurationVersion", description="the configuration version you send", in=ParameterIn.PATH) int var2, @RequestBody(description="the actual configuration in key/value form.", required=true, content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT))}) Map<String, String> var3);
}

