/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.testing.spark;

import java.io.File;
import org.junit.Assert;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.talend.sdk.component.runtime.testing.spark.internal.BaseSpark;

public class SparkClusterRule
extends BaseSpark<SparkClusterRule>
implements TestRule {
    private final TemporaryFolder temporaryFolder = new TemporaryFolder();

    public SparkClusterRule() {
    }

    public SparkClusterRule(String scala, String spark, int slaves) {
        ((SparkClusterRule)((SparkClusterRule)this.withScalaVersion(scala)).withSparkVersion(spark)).withSlaves(slaves);
    }

    public Statement apply(final Statement base, Description description) {
        return this.temporaryFolder.apply(new Statement(){

            public void evaluate() throws Throwable {
                try (BaseSpark.Instances closeable = SparkClusterRule.this.start();){
                    if (closeable.getException() != null) {
                        closeable.close();
                        throw closeable.getException();
                    }
                    base.evaluate();
                }
            }
        }, description);
    }

    @Override
    protected void fail(String message) {
        Assert.fail((String)message);
    }

    @Override
    protected void assertTrue(String message, boolean value) {
        Assert.assertTrue((String)message, (boolean)value);
    }

    @Override
    protected File getRoot() {
        return this.temporaryFolder.getRoot();
    }
}

