/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service.http;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.Generated;
import org.talend.sdk.component.api.service.http.Configurer;
import org.talend.sdk.component.runtime.manager.service.http.HttpRequest;

public class HttpRequestCreator
implements BiFunction<String, Object[], HttpRequest> {
    private final Function<Object[], String> httpMethodProvider;
    private final Function<Object[], String> urlProvide;
    private final Function<Object[], String> baseProvider;
    private final String pathTemplate;
    private final BiFunction<String, Object[], String> pathProvider;
    private final Function<Object[], Collection<String>> queryParamsProvider;
    private final Function<Object[], Map<String, String>> headersProvider;
    private final BiFunction<String, Object[], Optional<byte[]>> payloadProvider;
    private final Configurer configurer;
    private final Map<String, Function<Object[], Object>> configurerOptions;

    @Override
    public HttpRequest apply(String base, Object[] params) {
        return new HttpRequest(this.buildUrl(base, params), this.httpMethodProvider.apply(params), this.queryParamsProvider.apply(params), this.headersProvider.apply(params), this.configurer, this.configurerOptions, this.payloadProvider, params, null);
    }

    private String buildUrl(String base, Object[] params) {
        if (this.urlProvide == null) {
            String path = this.pathProvider.apply(this.pathTemplate, params);
            String realBase = this.baseProvider != null ? this.baseProvider.apply(params) : base;
            return this.appendPaths(realBase, path);
        }
        return this.pathProvider.apply(this.urlProvide.apply(params), params);
    }

    private String appendPaths(String p1, String p2) {
        if (p1.endsWith("/") && p2.startsWith("/")) {
            return p1 + p2.substring(1);
        }
        if (p1.endsWith("/") || p1.isEmpty() || p2.startsWith("/") || p2.isEmpty()) {
            return p1 + p2;
        }
        return p1 + "/" + p2;
    }

    @Generated
    public HttpRequestCreator(Function<Object[], String> httpMethodProvider, Function<Object[], String> urlProvide, Function<Object[], String> baseProvider, String pathTemplate, BiFunction<String, Object[], String> pathProvider, Function<Object[], Collection<String>> queryParamsProvider, Function<Object[], Map<String, String>> headersProvider, BiFunction<String, Object[], Optional<byte[]>> payloadProvider, Configurer configurer, Map<String, Function<Object[], Object>> configurerOptions) {
        this.httpMethodProvider = httpMethodProvider;
        this.urlProvide = urlProvide;
        this.baseProvider = baseProvider;
        this.pathTemplate = pathTemplate;
        this.pathProvider = pathProvider;
        this.queryParamsProvider = queryParamsProvider;
        this.headersProvider = headersProvider;
        this.payloadProvider = payloadProvider;
        this.configurer = configurer;
        this.configurerOptions = configurerOptions;
    }
}

