/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.component.MigrationHandler;
import org.talend.sdk.component.api.processor.ElementListener;
import org.talend.sdk.component.runtime.base.Lifecycle;
import org.talend.sdk.component.runtime.input.Mapper;
import org.talend.sdk.component.runtime.internationalization.ComponentBundle;
import org.talend.sdk.component.runtime.internationalization.FamilyBundle;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.runtime.manager.util.IdGenerator;
import org.talend.sdk.component.runtime.output.Processor;
import org.talend.sdk.component.runtime.standalone.DriverRunner;

public class ComponentFamilyMeta {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComponentFamilyMeta.class);
    private static final FamilyBundle NO_COMPONENT_BUNDLE = new FamilyBundle(null, null){

        public Optional<String> actionDisplayName(String type, String name) {
            return Optional.empty();
        }

        public Optional<String> category(String value) {
            return Optional.empty();
        }

        public Optional<String> configurationDisplayName(String type, String name) {
            return Optional.empty();
        }

        public Optional<String> displayName() {
            return Optional.empty();
        }
    };
    private final String id;
    private final String plugin;
    private final Collection<String> categories;
    private final String icon;
    private final String name;
    private final String packageName;
    private final Map<String, PartitionMapperMeta> partitionMappers = new HashMap<String, PartitionMapperMeta>();
    private final Map<String, ProcessorMeta> processors = new HashMap<String, ProcessorMeta>();
    private final Map<String, DriverRunnerMeta> driverRunners = new HashMap<String, DriverRunnerMeta>();
    private final ConcurrentMap<Locale, FamilyBundle> bundles = new ConcurrentHashMap<Locale, FamilyBundle>();

    public ComponentFamilyMeta(String plugin, Collection<String> categories, String icon, String name, String packageName) {
        this.id = IdGenerator.get(plugin, name);
        this.plugin = plugin;
        this.categories = categories;
        this.icon = icon;
        this.name = name;
        this.packageName = packageName;
    }

    public FamilyBundle findBundle(ClassLoader loader, Locale locale) {
        return this.bundles.computeIfAbsent(locale, l -> {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle((String)(this.packageName.isEmpty() ? this.packageName : this.packageName + ".") + "Messages", locale, loader);
                return new FamilyBundle(bundle, this.name + ".");
            }
            catch (MissingResourceException mre) {
                log.warn("No bundle for " + this.packageName + " (" + this.name + "), means the display names will be the technical names");
                log.debug(mre.getMessage(), (Throwable)mre);
                return NO_COMPONENT_BUNDLE;
            }
        });
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getPlugin() {
        return this.plugin;
    }

    @Generated
    public Collection<String> getCategories() {
        return this.categories;
    }

    @Generated
    public String getIcon() {
        return this.icon;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPackageName() {
        return this.packageName;
    }

    @Generated
    public Map<String, PartitionMapperMeta> getPartitionMappers() {
        return this.partitionMappers;
    }

    @Generated
    public Map<String, ProcessorMeta> getProcessors() {
        return this.processors;
    }

    @Generated
    public Map<String, DriverRunnerMeta> getDriverRunners() {
        return this.driverRunners;
    }

    @Generated
    public ConcurrentMap<Locale, FamilyBundle> getBundles() {
        return this.bundles;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComponentFamilyMeta)) {
            return false;
        }
        ComponentFamilyMeta other = (ComponentFamilyMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$plugin = this.getPlugin();
        String other$plugin = other.getPlugin();
        if (this$plugin == null ? other$plugin != null : !this$plugin.equals(other$plugin)) {
            return false;
        }
        Collection<String> this$categories = this.getCategories();
        Collection<String> other$categories = other.getCategories();
        if (this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$packageName = this.getPackageName();
        String other$packageName = other.getPackageName();
        if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
            return false;
        }
        Map<String, PartitionMapperMeta> this$partitionMappers = this.getPartitionMappers();
        Map<String, PartitionMapperMeta> other$partitionMappers = other.getPartitionMappers();
        if (this$partitionMappers == null ? other$partitionMappers != null : !((Object)this$partitionMappers).equals(other$partitionMappers)) {
            return false;
        }
        Map<String, ProcessorMeta> this$processors = this.getProcessors();
        Map<String, ProcessorMeta> other$processors = other.getProcessors();
        if (this$processors == null ? other$processors != null : !((Object)this$processors).equals(other$processors)) {
            return false;
        }
        Map<String, DriverRunnerMeta> this$driverRunners = this.getDriverRunners();
        Map<String, DriverRunnerMeta> other$driverRunners = other.getDriverRunners();
        if (this$driverRunners == null ? other$driverRunners != null : !((Object)this$driverRunners).equals(other$driverRunners)) {
            return false;
        }
        ConcurrentMap<Locale, FamilyBundle> this$bundles = this.getBundles();
        ConcurrentMap<Locale, FamilyBundle> other$bundles = other.getBundles();
        return !(this$bundles == null ? other$bundles != null : !this$bundles.equals(other$bundles));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ComponentFamilyMeta;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $plugin = this.getPlugin();
        result = result * 59 + ($plugin == null ? 43 : $plugin.hashCode());
        Collection<String> $categories = this.getCategories();
        result = result * 59 + ($categories == null ? 43 : ((Object)$categories).hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $packageName = this.getPackageName();
        result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
        Map<String, PartitionMapperMeta> $partitionMappers = this.getPartitionMappers();
        result = result * 59 + ($partitionMappers == null ? 43 : ((Object)$partitionMappers).hashCode());
        Map<String, ProcessorMeta> $processors = this.getProcessors();
        result = result * 59 + ($processors == null ? 43 : ((Object)$processors).hashCode());
        Map<String, DriverRunnerMeta> $driverRunners = this.getDriverRunners();
        result = result * 59 + ($driverRunners == null ? 43 : ((Object)$driverRunners).hashCode());
        ConcurrentMap<Locale, FamilyBundle> $bundles = this.getBundles();
        result = result * 59 + ($bundles == null ? 43 : $bundles.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ComponentFamilyMeta(id=" + this.getId() + ", plugin=" + this.getPlugin() + ", categories=" + this.getCategories() + ", icon=" + this.getIcon() + ", name=" + this.getName() + ", packageName=" + this.getPackageName() + ", partitionMappers=" + this.getPartitionMappers() + ", processors=" + this.getProcessors() + ", driverRunners=" + this.getDriverRunners() + ", bundles=" + this.getBundles() + ")";
    }

    public static class DriverRunnerMeta
    extends BaseMeta<DriverRunner> {
        protected DriverRunnerMeta(ComponentFamilyMeta parent, String name, String icon, int version, Class<?> type, Supplier<List<ParameterMeta>> parameterMetas, Function<Map<String, String>, DriverRunner> instantiator, Supplier<MigrationHandler> migrationHandler, boolean validated, Map<String, String> metas) {
            super(parent, name, icon, version, type, parameterMetas, migrationHandler, instantiator, validated, metas);
        }

        @Override
        @Generated
        public String toString() {
            return "ComponentFamilyMeta.DriverRunnerMeta()";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DriverRunnerMeta)) {
                return false;
            }
            DriverRunnerMeta other = (DriverRunnerMeta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DriverRunnerMeta;
        }

        @Override
        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    public static class ProcessorMeta
    extends BaseMeta<Processor> {
        protected ProcessorMeta(ComponentFamilyMeta parent, String name, String icon, int version, Class<?> type, Supplier<List<ParameterMeta>> parameterMetas, Function<Map<String, String>, Processor> instantiator, Supplier<MigrationHandler> migrationHandler, boolean validated, Map<String, String> metas) {
            super(parent, name, icon, version, type, parameterMetas, migrationHandler, instantiator, validated, metas);
        }

        public Method getListener() {
            return Stream.of(this.getType().getMethods()).filter(m -> m.isAnnotationPresent(ElementListener.class)).findFirst().orElseThrow(() -> new IllegalArgumentException("No @ElementListener method in " + this.getType()));
        }

        @Override
        @Generated
        public String toString() {
            return "ComponentFamilyMeta.ProcessorMeta()";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcessorMeta)) {
                return false;
            }
            ProcessorMeta other = (ProcessorMeta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ProcessorMeta;
        }

        @Override
        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    public static class PartitionMapperMeta
    extends BaseMeta<Mapper> {
        public static final String MAPPER_INFINITE = "mapper::infinite";

        protected PartitionMapperMeta(ComponentFamilyMeta parent, String name, String icon, int version, Class<?> type, Supplier<List<ParameterMeta>> parameterMetas, Function<Map<String, String>, Mapper> instantiator, Supplier<MigrationHandler> migrationHandler, boolean validated, Map<String, String> metas) {
            super(parent, name, icon, version, type, parameterMetas, migrationHandler, instantiator, validated, metas);
        }

        protected PartitionMapperMeta(ComponentFamilyMeta parent, String name, String icon, int version, Class<?> type, Supplier<List<ParameterMeta>> parameterMetas, Function<Map<String, String>, Mapper> instantiator, Supplier<MigrationHandler> migrationHandler, boolean validated, final boolean infinite) {
            super(parent, name, icon, version, type, parameterMetas, migrationHandler, instantiator, validated, (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put(PartitionMapperMeta.MAPPER_INFINITE, Boolean.toString(infinite));
                }
            });
        }

        public boolean isInfinite() {
            return Boolean.parseBoolean(this.getMetadata().getOrDefault(MAPPER_INFINITE, "false"));
        }

        @Override
        @Generated
        public String toString() {
            return "ComponentFamilyMeta.PartitionMapperMeta()";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PartitionMapperMeta)) {
                return false;
            }
            PartitionMapperMeta other = (PartitionMapperMeta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PartitionMapperMeta;
        }

        @Override
        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    public static class BaseMeta<T extends Lifecycle> {
        private static final ComponentBundle NO_COMPONENT_BUNDLE = new ComponentBundle(null, null){

            public Optional<String> displayName() {
                return Optional.empty();
            }
        };
        private final ComponentFamilyMeta parent;
        private final String name;
        private final String icon;
        private final int version;
        private final String packageName;
        private final Supplier<MigrationHandler> migrationHandler;
        private final Supplier<List<ParameterMeta>> parameterMetas;
        private final ConcurrentMap<Locale, ComponentBundle> bundles = new ConcurrentHashMap<Locale, ComponentBundle>();
        private final ConcurrentMap<Class<?>, Object> extensionsData = new ConcurrentHashMap();
        private final String id;
        private final Class<?> type;
        private final Function<Map<String, String>, T> instantiator;
        private final boolean validated;
        private final Map<String, String> metadata;

        BaseMeta(ComponentFamilyMeta parent, String name, String icon, int version, Class<?> type, Supplier<List<ParameterMeta>> parameterMetas, Supplier<MigrationHandler> migrationHandler, Function<Map<String, String>, T> instantiator, boolean validated, Map<String, String> metas) {
            this.parent = parent;
            this.name = name;
            this.icon = icon;
            this.version = version;
            this.packageName = Optional.ofNullable(type.getPackage()).map(Package::getName).orElse("");
            this.parameterMetas = parameterMetas;
            this.migrationHandler = migrationHandler;
            this.type = type;
            this.instantiator = instantiator;
            this.validated = validated;
            this.metadata = metas;
            this.id = IdGenerator.get(parent.getPlugin(), parent.getName(), name);
        }

        public ComponentBundle findBundle(ClassLoader loader, Locale locale) {
            return this.bundles.computeIfAbsent(locale, l -> {
                try {
                    ResourceBundle bundle = ResourceBundle.getBundle((String)(this.packageName.isEmpty() ? this.packageName : this.packageName + ".") + "Messages", locale, loader);
                    return new ComponentBundle(bundle, this.parent.name + "." + this.name + ".");
                }
                catch (MissingResourceException mre) {
                    log.warn("No bundle for " + this.packageName + " (" + this.parent.name + " / " + this.name + "), means the display names will be the technical names");
                    log.debug(mre.getMessage(), (Throwable)mre);
                    return NO_COMPONENT_BUNDLE;
                }
            });
        }

        public T instantiate(Map<String, String> configuration, int configVersion) {
            if (configuration == null) {
                return (T)((Lifecycle)this.getInstantiator().apply(null));
            }
            Supplier<MigrationHandler> migrationHandler = this.getMigrationHandler();
            Map migratedConfiguration = migrationHandler.get().migrate(configVersion, configuration);
            return (T)((Lifecycle)this.getInstantiator().apply(migratedConfiguration));
        }

        public <D> D set(Class<D> key, D instance) {
            return this.extensionsData.put(key, instance);
        }

        public <D> D get(Class<D> key) {
            return (D)this.extensionsData.get(key);
        }

        @Generated
        public ComponentFamilyMeta getParent() {
            return this.parent;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getIcon() {
            return this.icon;
        }

        @Generated
        public int getVersion() {
            return this.version;
        }

        @Generated
        public String getPackageName() {
            return this.packageName;
        }

        @Generated
        public Supplier<MigrationHandler> getMigrationHandler() {
            return this.migrationHandler;
        }

        @Generated
        public Supplier<List<ParameterMeta>> getParameterMetas() {
            return this.parameterMetas;
        }

        @Generated
        public ConcurrentMap<Locale, ComponentBundle> getBundles() {
            return this.bundles;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public Class<?> getType() {
            return this.type;
        }

        @Generated
        public Function<Map<String, String>, T> getInstantiator() {
            return this.instantiator;
        }

        @Generated
        public boolean isValidated() {
            return this.validated;
        }

        @Generated
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BaseMeta)) {
                return false;
            }
            BaseMeta other = (BaseMeta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getVersion() != other.getVersion()) {
                return false;
            }
            if (this.isValidated() != other.isValidated()) {
                return false;
            }
            ComponentFamilyMeta this$parent = this.getParent();
            ComponentFamilyMeta other$parent = other.getParent();
            if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$icon = this.getIcon();
            String other$icon = other.getIcon();
            if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
                return false;
            }
            String this$packageName = this.getPackageName();
            String other$packageName = other.getPackageName();
            if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
                return false;
            }
            Supplier<MigrationHandler> this$migrationHandler = this.getMigrationHandler();
            Supplier<MigrationHandler> other$migrationHandler = other.getMigrationHandler();
            if (this$migrationHandler == null ? other$migrationHandler != null : !this$migrationHandler.equals(other$migrationHandler)) {
                return false;
            }
            Supplier<List<ParameterMeta>> this$parameterMetas = this.getParameterMetas();
            Supplier<List<ParameterMeta>> other$parameterMetas = other.getParameterMetas();
            if (this$parameterMetas == null ? other$parameterMetas != null : !this$parameterMetas.equals(other$parameterMetas)) {
                return false;
            }
            ConcurrentMap<Locale, ComponentBundle> this$bundles = this.getBundles();
            ConcurrentMap<Locale, ComponentBundle> other$bundles = other.getBundles();
            if (this$bundles == null ? other$bundles != null : !this$bundles.equals(other$bundles)) {
                return false;
            }
            ConcurrentMap<Class<?>, Object> this$extensionsData = this.extensionsData;
            ConcurrentMap<Class<?>, Object> other$extensionsData = other.extensionsData;
            if (this$extensionsData == null ? other$extensionsData != null : !this$extensionsData.equals(other$extensionsData)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            Class<?> this$type = this.getType();
            Class<?> other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Function<Map<String, String>, T> this$instantiator = this.getInstantiator();
            Function<Map<String, String>, T> other$instantiator = other.getInstantiator();
            if (this$instantiator == null ? other$instantiator != null : !this$instantiator.equals(other$instantiator)) {
                return false;
            }
            Map<String, String> this$metadata = this.getMetadata();
            Map<String, String> other$metadata = other.getMetadata();
            return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BaseMeta;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getVersion();
            result = result * 59 + (this.isValidated() ? 79 : 97);
            ComponentFamilyMeta $parent = this.getParent();
            result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $icon = this.getIcon();
            result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
            String $packageName = this.getPackageName();
            result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
            Supplier<MigrationHandler> $migrationHandler = this.getMigrationHandler();
            result = result * 59 + ($migrationHandler == null ? 43 : $migrationHandler.hashCode());
            Supplier<List<ParameterMeta>> $parameterMetas = this.getParameterMetas();
            result = result * 59 + ($parameterMetas == null ? 43 : $parameterMetas.hashCode());
            ConcurrentMap<Locale, ComponentBundle> $bundles = this.getBundles();
            result = result * 59 + ($bundles == null ? 43 : $bundles.hashCode());
            ConcurrentMap<Class<?>, Object> $extensionsData = this.extensionsData;
            result = result * 59 + ($extensionsData == null ? 43 : $extensionsData.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            Class<?> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Function<Map<String, String>, T> $instantiator = this.getInstantiator();
            result = result * 59 + ($instantiator == null ? 43 : $instantiator.hashCode());
            Map<String, String> $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ComponentFamilyMeta.BaseMeta(parent=" + this.getParent() + ", name=" + this.getName() + ", icon=" + this.getIcon() + ", version=" + this.getVersion() + ", packageName=" + this.getPackageName() + ", migrationHandler=" + this.getMigrationHandler() + ", parameterMetas=" + this.getParameterMetas() + ", bundles=" + this.getBundles() + ", extensionsData=" + this.extensionsData + ", id=" + this.getId() + ", type=" + this.getType() + ", instantiator=" + this.getInstantiator() + ", validated=" + this.isValidated() + ", metadata=" + this.getMetadata() + ")";
        }
    }
}

