/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.reflect.visibility;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonCollectors;
import lombok.Generated;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.runtime.manager.reflect.visibility.VisibilityService;

public class PayloadMapper {
    private final JsonProvider jsonp = JsonProvider.provider();
    private static final VisibilityService VISIBILITY_SERVICE = new VisibilityService(JsonProvider.provider());
    private final JsonBuilderFactory factory = this.jsonp.createBuilderFactory(Collections.emptyMap());
    private final OnParameter parameterVisitor;
    private JsonObject globalPayload = null;

    public JsonObject visitAndMap(Collection<ParameterMeta> parameters, Map<String, String> payload) {
        return this.unflatten("", Optional.ofNullable(parameters).orElseGet(Collections::emptyList), payload == null ? Collections.emptyMap() : payload);
    }

    public void setGlobalPayload(JsonObject payload) {
        this.globalPayload = payload;
    }

    private JsonObject unflatten(String contextualPrefix, Collection<ParameterMeta> definitions, Map<String, String> config) {
        JsonObjectBuilder json = this.factory.createObjectBuilder();
        Optional.ofNullable(definitions).map(Collection::stream).orElseGet(Stream::empty).sorted(Comparator.comparing(ParameterMeta::getName)).forEach(meta -> this.onProperty(contextualPrefix, (Collection<ParameterMeta>)meta.getNestedParameters(), config, json, (ParameterMeta)meta));
        return json.build();
    }

    private void onProperty(String contextualPrefix, Collection<ParameterMeta> definitions, Map<String, String> config, JsonObjectBuilder json, ParameterMeta definition) {
        String name = definition.getName();
        String newPath = contextualPrefix + (contextualPrefix.isEmpty() ? "" : ".") + name;
        switch (definition.getType()) {
            case OBJECT: {
                this.onObject(definitions, definition, config, json, name, newPath);
                break;
            }
            case ARRAY: {
                this.onArray(definition.getNestedParameters(), definition, config, newPath, json, name);
                break;
            }
            case BOOLEAN: {
                String boolValue = config.get(newPath);
                if (boolValue == null || boolValue.isEmpty()) {
                    this.parameterVisitor.onParameter(definition, JsonValue.NULL);
                } else {
                    boolean value = Boolean.parseBoolean(boolValue.trim());
                    this.parameterVisitor.onParameter(definition, value ? JsonValue.TRUE : JsonValue.FALSE);
                    json.add(name, value);
                }
                Optional.ofNullable(boolValue).map(String::trim).filter(v -> !v.isEmpty()).ifPresent(v -> json.add(name, Boolean.parseBoolean(v)));
                break;
            }
            case NUMBER: {
                String numberValue = config.get(newPath);
                if (numberValue == null || numberValue.isEmpty()) {
                    this.parameterVisitor.onParameter(definition, JsonValue.NULL);
                    break;
                }
                Double value = Double.valueOf(numberValue.trim());
                this.parameterVisitor.onParameter(definition, (JsonValue)this.jsonp.createValue(value.doubleValue()));
                long asLong = value.longValue();
                if (value == (double)asLong) {
                    json.add(name, asLong);
                    break;
                }
                json.add(name, value.doubleValue());
                break;
            }
            case ENUM: 
            case STRING: {
                String value = config.get(newPath);
                this.parameterVisitor.onParameter(definition, (JsonValue)(value == null ? JsonValue.NULL : this.jsonp.createValue(value)));
                Optional.ofNullable(value).ifPresent(v -> json.add(name, v));
                break;
            }
        }
    }

    private void onObject(Collection<ParameterMeta> definitions, ParameterMeta meta, Map<String, String> config, JsonObjectBuilder json, String name, String currentPath) {
        if (!this.isVisible(meta)) {
            return;
        }
        JsonObject unflatten = this.unflatten(currentPath, definitions, config);
        if (!unflatten.isEmpty()) {
            json.add(name, (JsonValue)unflatten);
            this.parameterVisitor.onParameter(meta, (JsonValue)unflatten);
        } else {
            this.parameterVisitor.onParameter(meta, JsonValue.NULL);
        }
    }

    private boolean isVisible(ParameterMeta meta) {
        return this.globalPayload == null ? true : VISIBILITY_SERVICE.build(meta).isVisible(this.globalPayload);
    }

    private void onArray(Collection<ParameterMeta> definitions, ParameterMeta definition, Map<String, String> config, String currentPrefix, JsonObjectBuilder json, String name) {
        JsonArray array;
        if (definitions.size() == 1 && definitions.iterator().next().getPath().endsWith("[${index}]")) {
            ParameterMeta primitiveMeta = (ParameterMeta)definitions.stream().iterator().next();
            array = (JsonArray)config.entrySet().stream().filter(it -> ((String)it.getKey()).startsWith(currentPrefix + "[")).map(e -> new ArrayEntry((Map.Entry<String, String>)e, currentPrefix)).distinct().sorted(Comparator.comparing(it -> it.index)).map(entry -> this.onArrayPrimitive(primitiveMeta, (ArrayEntry)entry)).collect(JsonCollectors.toJsonArray());
        } else {
            array = (JsonArray)config.entrySet().stream().filter(it -> ((String)it.getKey()).startsWith(currentPrefix + "[")).map(e -> new ArrayEntry((Map.Entry<String, String>)e, (String)currentPrefix).index).distinct().sorted(Comparator.comparing(it -> it)).map(index -> this.unflatten(currentPrefix + "[" + index + "]", definitions, config)).collect(JsonCollectors.toJsonArray());
        }
        if (!array.isEmpty()) {
            json.add(name, (JsonValue)array);
            this.parameterVisitor.onParameter(definition, (JsonValue)array);
        } else {
            this.parameterVisitor.onParameter(definition, JsonValue.NULL);
        }
    }

    private JsonValue onArrayPrimitive(ParameterMeta itemDef, ArrayEntry e) {
        String value = e.entry.getValue();
        switch (itemDef.getType()) {
            case BOOLEAN: {
                return Boolean.parseBoolean(value.trim()) ? JsonValue.TRUE : JsonValue.FALSE;
            }
            case NUMBER: {
                Double number = Double.valueOf(value.trim());
                return number == (double)number.longValue() ? this.jsonp.createValue(number.longValue()) : this.jsonp.createValue(number.doubleValue());
            }
            case ENUM: 
            case STRING: {
                return this.jsonp.createValue(value);
            }
        }
        throw new IllegalArgumentException("Unsupported structure in array: " + itemDef.getType());
    }

    @Generated
    public PayloadMapper(OnParameter parameterVisitor) {
        this.parameterVisitor = parameterVisitor;
    }

    public static interface OnParameter {
        public void onParameter(ParameterMeta var1, JsonValue var2);
    }

    private static class ArrayEntry {
        private final Map.Entry<String, String> entry;
        private final int index;

        private ArrayEntry(Map.Entry<String, String> entry, String name) {
            this.entry = entry;
            String indexStr = entry.getKey().substring(name.length() + 1, entry.getKey().indexOf(93, name.length()));
            this.index = Integer.parseInt(indexStr);
        }
    }
}

