/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.reflect;

import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.component.MigrationHandler;
import org.talend.sdk.component.api.component.Version;
import org.talend.sdk.component.runtime.base.lang.exception.InvocationExceptionWrapper;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.runtime.manager.reflect.ReflectionService;
import org.talend.sdk.component.runtime.manager.util.Lazy;

public class MigrationHandlerFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationHandlerFactory.class);
    private static final MigrationHandler NO_MIGRATION = (incomingVersion, incomingData) -> incomingData;
    private final ReflectionService reflections;

    public MigrationHandler findMigrationHandler(Supplier<List<ParameterMeta>> parameterMetas, Class<?> type, ComponentManager.AllServices services) {
        return (incomingVersion, incomingData) -> Lazy.lazy(() -> this.lambda$findMigrationHandler$1((Supplier)parameterMetas, type, services)).get().migrate(incomingVersion, incomingData);
    }

    private MigrationHandler createHandler(List<ParameterMeta> parameterMetas, Class<?> type, ComponentManager.AllServices services) {
        MigrationHandler implicitMigrationHandler = Optional.ofNullable(parameterMetas).map(Collection::stream).orElseGet(Stream::empty).flatMap(this::getNestedConfigType).sorted(Comparator.comparingInt(o -> o.getPath().length())).map(p -> {
            Class jType = (Class)Class.class.cast(p.getJavaType());
            MigrationHandler handler = this.findMigrationHandler(Collections::emptyList, jType, services);
            if (handler == NO_MIGRATION) {
                return null;
            }
            return map -> this.buildMigrationFunction((ParameterMeta)p, handler, p.getPath(), (Map<String, String>)map, Optional.ofNullable(jType.getAnnotation(Version.class)).map(Version::value).orElse(-1));
        }).filter(Objects::nonNull).reduce(NO_MIGRATION, (current, partial) -> (incomingVersion, incomingData) -> current.migrate(incomingVersion, (Map)partial.apply(incomingData)), (h1, h2) -> (incomingVersion, incomingData) -> h2.migrate(incomingVersion, h1.migrate(incomingVersion, incomingData)));
        if (parameterMetas != null && parameterMetas.size() == 1 && parameterMetas.iterator().next().getJavaType() == type) {
            return implicitMigrationHandler;
        }
        return Optional.ofNullable(type.getAnnotation(Version.class)).map(Version::migrationHandler).filter(t -> t != MigrationHandler.class).flatMap(t -> Stream.of(t.getConstructors()).min((o1, o2) -> o2.getParameterCount() - o1.getParameterCount())).map(t -> services.getServices().computeIfAbsent(t.getDeclaringClass(), k -> {
            try {
                return t.newInstance(this.reflections.parameterFactory((Executable)t, services.getServices(), null).apply(Collections.emptyMap()));
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvocationTargetException e) {
                throw InvocationExceptionWrapper.toRuntimeException((InvocationTargetException)e);
            }
        })).map(MigrationHandler.class::cast).map(h -> {
            if (implicitMigrationHandler == NO_MIGRATION) {
                return h;
            }
            return (incomingVersion, incomingData) -> {
                Map configuration = implicitMigrationHandler.migrate(incomingVersion, incomingData);
                return h.migrate(incomingVersion, configuration);
            };
        }).orElse(implicitMigrationHandler);
    }

    private Stream<ParameterMeta> getNestedConfigType(ParameterMeta parameterMeta) {
        if (parameterMeta.getNestedParameters().isEmpty() && parameterMeta.getType() != ParameterMeta.Type.OBJECT) {
            return Stream.empty();
        }
        return Stream.concat(parameterMeta.getJavaType() instanceof Class && parameterMeta.getMetadata().keySet().stream().anyMatch(k -> k.startsWith("tcomp::configurationtype::")) ? Stream.of(parameterMeta) : Stream.empty(), Optional.ofNullable(parameterMeta.getNestedParameters()).map(Collection::stream).orElseGet(Stream::empty).flatMap(this::getNestedConfigType));
    }

    private Map<String, String> buildMigrationFunction(ParameterMeta p, MigrationHandler handler, String prefix, Map<String, String> map, Integer currentVersion) {
        String versionPath = String.format("%s.__version", prefix);
        String version = map.get(versionPath);
        HashMap<String, String> result = new HashMap<String, String>(map);
        if (version != null && Integer.parseInt(version.trim()) < currentVersion) {
            Map<String, String> toMigrate = this.stripPrefix(prefix, map);
            toMigrate.keySet().forEach(result::remove);
            Map migrated = Optional.ofNullable(handler.migrate(Integer.parseInt(version.trim()), toMigrate.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).substring(prefix.length() + 1), Map.Entry::getValue)))).orElseGet(Collections::emptyMap);
            result.putAll(migrated.entrySet().stream().collect(Collectors.toMap(e -> prefix + '.' + (String)e.getKey(), Map.Entry::getValue)));
            result.put(versionPath, currentVersion.toString());
        } else {
            log.debug("No version for {} so skipping any potential migration", (Object)p.getJavaType().toString());
        }
        return result;
    }

    private Map<String, String> stripPrefix(String prefix, Map<String, String> map) {
        return map.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefix + '.') && !((String)e.getKey()).endsWith(".__version")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Generated
    public MigrationHandlerFactory(ReflectionService reflections) {
        this.reflections = reflections;
    }

    private /* synthetic */ MigrationHandler lambda$findMigrationHandler$1(Supplier parameterMetas, Class type, ComponentManager.AllServices services) {
        return this.createHandler((List)parameterMetas.get(), type, services);
    }
}

