/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.talend.sdk.component.api.service.BaseService;
import org.talend.sdk.component.api.service.serialization.Serial;
import org.talend.sdk.component.classloader.ThreadHelper;
import org.talend.sdk.component.runtime.base.lang.exception.InvocationExceptionWrapper;
import org.talend.sdk.component.runtime.manager.asm.ProxyGenerator;
import org.talend.sdk.component.runtime.manager.interceptor.InterceptorHandlerFacade;
import org.talend.sdk.component.runtime.serialization.SerializableService;

public class ServiceHelper {
    private final ProxyGenerator proxyGenerator;
    private final Map<Class<?>, Object> allServices;

    public Object createServiceInstance(ClassLoader loader, String containerId, Class<?> serviceClass) throws NoSuchMethodException {
        try {
            Class<?> proxyClass = this.handleProxy(loader, containerId, serviceClass);
            Object instance = proxyClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (this.proxyGenerator.hasInterceptors(serviceClass)) {
                this.proxyGenerator.initialize(instance, new InterceptorHandlerFacade(serviceClass.getConstructor(new Class[0]).newInstance(new Object[0]), this.allServices));
            }
            if (instance instanceof BaseService) {
                this.updateService((BaseService)instance, containerId, serviceClass.getName());
            }
            return instance;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw InvocationExceptionWrapper.toRuntimeException((InvocationTargetException)e);
        }
    }

    private Class<?> handleProxy(ClassLoader loader, String containerId, Class<?> type) {
        if (!this.proxyGenerator.hasInterceptors(type) && this.proxyGenerator.isSerializable(type)) {
            return type;
        }
        return (Class)ThreadHelper.runWithClassLoader(() -> this.proxyGenerator.generateProxy(loader, type, containerId, type.getName()), (ClassLoader)loader);
    }

    private void updateService(BaseService service, String pluginId, String key) {
        if (service.getSerializationHelper() == null) {
            service.setSerializationHelper((Serial)new SerializableService(pluginId, key));
        }
    }

    public ServiceHelper(ProxyGenerator proxyGenerator, Map<Class<?>, Object> allServices) {
        this.proxyGenerator = proxyGenerator;
        this.allServices = allServices;
    }
}

