/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.util;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public class MemoizingSupplier<T>
implements Supplier<T> {
    private final Lock lock = new ReentrantLock();
    private final Supplier<T> delegate;
    private volatile T value = null;

    public MemoizingSupplier(Supplier<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public T get() {
        if (this.value == null) {
            this.lock.lock();
            try {
                if (this.value == null) {
                    this.value = this.delegate.get();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.value;
    }
}

