/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.proxy;

import java.io.Externalizable;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.talend.sdk.component.runtime.manager.proxy.SerializationHandlerReplacer;
import org.talend.sdk.component.runtime.reflect.Defaults;

public class JavaProxyEnricherFactory {
    public Object asSerializable(ClassLoader loader, String plugin, String key, Object instanceToWrap) {
        return this.asSerializable(loader, plugin, key, instanceToWrap, false);
    }

    public Object asSerializable(ClassLoader loader, String plugin, String key, Object instanceToWrap, boolean force) {
        Class[] interfaces = instanceToWrap.getClass().getInterfaces();
        boolean isSerializable = Stream.of(interfaces).anyMatch(i -> i == Serializable.class || i == Externalizable.class);
        if (!force && isSerializable && !instanceToWrap.getClass().getName().startsWith("org.apache.johnzon.core.")) {
            return instanceToWrap;
        }
        Class[] api = isSerializable ? interfaces : (Class[])Stream.concat(Stream.of(Serializable.class), Stream.of(interfaces)).toArray(Class[]::new);
        return Proxy.newProxyInstance(this.selectLoader(api, loader), api, (InvocationHandler)new DelegatingSerializableHandler(instanceToWrap, plugin, key));
    }

    private ClassLoader selectLoader(Class[] api, ClassLoader loader) {
        if (Stream.of(api).anyMatch(t -> t.getClassLoader() == loader) || loader.getParent() == null || loader == ClassLoader.getSystemClassLoader()) {
            return loader;
        }
        ClassLoader parent = loader.getParent();
        if (parent == null) {
            return ClassLoader.getSystemClassLoader();
        }
        for (Class test : api) {
            try {
                parent.loadClass(test.getName());
            }
            catch (ClassNotFoundException e) {
                for (Class test2 : api) {
                    try {
                        loader.loadClass(test2.getName());
                    }
                    catch (ClassNotFoundException ex) {
                        throw new IllegalStateException("No matching classloader for " + Arrays.asList(api) + ":\nCurrent: " + loader + "\nParent: " + parent + "\nAPI: " + Stream.of(api).collect(Collectors.toMap(Function.identity(), Class::getClassLoader)) + "\n");
                    }
                }
                return loader;
            }
        }
        return parent;
    }

    private static class DelegatingSerializableHandler
    implements InvocationHandler,
    Serializable {
        private final Object delegate;
        private final String plugin;
        private final String key;
        private final ConcurrentMap<Method, Boolean> defaultMethods = new ConcurrentHashMap<Method, Boolean>();

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (Defaults.isDefaultAndShouldHandle((Method)method) && this.defaultMethods.computeIfAbsent(method, m -> {
                try {
                    this.delegate.getClass().getMethod(method.getName(), method.getParameterTypes());
                    return false;
                }
                catch (NoSuchMethodException e) {
                    return true;
                }
            }).booleanValue()) {
                return Defaults.handleDefault(method.getDeclaringClass(), (Method)method, (Object)proxy, (Object[])args);
            }
            if (Object.class == method.getDeclaringClass()) {
                switch (method.getName()) {
                    case "equals": {
                        return args != null && args.length == 1 && method.getDeclaringClass().isInstance(args[0]) && Proxy.isProxyClass(args[0].getClass()) && (this == Proxy.getInvocationHandler(args[0]) || this.delegate == Proxy.getInvocationHandler(args[0]));
                    }
                }
            }
            try {
                return method.invoke(this.delegate, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }

        Object writeReplace() throws ObjectStreamException {
            return new SerializationHandlerReplacer(this.plugin, this.key);
        }

        public DelegatingSerializableHandler(Object delegate, String plugin, String key) {
            this.delegate = delegate;
            this.plugin = plugin;
            this.key = key;
        }
    }
}

