/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.interceptor;

import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.talend.sdk.component.api.service.cache.Cached;
import org.talend.sdk.component.api.service.cache.LocalCache;
import org.talend.sdk.component.api.service.interceptor.InterceptorHandler;

public class CacheHandler
implements InterceptorHandler {
    private final BiFunction<Method, Object[], Object> invoker;
    private final LocalCache cache;
    private final ConcurrentMap<Method, Long> timeouts = new ConcurrentHashMap<Method, Long>();

    public CacheHandler(BiFunction<Method, Object[], Object> invoker, LocalCache cache) {
        this.invoker = invoker;
        this.cache = cache;
    }

    public Object invoke(Method method, Object[] args) {
        String key = this.toKey(method, args);
        long timeout = this.timeouts.computeIfAbsent(method, m -> ((Cached)this.findAnnotation((Method)m, Cached.class).get()).timeout());
        return this.cache.computeIfAbsent(Object.class, key, timeout, () -> this.invoker.apply(method, args));
    }

    private String toKey(Method method, Object[] args) {
        return method.getDeclaringClass().getName() + "#" + method.getName() + "(" + (args == null ? "" : Stream.of(args).map(s -> String.valueOf(s) + "/" + (s == null ? 0 : s.hashCode())).collect(Collectors.joining(","))) + ")";
    }
}

