/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.chain;

import org.talend.sdk.component.runtime.base.Lifecycle;
import org.talend.sdk.component.runtime.output.InputFactory;
import org.talend.sdk.component.runtime.output.OutputFactory;
import org.talend.sdk.component.runtime.output.Processor;

public class AutoChunkProcessor
implements Lifecycle {
    private final int chunkSize;
    private final Processor processor;
    private int processedItemCount = 0;

    public void onElement(InputFactory ins, OutputFactory outs) {
        if (this.processedItemCount == 0) {
            this.processor.beforeGroup();
        }
        try {
            this.processor.onNext(ins, outs);
            ++this.processedItemCount;
        }
        finally {
            if (this.processedItemCount == this.chunkSize) {
                this.processor.afterGroup(outs);
                this.processedItemCount = 0;
            }
        }
    }

    public void flush(OutputFactory outs) {
        if (this.processedItemCount > 0) {
            this.processor.afterGroup(outs);
            this.processedItemCount = 0;
        }
    }

    public void stop() {
        this.processor.stop();
    }

    public String plugin() {
        return this.processor.plugin();
    }

    public String rootName() {
        return this.processor.rootName();
    }

    public String name() {
        return this.processor.name();
    }

    public void start() {
        this.processor.start();
    }

    public AutoChunkProcessor(int chunkSize, Processor processor) {
        this.chunkSize = chunkSize;
        this.processor = processor;
    }
}

