/**
 * Copyright (C) 2006-2024 Talend Inc. - www.talend.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.talend.sdk.component.runtime.manager.service.http.codec;

import java.io.ByteArrayOutputStream;
import java.util.Map;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

import org.talend.sdk.component.api.service.http.Encoder;

import lombok.AllArgsConstructor;

@AllArgsConstructor
public class JAXBEncoder implements Encoder {

    private final Map<Class<?>, JAXBContext> jaxbContexts;

    @Override
    public byte[] encode(final Object value) {
        final ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            jaxbContexts.get(value.getClass()).createMarshaller().marshal(value, os);
        } catch (final JAXBException e) {
            throw new IllegalArgumentException(e);
        }
        return os.toByteArray();
    }
}
