/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javax.json.JsonBuilderFactory;
import javax.json.bind.Jsonb;
import javax.json.spi.JsonProvider;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.api.service.record.RecordBuilderFactory;
import org.talend.sdk.component.api.service.record.RecordService;
import org.talend.sdk.component.api.service.record.RecordVisitor;
import org.talend.sdk.component.runtime.record.RecordConverters;
import org.talend.sdk.component.runtime.serialization.SerializableService;

public class RecordServiceImpl
implements RecordService,
Serializable {
    private final String plugin;
    private final RecordBuilderFactory recordBuilderFactory;
    private final Supplier<JsonBuilderFactory> jsonBuilderFactorySupplier;
    private final Supplier<JsonProvider> jsonProvider;
    private final Supplier<Jsonb> jsonbSupplier;
    private final RecordConverters recordConverters = new RecordConverters();
    private final RecordConverters.MappingMetaRegistry mappingRegistry = new RecordConverters.MappingMetaRegistry();

    public Collector<Schema.Entry, Record.Builder, Record> toRecord(Schema schema, Record fallbackRecord, BiFunction<Schema.Entry, Record.Builder, Boolean> customHandler, BiConsumer<Record.Builder, Boolean> beforeFinish) {
        AtomicBoolean customHandlerCalled = new AtomicBoolean();
        return Collector.of(() -> this.recordBuilderFactory.newRecordBuilder(schema), (builder, entry) -> {
            if (!((Boolean)customHandler.apply((Schema.Entry)entry, (Record.Builder)builder)).booleanValue()) {
                this.forwardEntry(fallbackRecord, (Record.Builder)builder, entry.getName(), (Schema.Entry)entry);
            } else {
                customHandlerCalled.set(true);
            }
        }, (b1, b2) -> {
            throw new IllegalStateException("merge unsupported");
        }, builder -> {
            beforeFinish.accept((Record.Builder)builder, customHandlerCalled.get());
            return builder.build();
        }, new Collector.Characteristics[0]);
    }

    public Record create(Schema schema, Record fallbackRecord, BiFunction<Schema.Entry, Record.Builder, Boolean> customHandler, BiConsumer<Record.Builder, Boolean> beforeFinish) {
        return fallbackRecord.getSchema().getAllEntries().collect(this.toRecord(schema, fallbackRecord, customHandler, beforeFinish));
    }

    public <T> T visit(RecordVisitor<T> visitor, Record record) {
        AtomicReference out = new AtomicReference();
        record.getSchema().getAllEntries().forEach(entry -> {
            block0 : switch (entry.getType()) {
                case INT: {
                    visitor.onInt(entry, record.getOptionalInt(entry.getName()));
                    break;
                }
                case LONG: {
                    visitor.onLong(entry, record.getOptionalLong(entry.getName()));
                    break;
                }
                case FLOAT: {
                    visitor.onFloat(entry, record.getOptionalFloat(entry.getName()));
                    break;
                }
                case DOUBLE: {
                    visitor.onDouble(entry, record.getOptionalDouble(entry.getName()));
                    break;
                }
                case BOOLEAN: {
                    visitor.onBoolean(entry, record.getOptionalBoolean(entry.getName()));
                    break;
                }
                case STRING: {
                    String insideType = entry.getProp("talend.studio.type");
                    if ("id_Object".equals(insideType)) {
                        visitor.onObject(entry, Optional.ofNullable(record.get(Object.class, entry.getName())));
                        break;
                    }
                    visitor.onString(entry, record.getOptionalString(entry.getName()));
                    break;
                }
                case DATETIME: {
                    visitor.onDatetime(entry, record.getOptionalDateTime(entry.getName()));
                    break;
                }
                case DECIMAL: {
                    visitor.onDecimal(entry, record.getOptionalDecimal(entry.getName()));
                    break;
                }
                case BYTES: {
                    visitor.onBytes(entry, record.getOptionalBytes(entry.getName()));
                    break;
                }
                case RECORD: {
                    Optional optionalRecord = record.getOptionalRecord(entry.getName());
                    RecordVisitor recordVisitor = visitor.onRecord(entry, optionalRecord);
                    optionalRecord.ifPresent(r -> {
                        Object visited = this.visit((RecordVisitor)recordVisitor, (Record)r);
                        if (visited != null) {
                            Object current = out.get();
                            out.set(current == null ? visited : visitor.apply(current, visited));
                        }
                    });
                    break;
                }
                case ARRAY: {
                    Schema schema = entry.getElementSchema();
                    switch (schema.getType()) {
                        case INT: {
                            visitor.onIntArray(entry, record.getOptionalArray(Integer.TYPE, entry.getName()));
                            break block0;
                        }
                        case LONG: {
                            visitor.onLongArray(entry, record.getOptionalArray(Long.TYPE, entry.getName()));
                            break block0;
                        }
                        case FLOAT: {
                            visitor.onFloatArray(entry, record.getOptionalArray(Float.TYPE, entry.getName()));
                            break block0;
                        }
                        case DOUBLE: {
                            visitor.onDoubleArray(entry, record.getOptionalArray(Double.TYPE, entry.getName()));
                            break block0;
                        }
                        case BOOLEAN: {
                            visitor.onBooleanArray(entry, record.getOptionalArray(Boolean.TYPE, entry.getName()));
                            break block0;
                        }
                        case STRING: {
                            visitor.onStringArray(entry, record.getOptionalArray(String.class, entry.getName()));
                            break block0;
                        }
                        case DATETIME: {
                            visitor.onDatetimeArray(entry, record.getOptionalArray(ZonedDateTime.class, entry.getName()));
                            break block0;
                        }
                        case DECIMAL: {
                            visitor.onDecimalArray(entry, record.getOptionalArray(BigDecimal.class, entry.getName()));
                            break block0;
                        }
                        case BYTES: {
                            visitor.onBytesArray(entry, record.getOptionalArray(byte[].class, entry.getName()));
                            break block0;
                        }
                        case RECORD: {
                            Optional array = record.getOptionalArray(Record.class, entry.getName());
                            RecordVisitor recordArrayVisitor = visitor.onRecordArray(entry, array);
                            array.ifPresent(a -> a.forEach(r -> {
                                Object visited = this.visit((RecordVisitor)recordArrayVisitor, (Record)r);
                                if (visited != null) {
                                    Object current = out.get();
                                    out.set(current == null ? visited : visitor.apply(current, visited));
                                }
                            }));
                            break block0;
                        }
                    }
                    throw new IllegalStateException("Unsupported entry type: " + entry);
                }
                default: {
                    throw new IllegalStateException("Unsupported entry type: " + entry);
                }
            }
        });
        Object value = out.get();
        Object visited = visitor.get();
        if (value != null) {
            return (T)visitor.apply(value, visited);
        }
        return (T)visited;
    }

    public <T> T toObject(Record data, Class<T> expected) {
        return expected.cast(this.recordConverters.toType(this.mappingRegistry, (Object)data, expected, this.jsonBuilderFactorySupplier, this.jsonProvider, this.jsonbSupplier, () -> this.recordBuilderFactory));
    }

    public <T> Record toRecord(T data) {
        return this.recordConverters.toRecord(this.mappingRegistry, data, this.jsonbSupplier, () -> this.recordBuilderFactory);
    }

    public boolean forwardEntry(Record source, Record.Builder builder, String sourceColumn, Schema.Entry entry) {
        switch (entry.getType()) {
            case INT: {
                OptionalInt optionalInt = source.getOptionalInt(sourceColumn);
                optionalInt.ifPresent(v -> builder.withInt(entry, v));
                return optionalInt.isPresent();
            }
            case LONG: {
                OptionalLong optionalLong = source.getOptionalLong(sourceColumn);
                optionalLong.ifPresent(v -> builder.withLong(entry, v));
                return optionalLong.isPresent();
            }
            case FLOAT: {
                OptionalDouble optionalFloat = source.getOptionalFloat(sourceColumn);
                optionalFloat.ifPresent(v -> builder.withFloat(entry, (float)v));
                return optionalFloat.isPresent();
            }
            case DOUBLE: {
                OptionalDouble optionalDouble = source.getOptionalDouble(sourceColumn);
                optionalDouble.ifPresent(v -> builder.withDouble(entry, v));
                return optionalDouble.isPresent();
            }
            case BOOLEAN: {
                Optional optionalBoolean = source.getOptionalBoolean(sourceColumn);
                optionalBoolean.ifPresent(v -> builder.withBoolean(entry, v.booleanValue()));
                return optionalBoolean.isPresent();
            }
            case STRING: {
                Optional optionalString = source.getOptionalString(sourceColumn);
                optionalString.ifPresent(v -> builder.withString(entry, v));
                return optionalString.isPresent();
            }
            case DATETIME: {
                Optional optionalDateTime = source.getOptionalDateTime(sourceColumn);
                optionalDateTime.ifPresent(v -> builder.withDateTime(entry, v));
                return optionalDateTime.isPresent();
            }
            case DECIMAL: {
                Optional optionalDecimal = source.getOptionalDecimal(sourceColumn);
                optionalDecimal.ifPresent(v -> builder.withDecimal(entry, v));
                return optionalDecimal.isPresent();
            }
            case BYTES: {
                Optional optionalBytes = source.getOptionalBytes(sourceColumn);
                optionalBytes.ifPresent(v -> builder.withBytes(entry, v));
                return optionalBytes.isPresent();
            }
            case RECORD: {
                Optional optionalRecord = source.getOptionalRecord(sourceColumn);
                optionalRecord.ifPresent(v -> builder.withRecord(entry, v));
                return optionalRecord.isPresent();
            }
            case ARRAY: {
                Optional optionalArray = source.getOptionalArray(Object.class, sourceColumn);
                optionalArray.ifPresent(v -> builder.withArray(entry, v));
                return optionalArray.isPresent();
            }
        }
        throw new IllegalStateException("Unsupported entry type: " + entry);
    }

    Object writeReplace() {
        return new SerializableService(this.plugin, RecordService.class.getName());
    }

    public RecordServiceImpl(String plugin, RecordBuilderFactory recordBuilderFactory, Supplier<JsonBuilderFactory> jsonBuilderFactorySupplier, Supplier<JsonProvider> jsonProvider, Supplier<Jsonb> jsonbSupplier) {
        this.plugin = plugin;
        this.recordBuilderFactory = recordBuilderFactory;
        this.jsonBuilderFactorySupplier = jsonBuilderFactorySupplier;
        this.jsonProvider = jsonProvider;
        this.jsonbSupplier = jsonbSupplier;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public RecordBuilderFactory getRecordBuilderFactory() {
        return this.recordBuilderFactory;
    }

    public Supplier<JsonBuilderFactory> getJsonBuilderFactorySupplier() {
        return this.jsonBuilderFactorySupplier;
    }

    public Supplier<JsonProvider> getJsonProvider() {
        return this.jsonProvider;
    }

    public Supplier<Jsonb> getJsonbSupplier() {
        return this.jsonbSupplier;
    }

    public RecordConverters getRecordConverters() {
        return this.recordConverters;
    }

    public RecordConverters.MappingMetaRegistry getMappingRegistry() {
        return this.mappingRegistry;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecordServiceImpl)) {
            return false;
        }
        RecordServiceImpl other = (RecordServiceImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$plugin = this.getPlugin();
        String other$plugin = other.getPlugin();
        if (this$plugin == null ? other$plugin != null : !this$plugin.equals(other$plugin)) {
            return false;
        }
        RecordBuilderFactory this$recordBuilderFactory = this.getRecordBuilderFactory();
        RecordBuilderFactory other$recordBuilderFactory = other.getRecordBuilderFactory();
        if (this$recordBuilderFactory == null ? other$recordBuilderFactory != null : !this$recordBuilderFactory.equals(other$recordBuilderFactory)) {
            return false;
        }
        Supplier<JsonBuilderFactory> this$jsonBuilderFactorySupplier = this.getJsonBuilderFactorySupplier();
        Supplier<JsonBuilderFactory> other$jsonBuilderFactorySupplier = other.getJsonBuilderFactorySupplier();
        if (this$jsonBuilderFactorySupplier == null ? other$jsonBuilderFactorySupplier != null : !this$jsonBuilderFactorySupplier.equals(other$jsonBuilderFactorySupplier)) {
            return false;
        }
        Supplier<JsonProvider> this$jsonProvider = this.getJsonProvider();
        Supplier<JsonProvider> other$jsonProvider = other.getJsonProvider();
        if (this$jsonProvider == null ? other$jsonProvider != null : !this$jsonProvider.equals(other$jsonProvider)) {
            return false;
        }
        Supplier<Jsonb> this$jsonbSupplier = this.getJsonbSupplier();
        Supplier<Jsonb> other$jsonbSupplier = other.getJsonbSupplier();
        if (this$jsonbSupplier == null ? other$jsonbSupplier != null : !this$jsonbSupplier.equals(other$jsonbSupplier)) {
            return false;
        }
        RecordConverters this$recordConverters = this.getRecordConverters();
        RecordConverters other$recordConverters = other.getRecordConverters();
        if (this$recordConverters == null ? other$recordConverters != null : !this$recordConverters.equals(other$recordConverters)) {
            return false;
        }
        RecordConverters.MappingMetaRegistry this$mappingRegistry = this.getMappingRegistry();
        RecordConverters.MappingMetaRegistry other$mappingRegistry = other.getMappingRegistry();
        return !(this$mappingRegistry == null ? other$mappingRegistry != null : !this$mappingRegistry.equals(other$mappingRegistry));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RecordServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $plugin = this.getPlugin();
        result = result * 59 + ($plugin == null ? 43 : $plugin.hashCode());
        RecordBuilderFactory $recordBuilderFactory = this.getRecordBuilderFactory();
        result = result * 59 + ($recordBuilderFactory == null ? 43 : $recordBuilderFactory.hashCode());
        Supplier<JsonBuilderFactory> $jsonBuilderFactorySupplier = this.getJsonBuilderFactorySupplier();
        result = result * 59 + ($jsonBuilderFactorySupplier == null ? 43 : $jsonBuilderFactorySupplier.hashCode());
        Supplier<JsonProvider> $jsonProvider = this.getJsonProvider();
        result = result * 59 + ($jsonProvider == null ? 43 : $jsonProvider.hashCode());
        Supplier<Jsonb> $jsonbSupplier = this.getJsonbSupplier();
        result = result * 59 + ($jsonbSupplier == null ? 43 : $jsonbSupplier.hashCode());
        RecordConverters $recordConverters = this.getRecordConverters();
        result = result * 59 + ($recordConverters == null ? 43 : $recordConverters.hashCode());
        RecordConverters.MappingMetaRegistry $mappingRegistry = this.getMappingRegistry();
        result = result * 59 + ($mappingRegistry == null ? 43 : $mappingRegistry.hashCode());
        return result;
    }

    public String toString() {
        return "RecordServiceImpl(plugin=" + this.getPlugin() + ", recordBuilderFactory=" + this.getRecordBuilderFactory() + ", jsonBuilderFactorySupplier=" + this.getJsonBuilderFactorySupplier() + ", jsonProvider=" + this.getJsonProvider() + ", jsonbSupplier=" + this.getJsonbSupplier() + ", recordConverters=" + this.getRecordConverters() + ", mappingRegistry=" + this.getMappingRegistry() + ")";
    }
}

