/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service.path;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.runtime.manager.service.path.PathHandler;

public class PathHandlerImpl
implements PathHandler {
    private static final Logger log = LoggerFactory.getLogger(PathHandlerImpl.class);
    private static final Pattern MVN_PROPERTY = Pattern.compile("^\\$\\{(.*)\\}(.*)");
    private static final Pattern INTERPOLATE_P = Pattern.compile("^(\\$\\{(.*)\\}|~|/.:).*");

    protected Path interpolate(String path) {
        String p = path;
        if (INTERPOLATE_P.matcher(path).matches()) {
            Matcher matcher;
            if (p.startsWith("/") && p.indexOf(58) == 2) {
                p = p.substring(1);
            }
            if (p.startsWith("~")) {
                p = System.getProperty("user.home") + p.substring(1);
            }
            if ((matcher = MVN_PROPERTY.matcher(p)).matches()) {
                String prop = matcher.group(1);
                String value = prop.startsWith("env.") ? System.getenv(prop.substring("env.".length())) : System.getProperty(prop);
                p = value + matcher.group(2);
            }
        }
        return Paths.get(p, new String[0]);
    }

    protected Path exist(Path path) {
        if (path != null && Files.exists(path, new LinkOption[0])) {
            return path;
        }
        log.debug("[PathHandlerImpl] non existent path: {}.", (Object)path);
        return null;
    }

    @Override
    public Path get(String path) {
        return this.exist(this.interpolate(path));
    }
}

