/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service.http.configurer;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Base64;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.talend.sdk.component.api.service.http.Configurer;
import org.talend.sdk.component.api.service.http.configurer.oauth1.OAuth1;

public class OAuth1ProviderImpl
implements OAuth1.OAuth1Provider {
    public Map<String, String> buildParameters(String method, String url, byte[] payload, OAuth1.Configuration oauth1Config) {
        String algorithm = Optional.ofNullable(oauth1Config.getAlgorithm()).orElse("HMAC-SHA1");
        TreeMap<String, String> values = new TreeMap<String, String>();
        values.put("oauth_consumer_key", oauth1Config.getConsumerKey());
        values.put("oauth_nonce", Optional.ofNullable(oauth1Config.getNonce()).orElseGet(this::newNonce));
        values.put("oauth_signature_method", algorithm);
        values.put("oauth_timestamp", Optional.ofNullable(oauth1Config.getTimestamp()).map(String::valueOf).orElseGet(() -> Long.toString(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()))));
        values.put("oauth_version", "1.0");
        Optional.ofNullable(oauth1Config.getToken()).ifPresent(token -> values.put("oauth_token", (String)token));
        Optional.ofNullable(oauth1Config.getPayloadHashAlgorithm()).ifPresent(algo -> values.put("oauth_body_hash", this.hash((String)algo, Optional.ofNullable(payload).orElseGet(() -> new byte[0]))));
        Optional.ofNullable(oauth1Config.getOauthParameters()).ifPresent(values::putAll);
        values.entrySet().forEach(e -> e.setValue(this.encode((String)e.getValue())));
        values.putAll(this.extractQuery(url));
        String signature = this.sign(algorithm, this.signingString(values, method, url), oauth1Config);
        values.put("oauth_signature", signature);
        return values;
    }

    private Map<String, String> extractQuery(String url) {
        String query;
        if (url.contains("?") && !(query = url.substring(url.indexOf(63) + 1)).isEmpty()) {
            return Stream.of(query.split("&")).map(kv -> {
                int sep = kv.indexOf("=");
                if (sep > 0) {
                    return new String[]{kv.substring(0, sep), kv.substring(sep + 1)};
                }
                return new String[]{kv, ""};
            }).collect(Collectors.toMap(pair -> pair[0], pair -> pair[1]));
        }
        return Collections.emptyMap();
    }

    public Configurer newConfigurer() {
        return (connection, configuration) -> {
            OAuth1.Configuration oauth1Config = Stream.of(configuration.configuration()).filter(OAuth1.Configuration.class::isInstance).findFirst().map(OAuth1.Configuration.class::cast).orElseThrow(() -> new IllegalArgumentException("No OAuth1.Configuration @ConfigurerOption set"));
            Map<String, String> values = this.buildParameters(connection.getMethod(), connection.getUrl(), connection.getPayload(), oauth1Config);
            String authorization = Optional.ofNullable(oauth1Config.getHeaderPrefix()).orElse("OAuth ") + values.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("oauth_")).map(e -> (String)e.getKey() + "=\"" + (String)e.getValue() + "\"").collect(Collectors.joining(", "));
            connection.withHeader(Optional.ofNullable(oauth1Config.getHeader()).orElse("Authorization"), authorization);
        };
    }

    private String hash(String algo, byte[] payload) {
        if ("plain".equalsIgnoreCase(algo)) {
            return Base64.getEncoder().encodeToString(payload);
        }
        try {
            MessageDigest digest = MessageDigest.getInstance(algo);
            return Base64.getEncoder().encodeToString(digest.digest(payload));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Invalid hashing computation using algorithm: " + algo, e);
        }
    }

    private String sign(String algorithm, String signingString, OAuth1.Configuration configuration) {
        if (algorithm.toLowerCase(Locale.ROOT).contains("hmac")) {
            byte[] signingKey = Optional.ofNullable(configuration.getSigningHmacKey()).orElseGet(() -> Stream.of(configuration.getConsumerSecret(), configuration.getTokenSecret()).filter(Objects::nonNull).map(this::encode).collect(Collectors.joining("&")).getBytes(StandardCharsets.UTF_8));
            try {
                SecretKeySpec key = new SecretKeySpec(signingKey, algorithm);
                Mac mac = Mac.getInstance(key.getAlgorithm().replace("-", ""));
                mac.init(key);
                return this.encode(Base64.getEncoder().encodeToString(mac.doFinal(signingString.getBytes(StandardCharsets.UTF_8))));
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
        }
        try {
            Signature signature = Signature.getInstance(algorithm.replace("-", ""));
            signature.initSign(configuration.getSigningSignatureKey());
            signature.update(signingString.getBytes(StandardCharsets.UTF_8));
            return this.encode(Base64.getEncoder().encodeToString(signature.sign()));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String signingString(Map<String, String> values, String method, String url) {
        return method.toUpperCase(Locale.ROOT) + "&" + this.encode(this.prepareUrl(url)) + "&" + this.encode(values.entrySet().stream().map(e -> String.format("%s=%s", e.getKey(), e.getValue())).collect(Collectors.joining("&")));
    }

    private String prepareUrl(String url) {
        try {
            URL parsed = new URL(url);
            return parsed.getProtocol() + "://" + parsed.getHost() + (this.shouldSkipPort(parsed) ? "" : ":" + parsed.getPort()) + this.stripQuery(parsed.getFile());
        }
        catch (MalformedURLException e) {
            return this.stripQuery(url);
        }
    }

    private boolean shouldSkipPort(URL parsed) {
        return parsed.getPort() == -1 || parsed.getPort() == 80 && "http".equals(parsed.getProtocol()) || parsed.getPort() == 443 && "https".equals(parsed.getProtocol());
    }

    private String stripQuery(String str) {
        if (str == null) {
            return "";
        }
        if (str.contains("?")) {
            return str.substring(0, str.indexOf(63));
        }
        return str;
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException(uee.getMessage(), uee);
        }
    }

    private String newNonce() {
        return UUID.randomUUID().toString().replace("-", "");
    }
}

