/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.runtime.manager.service.MavenRepositoryResolver;
import org.talend.sdk.component.runtime.manager.service.path.PathHandler;
import org.talend.sdk.component.runtime.manager.service.path.PathHandlerImpl;

public class MavenRepositoryDefaultResolver
implements MavenRepositoryResolver {
    private static final Logger log = LoggerFactory.getLogger(MavenRepositoryDefaultResolver.class);
    private PathHandler handler = new PathHandlerImpl();

    @Override
    public Path discover() {
        return Stream.of(this.fromSystemProperties(), this.fromStudioConfiguration(), this.fromMavenSettings(), this.fromEnvironmentVariables()).filter(Objects::nonNull).findFirst().orElse(this.fallback());
    }

    @Override
    public Path fallback() {
        log.debug("[fallback] default to user's default repository.");
        return Paths.get(USER_HOME, new String[0]).resolve(".m2/repository");
    }

    public Path fromSystemProperties() {
        String m2 = System.getProperty("talend.component.manager.m2.repository");
        if (m2 != null) {
            return this.handler.get(m2);
        }
        log.debug("[fromSystemProperties] Could not get m2 from System property.");
        return null;
    }

    private Path fromStudioConfiguration() {
        String m2Repo = System.getProperty("maven.repository");
        if (!"global".equals(m2Repo)) {
            return this.handler.get(Paths.get(System.getProperty("osgi.configuration.area", ""), ".m2/repository").toString());
        }
        log.debug("[fromStudioConfiguration] Could not get m2 from studio config.");
        return null;
    }

    private static String parseSettings(Path settings) {
        log.debug("[fromMavenSettings] searching for localRepository location in {}", (Object)settings);
        try {
            String localM2RepositoryFromSettings = null;
            String content = new String(Files.readAllBytes(settings), StandardCharsets.UTF_8);
            String stripped = XML_COMMENTS_PATTERN.matcher(content).replaceAll("");
            stripped = XML_EMPTY_LINES_PATTERN.matcher(stripped).replaceAll("");
            Matcher m = XML_LOCAL_REPO_PATTERN.matcher(stripped);
            if (!m.matches()) {
                log.debug("[fromMavenSettings] localRepository not defined in settings.xml");
            } else {
                localM2RepositoryFromSettings = m.group(1).trim();
                if (localM2RepositoryFromSettings != null && !localM2RepositoryFromSettings.isEmpty()) {
                    return localM2RepositoryFromSettings;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Path fromMavenSettings() {
        return Stream.of(System.getProperty("talend.component.manager.m2.settings"), System.getProperty("user.home") + ".m2/settings.xml", System.getenv("MAVEN_HOME") + "conf/settings.xml", System.getenv("M2_HOME") + "conf/settings.xml").filter(Objects::nonNull).map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(MavenRepositoryDefaultResolver::parseSettings).filter(Objects::nonNull).map(this.handler::get).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public Path fromEnvironmentVariables() {
        String vm2 = System.getenv("M2_HOME");
        log.debug("[fromEnvironmentVariables] M2_HOME={}", (Object)vm2);
        if (vm2 != null) {
            return this.handler.get(Paths.get(vm2, "repository").toString());
        }
        log.debug("[fromEnvironmentVariables] Could not get m2 from environment.");
        return null;
    }

    public PathHandler getHandler() {
        return this.handler;
    }

    public void setHandler(PathHandler handler) {
        this.handler = handler;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenRepositoryDefaultResolver)) {
            return false;
        }
        MavenRepositoryDefaultResolver other = (MavenRepositoryDefaultResolver)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PathHandler this$handler = this.getHandler();
        PathHandler other$handler = other.getHandler();
        return !(this$handler == null ? other$handler != null : !this$handler.equals(other$handler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MavenRepositoryDefaultResolver;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PathHandler $handler = this.getHandler();
        result = result * 59 + ($handler == null ? 43 : $handler.hashCode());
        return result;
    }

    public String toString() {
        return "MavenRepositoryDefaultResolver(handler=" + this.getHandler() + ")";
    }
}

