/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service.api;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.runtime.base.Lifecycle;
import org.talend.sdk.component.runtime.manager.ComponentFamilyMeta;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.runtime.manager.ContainerComponentRegistry;

@FunctionalInterface
public interface ComponentInstantiator {
    public Lifecycle instantiate(Map<String, String> var1, int var2);

    public static class ComponentNameFinder
    implements MetaFinder {
        private static final Logger log = LoggerFactory.getLogger(ComponentNameFinder.class);
        private final String componentName;

        @Override
        public Optional<? extends ComponentFamilyMeta.BaseMeta> filter(Map<String, ? extends ComponentFamilyMeta.BaseMeta> source) {
            if (!source.containsKey(this.componentName)) {
                log.warn("Can't find component name {}", (Object)this.componentName);
            }
            return Optional.ofNullable(source.get(this.componentName));
        }

        public ComponentNameFinder(String componentName) {
            this.componentName = componentName;
        }
    }

    public static class BuilderDefault
    implements Builder {
        private static final Logger log = LoggerFactory.getLogger(BuilderDefault.class);
        private final Supplier<Stream<ContainerComponentRegistry>> registrySupplier;

        @Override
        public ComponentInstantiator build(String familyName, MetaFinder finder, ComponentManager.ComponentType componentType) {
            Stream<ContainerComponentRegistry> registries = this.registrySupplier.get();
            if (registries == null) {
                return null;
            }
            return registries.map(registry -> registry.findComponentFamily(familyName)).filter(Objects::nonNull).peek(cm -> log.debug("Family found {}", (Object)familyName)).findFirst().map(componentType::findMeta).flatMap(map -> finder.filter((Map<String, ? extends ComponentFamilyMeta.BaseMeta>)map)).map(c -> c::instantiate).orElse(null);
        }

        public BuilderDefault(Supplier<Stream<ContainerComponentRegistry>> registrySupplier) {
            this.registrySupplier = registrySupplier;
        }
    }

    @FunctionalInterface
    public static interface Builder {
        public ComponentInstantiator build(String var1, MetaFinder var2, ComponentManager.ComponentType var3);
    }

    public static interface MetaFinder {
        public Optional<? extends ComponentFamilyMeta.BaseMeta> filter(Map<String, ? extends ComponentFamilyMeta.BaseMeta> var1);

        public static MetaFinder ofComponent(String name) {
            return new ComponentNameFinder(name);
        }
    }
}

